/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.event;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.game.Game;
import com.floodeer.bowspleef.game.player.GamePlayer;
import com.floodeer.bowspleef.game.structure.GameArena;
import com.floodeer.bowspleef.util.Util;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class SignEvent
implements Listener {
    @EventHandler
    public void signPlaced(SignChangeEvent event) {
        String[] lines = event.getLines();
        if (lines[0].equalsIgnoreCase("[BowSpleef]") && lines[1].equalsIgnoreCase("join")) {
            if (!event.getPlayer().hasPermission("BowSpleef.admin")) {
                return;
            }
            Location loc = event.getBlock().getLocation();
            World w = loc.getWorld();
            Block b = w.getBlockAt(loc);
            if (Util.isWallSign(b)) {
                event.setCancelled(true);
                String in = lines[2];
                if (BowSpleef.get().getGM().doesMapExists(in)) {
                    GameArena gMap = BowSpleef.get().getGM().getGameFromName(in).getGameArena();
                    gMap.addSign((Sign)event.getBlock().getState(), loc);
                    gMap.updateSign();
                } else {
                    loc.getBlock().breakNaturally();
                    event.getPlayer().sendMessage(Util.colorString("&cInvalid arena.", new Player[0]));
                }
            }
        }
    }

    @EventHandler
    public void onBreak(BlockBreakEvent e) {
        if (Util.isWallSign(e.getBlock())) {
            for (Game game : BowSpleef.get().getGM().getGames()) {
                GameArena gMap = BowSpleef.get().getGM().getGameFromName(game.getName()).getGameArena();
                if (!gMap.doesMapExists() || !((Sign)e.getBlock().getState()).getLine(2).equalsIgnoreCase(gMap.getName()) || !e.getBlock().getLocation().equals((Object)gMap.getSign())) continue;
                gMap.breakSign((Sign)e.getBlock().getState());
            }
        }
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent e) {
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Block b = e.getClickedBlock();
            GamePlayer gp = GamePlayer.get(e.getPlayer().getUniqueId());
            if (Util.isWallSign(b)) {
                for (Game game : BowSpleef.get().getGM().getGames()) {
                    GameArena gMap = BowSpleef.get().getGM().getGameFromName(game.getName()).getGameArena();
                    if (!gMap.doesMapExists() || !((Sign)b.getState()).getLine(2).equalsIgnoreCase(ChatColor.stripColor((String)gMap.getName())) || !b.getLocation().equals((Object)gMap.getSign())) continue;
                    if (game.getState() != Game.GameState.PRE_GAME && game.getState() != Game.GameState.STARTING) {
                        if (game.getState() == Game.GameState.RESTORING) {
                            e.getPlayer().sendMessage(Util.colorString(BowSpleef.get().getLanguage().restoring, e.getPlayer()));
                        } else {
                            e.getPlayer().sendMessage(Util.colorString(BowSpleef.get().getLanguage().started, e.getPlayer()));
                        }
                        e.setCancelled(true);
                        return;
                    }
                    if (game.getPlayers().size() >= game.getMaxPlayers() && !e.getPlayer().hasPermission("BowSpleef.joinfull")) {
                        e.getPlayer().sendMessage(Util.colorString(BowSpleef.get().getLanguage().gamefull, e.getPlayer()));
                        e.setCancelled(true);
                        return;
                    }
                    if (GamePlayer.get(e.getPlayer().getUniqueId()).isInGame()) {
                        e.getPlayer().sendMessage(Util.colorString(BowSpleef.get().getLanguage().ingame, e.getPlayer()));
                        e.setCancelled(true);
                        return;
                    }
                    game.addPlayer(gp);
                    gMap.updateSign();
                }
            }
        }
    }
}

