/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.event;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.achievement.AchievementType;
import com.floodeer.bowspleef.achievement.PlayerAchievement;
import com.floodeer.bowspleef.cosmestics.ShopMenu;
import com.floodeer.bowspleef.game.Game;
import com.floodeer.bowspleef.game.GameSpectator;
import com.floodeer.bowspleef.game.player.GamePlayer;
import com.floodeer.bowspleef.game.structure.ArenaCuboid;
import com.floodeer.bowspleef.game.structure.GameArena;
import com.floodeer.bowspleef.util.ItemFactory;
import com.floodeer.bowspleef.util.LocationUtils;
import com.floodeer.bowspleef.util.Runner;
import com.floodeer.bowspleef.util.Selector;
import com.floodeer.bowspleef.util.Util;
import com.floodeer.bowspleef.util.update.UpdateEvent;
import com.floodeer.bowspleef.util.update.UpdateType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public class PlayerEvent
implements Listener {
    private final Map<Player, List<Projectile>> projectileParticles = Maps.newHashMap();

    @EventHandler
    public void onSchedule(UpdateEvent event) {
        if (event.getType() == UpdateType.TICK && BowSpleef.get().getOptions().enableTrails) {
            for (Player p : this.projectileParticles.keySet()) {
                GamePlayer gp = BowSpleef.get().getPM().getPlayer(p.getUniqueId());
                List<Projectile> list = this.projectileParticles.get(gp.getPlayer());
                for (Projectile pr : list) {
                    Arrow a = (Arrow)pr;
                    if (!gp.isInGame() || gp.isSpectator() || a.isDead() || gp.getTrail() <= 0 || !Util.isValidParticle(BowSpleef.get().getTC().getParticles(gp.getTrail()))) continue;
                    boolean ppp = BowSpleef.get().getOptions().perPlayerParticle;
                    Util.displayParticles(ppp ? gp.getPlayer() : null, BowSpleef.get().getTC().getParticles(gp.getTrail()), 0.0f, 0.0f, 0.0f, 0.1f, 1, a.getLocation(), 120);
                }
            }
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        new Runner(BowSpleef.get()).delay(8).run(() -> {
            if (BowSpleef.get().getOptions().offlineMode) {
                BowSpleef.get().getPM().addPlayer(e.getPlayer());
            } else {
                BowSpleef.get().getPM().addPlayer(e.getPlayer().getUniqueId());
            }
        });
        new Runner(BowSpleef.get()).delay(20).run(() -> {
            GamePlayer gp = GamePlayer.get(e.getPlayer().getUniqueId());
            if (BowSpleef.get().getOptions().isBungeeCord) {
                Game game = null;
                game = BowSpleef.get().getOptions().multipleGames ? BowSpleef.get().getGM().getNextGame(null) : BowSpleef.get().getGM().getGames().get(0);
                if (game == null) {
                    e.getPlayer().kickPlayer(ChatColor.RED + "An unexpected error has occurred.");
                    return;
                }
                if (game.getState() == Game.GameState.IN_GAME) {
                    // empty if block
                }
                game.addPlayer(gp);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onChat(AsyncPlayerChatEvent e) {
        Player p = e.getPlayer();
        if (BowSpleef.get().getPM().getPlayer(p.getUniqueId()) == null) {
            return;
        }
        GamePlayer gp = BowSpleef.get().getPM().getPlayer(p.getUniqueId());
        if (gp.isInGame() && BowSpleef.get().getOptions().perArenaChat) {
            e.setCancelled(true);
            if (gp.isSpectator()) {
                gp.getGame().getSpectators().forEach(players -> players.getPlayer().sendMessage(Util.setPlaceholders(p, BowSpleef.get().getLanguage().specChatFormat.replaceAll("%teamColor%", gp.getTeam() == null || gp.getGame().getState() == Game.GameState.PRE_GAME ? ChatColor.GRAY.toString() : gp.getTeam().getColor().toString()).replace("%playername%", p.getName()).replace("%displayname%", p.getDisplayName()).replace("%message%", e.getMessage()))));
            } else {
                gp.getGame().getPlayers().forEach(players -> players.getPlayer().sendMessage(Util.setPlaceholders(p, BowSpleef.get().getLanguage().chatFormat.replaceAll("%teamColor%", gp.getTeam() == null || gp.getGame().getState() == Game.GameState.PRE_GAME ? ChatColor.GRAY.toString() : gp.getTeam().getColor().toString()).replace("%playername%", p.getName()).replace("%displayname%", p.getDisplayName()).replace("%message%", e.getMessage()))));
            }
        }
    }

    @EventHandler
    public void onKick(PlayerKickEvent e) {
        GamePlayer gp;
        if (GamePlayer.get(e.getPlayer()) != null && (gp = GamePlayer.get(e.getPlayer())).isInGame()) {
            gp.getGame().removePlayer(gp, false, true);
        }
        this.projectileParticles.remove(e.getPlayer());
        BowSpleef.get().getPM().removePlayer(e.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        GamePlayer gp;
        if (GamePlayer.get(e.getPlayer()) != null && (gp = GamePlayer.get(e.getPlayer())).isInGame()) {
            gp.getGame().removePlayer(gp, false, true);
        }
        this.projectileParticles.remove(e.getPlayer());
        BowSpleef.get().getPM().removePlayer(e.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        if (event.getEntity() instanceof Arrow && event.getEntity().hasMetadata("BSArrow")) {
            Player player = (Player)event.getEntity().getShooter();
            if (player == null) {
                return;
            }
            GamePlayer gp = GamePlayer.get(player);
            if (gp.isInGame()) {
                BlockIterator iter = new BlockIterator(event.getEntity().getWorld(), event.getEntity().getLocation().toVector(), event.getEntity().getVelocity().normalize(), 0.0, 4);
                Block b = null;
                while (iter.hasNext() && (b = iter.next()).getType() == Material.AIR) {
                }
                if (b == null) {
                    return;
                }
                Location loc = b.getLocation();
                Runner.make(BowSpleef.get()).delay(10).run(() -> Arrays.stream(LocationUtils.getNearbyEntities(loc, 6)).filter(cur -> cur instanceof TNTPrimed).forEach(Entity::remove));
                event.getEntity().remove();
            }
        }
    }

    @EventHandler
    public void onShoot(EntityShootBowEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        GamePlayer gp = GamePlayer.get(player);
        if (gp.isInGame()) {
            if (gp.getGame().isInGracePeriod()) {
                event.setCancelled(true);
                return;
            }
            Arrow projectile = (Arrow)event.getProjectile();
            projectile.setMetadata("BSArrow", (MetadataValue)new FixedMetadataValue((Plugin)BowSpleef.get(), null));
            projectile.setFireTicks(Integer.MAX_VALUE);
            projectile.setCritical(false);
            gp.setArrowsShot(gp.getArrowsShot() + 1);
            gp.getGame().addShotsFired(gp, 1);
            PlayerAchievement.check(gp, AchievementType.SHOTS, gp.getArrowsShot());
            this.projectileParticles.computeIfAbsent(player, k -> Lists.newArrayList()).add(projectile);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCommand(PlayerCommandPreprocessEvent e) {
        if (GamePlayer.get(e.getPlayer()) != null && GamePlayer.get(e.getPlayer()).isInGame()) {
            if (e.getPlayer().hasPermission("bowspleef.admin")) {
                return;
            }
            String[] splited = e.getMessage().split("\\s+");
            for (String a1 : BowSpleef.get().getOptions().allowedCmds) {
                if (!(splited.length == 1 ? splited[0].equalsIgnoreCase("/" + a1) : splited.length > 1 && (splited[0].equalsIgnoreCase("/" + a1) || (splited[0] + " " + splited[1]).equalsIgnoreCase("/" + a1)))) continue;
                return;
            }
            e.setCancelled(true);
            e.getPlayer().sendMessage(Util.colorString(BowSpleef.get().getLanguage().failedCommand, e.getPlayer()));
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        if (GamePlayer.get(e.getPlayer()) == null) {
            return;
        }
        if (GamePlayer.get(e.getPlayer()).isInGame()) {
            GamePlayer gp = GamePlayer.get(e.getPlayer());
            if (gp.getGame().getState() == Game.GameState.PRE_GAME) {
                if (gp.getPlayer().getLocation().getY() <= 0.0) {
                    gp.getPlayer().teleport(gp.getGame().getGameArena().getLocation(GameArena.LocationType.LOBBY));
                }
                return;
            }
            if (e.getTo().getY() <= 0.0) {
                if (!gp.isSpectator() && gp.getGame().getState() == Game.GameState.IN_GAME && !gp.getGame().isInGracePeriod()) {
                    gp.getPlayer().getWorld().strikeLightningEffect(gp.getPlayer().getLocation());
                    gp.getGame().eliminatePlayer(gp);
                } else {
                    gp.getPlayer().teleport(gp.getGame().getGameArena().getLocation(GameArena.LocationType.SPEC_SPAWN));
                }
            }
            if (gp.isInGame() && gp.getGame().getState() == Game.GameState.IN_GAME) {
                if (!BowSpleef.get().getOptions().isDjEnabled) {
                    return;
                }
                if (gp.getGame().isInGracePeriod()) {
                    return;
                }
                if (gp.getPlayer().getGameMode() != GameMode.CREATIVE && gp.getPlayer().getLocation().subtract(0.0, 1.0, 0.0).getBlock().getType() != Material.AIR && !gp.getPlayer().isFlying()) {
                    if (gp.getDoubleJumps() <= 0) {
                        return;
                    }
                    gp.getPlayer().setAllowFlight(true);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerFlight(PlayerToggleFlightEvent e) {
        Player p = e.getPlayer();
        if (GamePlayer.get(p.getUniqueId()) == null) {
            return;
        }
        GamePlayer gp = GamePlayer.get(p.getUniqueId());
        if (gp.isInGame()) {
            if (!BowSpleef.get().getOptions().isDjEnabled) {
                return;
            }
            if (gp.getDoubleJumps() == 0) {
                return;
            }
            if (gp.isSpectator()) {
                return;
            }
            if (gp.getGame().getState() != Game.GameState.IN_GAME) {
                return;
            }
            if (gp.getGame().isInGracePeriod()) {
                return;
            }
            e.setCancelled(true);
            p.setAllowFlight(false);
            p.setFlying(false);
            Util.playSound(gp, BowSpleef.get().getOptions().djSound);
            gp.setDoubleJumps(gp.getDoubleJumps() - 1);
            p.setVelocity(p.getLocation().getDirection().multiply(BowSpleef.get().getOptions().djMultiplyForward).setY(BowSpleef.get().getOptions().djMultiplyY));
        }
    }

    @EventHandler
    public void onSelectorInteract(PlayerInteractEvent e) {
        if (ItemFactory.hasName(e.getItem(), Util.colorString("&6BowSpleef's Wand", new Player[0])) && (e.getAction() == Action.LEFT_CLICK_BLOCK || e.getAction() == Action.RIGHT_CLICK_BLOCK)) {
            e.setCancelled(true);
            if (e.getAction() == Action.LEFT_CLICK_BLOCK) {
                Location l = e.getClickedBlock().getLocation();
                if (!BowSpleef.get().getSelector().getSelection().containsKey(e.getPlayer())) {
                    BowSpleef.get().getSelector().getSelection().put(e.getPlayer(), new Selector.CustomSelection(e.getPlayer()));
                }
                BowSpleef.get().getSelector().getSelection().get((Object)e.getPlayer()).low = l;
                e.getPlayer().sendMessage(Util.colorString("&aLocation selected.", new Player[0]));
            } else if (e.getAction() == Action.RIGHT_CLICK_BLOCK) {
                Location l = e.getClickedBlock().getLocation();
                if (!BowSpleef.get().getSelector().getSelection().containsKey(e.getPlayer())) {
                    BowSpleef.get().getSelector().getSelection().put(e.getPlayer(), new Selector.CustomSelection(e.getPlayer()));
                }
                BowSpleef.get().getSelector().getSelection().get((Object)e.getPlayer()).high = l;
                e.getPlayer().sendMessage(Util.colorString("&aLocation selected.", new Player[0]));
            }
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if ((event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) && event.getItem() != null && event.getItem().getType() != Material.AIR && event.getItem().getType() == Material.BOW) {
            Player player = event.getPlayer();
            GamePlayer gp = GamePlayer.get(player);
            if (!gp.isInGame()) {
                return;
            }
            if (gp.getGame().getState() != Game.GameState.IN_GAME) {
                return;
            }
            if (gp.getGame().isInGracePeriod()) {
                return;
            }
            if (gp.getTripleShots() >= 1) {
                Arrow[] arrow = new Arrow[3];
                for (int i = 0; i < 3; ++i) {
                    arrow[i] = (Arrow)player.launchProjectile(Arrow.class);
                    arrow[i].setCritical(false);
                    arrow[i].setFireTicks(Integer.MAX_VALUE);
                    arrow[i].setMetadata("BSArrow", (MetadataValue)new FixedMetadataValue((Plugin)BowSpleef.get(), null));
                }
                if (Util.getDirection(Float.valueOf(player.getLocation().getYaw())).equalsIgnoreCase("WEST") || Util.getDirection(Float.valueOf(player.getLocation().getYaw())).equalsIgnoreCase("EAST")) {
                    arrow[1].setVelocity(new Vector(arrow[1].getVelocity().getX(), arrow[1].getVelocity().getY(), arrow[1].getVelocity().getZ() - 0.4));
                    arrow[2].setVelocity(new Vector(arrow[2].getVelocity().getX(), arrow[2].getVelocity().getY(), arrow[2].getVelocity().getZ() + 0.4));
                } else {
                    arrow[1].setVelocity(new Vector(arrow[1].getVelocity().getX() - 0.4, arrow[1].getVelocity().getY(), arrow[1].getVelocity().getZ()));
                    arrow[2].setVelocity(new Vector(arrow[2].getVelocity().getX() + 0.4, arrow[2].getVelocity().getY(), arrow[2].getVelocity().getZ()));
                }
                gp.setTripleShots(gp.getTripleShots() - 1);
                gp.setArrowsShot(gp.getArrowsShot() + 3);
                gp.getGame().addShotsFired(gp, 3);
                PlayerAchievement.check(gp, AchievementType.SHOTS, gp.getArrowsShot());
                this.projectileParticles.computeIfAbsent(player, k -> Lists.newArrayList()).addAll(Arrays.asList(arrow));
            }
        }
    }

    @EventHandler
    public void inGameInteract(PlayerInteractEvent e) {
        if (GamePlayer.get(e.getPlayer()) != null) {
            if (e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) {
                Player p = e.getPlayer();
                GamePlayer gp = BowSpleef.get().getPM().getPlayer(p.getUniqueId());
                ItemStack leave = ItemFactory.parse(BowSpleef.get().getOptions().leaveItemType);
                ItemStack shop = ItemFactory.parse(BowSpleef.get().getOptions().shopItemType);
                ItemStack spectator = ItemFactory.parse(BowSpleef.get().getOptions().spectatorItem);
                if (gp.isInGame()) {
                    if (e.getItem() != null && e.getItem().isSimilar(leave)) {
                        gp.getGame().removePlayer(gp, false, false);
                        e.setCancelled(true);
                    } else if (e.getItem() != null && e.getItem().isSimilar(shop)) {
                        ShopMenu.show(e.getPlayer());
                    } else if (e.getItem() != null && e.getItem().isSimilar(spectator)) {
                        GameSpectator.showGameSpectator(gp);
                    }
                }
            }
            if (GamePlayer.get(e.getPlayer()).isInGame()) {
                e.setUseInteractedBlock(Event.Result.DENY);
            }
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && GamePlayer.get(player = (Player)event.getEntity()) != null && GamePlayer.get(player).isInGame()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (GamePlayer.get(event.getPlayer()) != null && GamePlayer.get(event.getPlayer().getUniqueId()).isInGame()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlace(BlockPlaceEvent event) {
        if (GamePlayer.get(event.getPlayer()) != null && GamePlayer.get(event.getPlayer().getUniqueId()).isInGame()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void itemFrame(PlayerInteractEntityEvent event) {
        if (event.getRightClicked().getType().equals((Object)EntityType.ITEM_FRAME) && GamePlayer.get(event.getPlayer()) != null && GamePlayer.get(event.getPlayer()).isInGame()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPickup(PlayerPickupItemEvent event) {
        Player p = event.getPlayer();
        if (GamePlayer.get(p) == null) {
            return;
        }
        GamePlayer gp = GamePlayer.get(p.getUniqueId());
        if (gp.isInGame()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        Player p = event.getPlayer();
        if (GamePlayer.get(p) == null) {
            return;
        }
        GamePlayer gp = GamePlayer.get(p.getUniqueId());
        if (gp.isInGame()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void food(FoodLevelChangeEvent event) {
        Player p;
        GamePlayer gp;
        if (event.getEntity() instanceof Player && (gp = GamePlayer.get((p = (Player)event.getEntity()).getUniqueId())) != null && gp.isInGame()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void inventoryClick(InventoryClickEvent event) {
        Player p = (Player)event.getWhoClicked();
        GamePlayer gp = GamePlayer.get(p.getUniqueId());
        if (gp.isInGame()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockBurn(BlockBurnEvent event) {
        if (BowSpleef.get().getGM().getGames().isEmpty()) {
            return;
        }
        for (Game game : BowSpleef.get().getGM().getGames()) {
            ArenaCuboid c = game.getGameArena().getCuboid();
            if (!c.containsLocWithoutY(event.getBlock().getLocation())) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onExplode(BlockExplodeEvent event) {
        for (Game game : BowSpleef.get().getGM().getGames()) {
            if (game.getGameArena().getCuboid() == null) {
                return;
            }
            ArenaCuboid c = game.getGameArena().getCuboid();
            if (!c.containsLocWithoutY(event.getBlock().getLocation())) continue;
            event.setCancelled(true);
        }
    }
}

