/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.event;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.game.Game;
import com.floodeer.bowspleef.game.structure.GameArena;
import com.floodeer.bowspleef.util.Util;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

public class BungeeEventListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onBungee(AsyncPlayerPreLoginEvent e) {
        if (BowSpleef.get().getOptions().isBungeeCord) {
            if (BowSpleef.get().getGM().getGames().isEmpty() && !Bukkit.getPlayer((String)e.getName()).hasPermission("bowspleef.setup")) {
                e.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, Util.setPlaceholders(Bukkit.getPlayer((UUID)e.getUniqueId()), ChatColor.translateAlternateColorCodes((char)'&', (String)"&cThere is no games on this server!")));
                return;
            }
            Game game = null;
            game = BowSpleef.get().getOptions().multipleGames ? BowSpleef.get().getGM().getNextGame(null) : BowSpleef.get().getGM().getGames().get(0);
            if (game.getState() != Game.GameState.PRE_GAME && game.getState() != Game.GameState.STARTING) {
                e.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, Util.setPlaceholders(Bukkit.getPlayer((UUID)e.getUniqueId()), ChatColor.translateAlternateColorCodes((char)'&', (String)BowSpleef.get().getLanguage().started)));
                return;
            }
            if (game.getPlayers().size() >= game.getGameArena().getMaxPlayers() && !Objects.requireNonNull(Bukkit.getPlayer((String)e.getName())).hasPermission("BowSpleef.joinfull")) {
                e.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, Util.setPlaceholders(Bukkit.getPlayer((UUID)e.getUniqueId()), ChatColor.translateAlternateColorCodes((char)'&', (String)BowSpleef.get().getLanguage().gamefull)));
            }
        }
    }

    @EventHandler
    public void onLogin(PlayerLoginEvent e) {
        if (BowSpleef.get().getOptions().isBungeeCord) {
            if (BowSpleef.get().getGM().getGames().isEmpty() && !Objects.requireNonNull(Bukkit.getPlayer((String)e.getPlayer().getName())).hasPermission("BowSpleef.setup")) {
                e.disallow(PlayerLoginEvent.Result.KICK_OTHER, Util.setPlaceholders(e.getPlayer(), ChatColor.translateAlternateColorCodes((char)'&', (String)"&cThere is no games on this server!")));
                return;
            }
            if (!BowSpleef.IS_PLUGIN_ENABLED) {
                e.disallow(PlayerLoginEvent.Result.KICK_OTHER, Util.setPlaceholders(e.getPlayer(), ChatColor.translateAlternateColorCodes((char)'&', (String)"&cPlease try again in 3 seconds!")));
            }
        }
    }

    @EventHandler
    public void spawn(PlayerSpawnLocationEvent e) {
        Game game = null;
        if (BowSpleef.get().getGM().getGames().isEmpty() || BowSpleef.get().getGM().getGames().get(0) == null) {
            return;
        }
        game = BowSpleef.get().getGM().getGames().get(0);
        if (BowSpleef.get().getOptions().isBungeeCord) {
            e.setSpawnLocation(game.getGameArena().getLocation(GameArena.LocationType.LOBBY));
        }
    }

    @EventHandler
    public void handlerMotd(ServerListPingEvent e) {
        Game game = null;
        if (BowSpleef.get().getGM().getGames().isEmpty() || BowSpleef.get().getGM().getGames().get(0) == null) {
            return;
        }
        game = BowSpleef.get().getGM().getGames().get(0);
        if (game.getState() == Game.GameState.PRE_GAME) {
            e.setMotd(Util.colorString(BowSpleef.get().getLanguage().waitingMotd, new Player[0]));
        } else if (game.getState() == Game.GameState.STARTING) {
            e.setMotd(Util.colorString(BowSpleef.get().getLanguage().startingMotd, new Player[0]));
        } else if (game.getState() == Game.GameState.IN_GAME) {
            e.setMotd(Util.colorString(BowSpleef.get().getLanguage().ingameMotd, new Player[0]));
        } else if (game.getState() == Game.GameState.ENDING) {
            e.setMotd(Util.colorString(BowSpleef.get().getLanguage().endingMotd, new Player[0]));
        } else if (game.getState() == Game.GameState.RESTORING) {
            e.setMotd(Util.colorString(BowSpleef.get().getLanguage().resettingMotd, new Player[0]));
        }
    }
}

