/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.cosmestics;

import com.floodeer.bowspleef.BowSpleef;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;

public class TrailsCosmetic {
    private File file;
    private YamlConfiguration config;

    public void loadAll() {
        this.file = new File(BowSpleef.get().getDataFolder() + File.separator + "trailEffects.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        if (!this.file.exists()) {
            this.loadDefaults();
        }
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    private void loadDefaults() {
        this.config.set("1.name", (Object)"&cFirework Arrow");
        this.config.set("1.permission", (Object)"bs.trails.unlock.firework");
        this.config.set("1.buyPermission", (Object)"bs.trails.firework");
        this.config.set("1.particles", (Object)"FIREWORKS_SPARK");
        this.config.set("1.menuItem", (Object)"FIREWORK : 1");
        this.config.set("1.lore", Collections.singletonList("&eDisplays firework particles on your arrows!"));
        this.config.set("1.buyCommands", Collections.singletonList("pex user %player% add %permission%"));
        this.config.set("1.price", (Object)18000);
        this.config.set("1.slot", (Object)11);
        this.config.set("2.name", (Object)"&cLove Arrow");
        this.config.set("2.permission", (Object)"bs.trails.unlock.love");
        this.config.set("2.buyPermission", (Object)"bs.trails.love");
        this.config.set("2.particles", (Object)"HEART");
        this.config.set("2.menuItem", (Object)"RED_ROSE : 1");
        this.config.set("2.lore", Collections.singletonList("&eDisplays heart particles on your arrows!"));
        this.config.set("2.buyCommands", Collections.singletonList("pex user %player% add %permission%"));
        this.config.set("2.price", (Object)12000);
        this.config.set("2.slot", (Object)12);
        this.config.set("3.name", (Object)"&cMusic Arrow");
        this.config.set("3.permission", (Object)"bs.trails.unlock.music");
        this.config.set("3.buyPermission", (Object)"bs.trails.music");
        this.config.set("3.particles", (Object)"note");
        this.config.set("3.menuItem", (Object)"NOTE_BLOCK : 1");
        this.config.set("3.lore", Collections.singletonList("&eDisplays note particles on your arrows!"));
        this.config.set("3.buyCommands", Collections.singletonList("pex user %player% add %permission%"));
        this.config.set("3.price", (Object)15000);
        this.config.set("3.slot", (Object)13);
        this.config.set("4.name", (Object)"&cExplosive Arrow");
        this.config.set("4.permission", (Object)"bs.trails.unlock.explosion");
        this.config.set("4.buyPermission", (Object)"bs.trails.explosion");
        this.config.set("4.particles", (Object)"EXPLOSION_NORMAL");
        this.config.set("4.menuItem", (Object)"TNT : 1");
        this.config.set("4.lore", Collections.singletonList("&eDisplays explosion particles on your arrows!"));
        this.config.set("4.buyCommands", Collections.singletonList("pex user %player% add %permission%"));
        this.config.set("4.price", (Object)50000);
        this.config.set("4.slot", (Object)15);
        this.config.set("5.name", (Object)"&cWater Arrow");
        this.config.set("5.permission", (Object)"bs.trails.unlock.water");
        this.config.set("5.buyPermission", (Object)"bs.trails.water");
        this.config.set("5.particles", (Object)"DRIP_WATER");
        this.config.set("5.menuItem", (Object)"WATER_BUCKET : 1");
        this.config.set("5.lore", Collections.singletonList("&eDisplays drip water particles on your arrows!"));
        this.config.set("5.buyCommands", Collections.singletonList("pex user %player% add %permission%"));
        this.config.set("5.price", (Object)15000);
        this.config.set("5.slot", (Object)14);
        this.config.set("6.name", (Object)"&cBlizzard Arrow");
        this.config.set("6.permission", (Object)"bs.trails.unlock.blizzard");
        this.config.set("6.buyPermission", (Object)"bs.trails.blizzard");
        this.config.set("6.particles", (Object)"SNOWBALL");
        this.config.set("6.menuItem", (Object)"SNOW_BALL : 1");
        this.config.set("6.lore", Collections.singletonList("&eDisplays snowball particles on your arrows!"));
        this.config.set("6.buyCommands", Collections.singletonList("pex user %player% add %permission%"));
        this.config.set("6.price", (Object)12000);
        this.config.set("6.slot", (Object)16);
        this.config.set("7.name", (Object)"&cLava Arrow");
        this.config.set("7.permission", (Object)"bs.trails.unlock.lava");
        this.config.set("7.buyPermission", (Object)"bs.trails.lava");
        this.config.set("7.particles", (Object)"DRIP_LAVA");
        this.config.set("7.menuItem", (Object)"LAVA_BUCKET : 1");
        this.config.set("7.lore", Collections.singletonList("&eDisplays drip lava particles on your arrows!"));
        this.config.set("7.buyCommands", Collections.singletonList("pex user %player% add %permission%"));
        this.config.set("7.price", (Object)10000);
        this.config.set("7.slot", (Object)19);
        this.config.set("8.name", (Object)"&cFlame Arrow");
        this.config.set("8.permission", (Object)"bs.trails.unlock.flames");
        this.config.set("8.buyPermission", (Object)"bs.trails.flames");
        this.config.set("8.particles", (Object)"FLAME");
        this.config.set("8.menuItem", (Object)"BLAZE_POWDER : 1");
        this.config.set("8.lore", Collections.singletonList("&eDisplays flames particles your on arrows!"));
        this.config.set("8.buyCommands", Collections.singletonList("pex user %player% add %permission%"));
        this.config.set("8.price", (Object)20000);
        this.config.set("8.slot", (Object)10);
        this.save();
    }

    public boolean containsEffect(int i) {
        return this.config.contains(i + ".name");
    }

    public List<String> getBuyCommands(int i) {
        return this.config.getStringList(i + ".buyCommands");
    }

    public String getItem(int i) {
        return this.config.getString(i + ".menuItem");
    }

    public List<String> getLore(int i) {
        return this.config.getStringList(i + ".lore");
    }

    public String getName(int i) {
        return this.config.getString(i + ".name");
    }

    public int getPrice(int i) {
        return this.config.getInt(i + ".price");
    }

    public String getPermissionToUnlock(int i) {
        return this.config.getString(i + ".permission");
    }

    public String getPermissionToBuy(int i) {
        return this.config.getString(i + ".buyPermission");
    }

    public String getParticles(int i) {
        return this.config.getString(i + ".particles");
    }

    public int getSlot(int i) {
        return this.config.getInt(i + ".slot");
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

