/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.cosmestics;

import com.floodeer.bowspleef.BowSpleef;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;

public class EffectsCosmetic {
    private File file;
    private YamlConfiguration config;

    public void loadAll() {
        this.file = new File(BowSpleef.get().getDataFolder() + File.separator + "effects.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        if (!this.file.exists()) {
            this.loadDefaults();
        }
    }

    public static boolean exists(int i) {
        return BowSpleef.MAX_EFFECTS <= i;
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    private void loadDefaults() {
        this.config.set("1.name", (Object)"&cRedstone");
        this.config.set("1.permission", (Object)"bs.unlock.redstone");
        this.config.set("1.buyPermission", (Object)"bs.redstone");
        this.config.set("1.particles", (Object)"REDSTONE");
        this.config.set("1.menuItem", (Object)"REDSTONE_BLOCK : 1");
        this.config.set("1.helmet", (Object)"REDSTONE_BLOCK : 1");
        this.config.set("1.lore", Arrays.asList("&eDisplays redstone particles in-game!", "&eGives you a cosmetic redstone block helmet!"));
        this.config.set("1.buyCommands", Collections.singletonList("pex user %player% add %permission%"));
        this.config.set("1.price", (Object)18000);
        this.config.set("1.slot", (Object)11);
        this.config.set("1.rotateParticles", (Object)false);
        this.config.set("2.name", (Object)"&cLover");
        this.config.set("2.permission", (Object)"bs.unlock.love");
        this.config.set("2.buyPermission", (Object)"bs.love");
        this.config.set("2.particles", (Object)"HEART");
        this.config.set("2.menuItem", (Object)"RED_ROSE : 1");
        this.config.set("2.helmet", (Object)"GOLD_HELMET : 1");
        this.config.set("2.lore", Arrays.asList("&eDisplays heart particles in-game!", "&eGives you a cosmetic gold helmet!"));
        this.config.set("2.buyCommands", Collections.singletonList("pex user %player% add %permission%"));
        this.config.set("2.price", (Object)16000);
        this.config.set("2.slot", (Object)12);
        this.config.set("2.rotateParticles", (Object)true);
        this.config.set("3.name", (Object)"&cMusic Lover");
        this.config.set("3.permission", (Object)"bs.unlock.music");
        this.config.set("3.buyPermission", (Object)"bs.music");
        this.config.set("3.particles", (Object)"NOTE");
        this.config.set("3.menuItem", (Object)"NOTE_BLOCK : 1");
        this.config.set("3.helmet", (Object)"NOTE_BLOCK : 1");
        this.config.set("3.lore", Arrays.asList("&eDisplays note particles in-game!", "&eGives you a cosmetic noteblock helmet!"));
        this.config.set("3.buyCommands", Collections.singletonList("pex user %player% add %permission%"));
        this.config.set("3.price", (Object)14000);
        this.config.set("3.slot", (Object)13);
        this.config.set("3.rotateParticles", (Object)true);
        this.config.set("4.name", (Object)"&cAngry");
        this.config.set("4.permission", (Object)"bs.unlock.angry");
        this.config.set("4.buyPermission", (Object)"bs.angry");
        this.config.set("4.particles", (Object)"VILLAGER_ANGRY");
        this.config.set("4.menuItem", (Object)"JACK_O_LANTERN : 1");
        this.config.set("4.helmet", (Object)"JACK_O_LANTERN : 1");
        this.config.set("4.lore", Arrays.asList("&eDisplays note particles in-game!", "&eGives you a cosmetic jack o'lantern helmet!"));
        this.config.set("4.buyCommands", Collections.singletonList("pex user %player% add %permission%"));
        this.config.set("4.price", (Object)12000);
        this.config.set("4.slot", (Object)14);
        this.config.set("4.rotateParticles", (Object)true);
        this.config.set("5.name", (Object)"&cFireworks");
        this.config.set("5.permission", (Object)"bs.unlock.firework");
        this.config.set("5.buyPermission", (Object)"bs.firework");
        this.config.set("5.particles", (Object)"FIREWORKS_SPARK");
        this.config.set("5.menuItem", (Object)"FIREWORK : 1");
        this.config.set("5.helmet", (Object)"IRON_HELMET : 1");
        this.config.set("5.lore", Arrays.asList("&eDisplays note particles in-game!", "&eGives you a cosmetic iron helmet!"));
        this.config.set("5.buyCommands", Collections.singletonList("pex user %player% add %permission%"));
        this.config.set("5.price", (Object)10000);
        this.config.set("5.slot", (Object)15);
        this.config.set("5.rotateParticles", (Object)true);
        this.config.set("6.name", (Object)"&cWater");
        this.config.set("6.permission", (Object)"bs.unlock.water");
        this.config.set("6.buyPermission", (Object)"bs.water");
        this.config.set("6.particles", (Object)"DRIP_WATER");
        this.config.set("6.menuItem", (Object)"WATER_BUCKET : 1");
        this.config.set("6.helmet", (Object)"CHAINMAL_HELMET : 1");
        this.config.set("6.lore", Arrays.asList("&eDisplays note particles in-game!", "&eGives you a cosmetic chain helmet!"));
        this.config.set("6.buyCommands", Collections.singletonList("pex user %player% add %permission%"));
        this.config.set("6.price", (Object)8000);
        this.config.set("6.slot", (Object)16);
        this.config.set("6.rotateParticles", (Object)true);
        this.config.set("7.name", (Object)"&cCloud");
        this.config.set("7.permission", (Object)"bs.unlock.cloud");
        this.config.set("7.buyPermission", (Object)"bs.cloud");
        this.config.set("7.particles", (Object)"CLOUD");
        this.config.set("7.menuItem", (Object)"SNOW_BLOCK : 1");
        this.config.set("7.helmet", (Object)"SNOW_BLOCK : 1");
        this.config.set("7.lore", Arrays.asList("&eDisplays note particles in-game!", "&eGives you a cosmetic snow block helmet!"));
        this.config.set("7.buyCommands", Collections.singletonList("pex user %player% add %permission%"));
        this.config.set("7.price", (Object)8000);
        this.config.set("7.slot", (Object)19);
        this.config.set("7.rotateParticles", (Object)true);
        this.config.set("8.name", (Object)"&cFlames");
        this.config.set("8.permission", (Object)"bs.effects.unlock.flames");
        this.config.set("8.buyPermission", (Object)"bs.effects.flames");
        this.config.set("8.particles", (Object)"FLAME");
        this.config.set("8.menuItem", (Object)"DIAMOND_HELMET : 1");
        this.config.set("8.helmet", (Object)"DIAMOND_HELMET : 1");
        this.config.set("8.lore", Arrays.asList("&eDisplays flames particles in-game!", "&eGives you a cosmetic diamond helmet!"));
        this.config.set("8.buyCommands", Collections.singletonList("pex user %player% add %permission%"));
        this.config.set("8.price", (Object)20000);
        this.config.set("8.slot", (Object)10);
        this.config.set("8.rotateParticles", (Object)true);
        this.save();
    }

    public boolean containsEffect(int i) {
        return this.config.contains(i + ".name");
    }

    public List<String> getBuyCommands(int i) {
        return this.config.getStringList(i + ".buyCommands");
    }

    public String getItem(int i) {
        return this.config.getString(i + ".menuItem");
    }

    public List<String> getLore(int i) {
        return this.config.getStringList(i + ".lore");
    }

    public String getName(int i) {
        return this.config.getString(i + ".name");
    }

    public int getPrice(int i) {
        return this.config.getInt(i + ".price");
    }

    public String getPermissionToUnlock(int i) {
        return this.config.getString(i + ".permission");
    }

    public String getPermissionToBuy(int i) {
        return this.config.getString(i + ".buyPermission");
    }

    public String getHelmet(int i) {
        return this.config.getString(i + ".helmet");
    }

    public String getParticles(int i) {
        return this.config.getString(i + ".particles");
    }

    public int getSlot(int i) {
        return this.config.getInt(i + ".slot");
    }

    public boolean rotateParticles(int i) {
        return this.config.getBoolean("i.rotateParticles");
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

