/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.api;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.game.Game;
import com.floodeer.bowspleef.game.player.GamePlayer;
import com.floodeer.bowspleef.storage.leaderboard.OfflineGamePlayer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class BowSpleefAPI {
    public GamePlayer getPlayerData(Player bukkitPlayer) {
        return BowSpleef.get().getPM().getPlayer(bukkitPlayer.getUniqueId());
    }

    public GamePlayer getPlayerData(String name) {
        return BowSpleef.get().getPM().getPlayer(name);
    }

    public GamePlayer getPlayerData(UUID uuid) {
        return BowSpleef.get().getPM().getPlayer(uuid);
    }

    public Game getGame(String name) {
        if (BowSpleef.get().getGM().doesMapExists(name)) {
            return BowSpleef.get().getGM().getGameFromName(name);
        }
        return null;
    }

    public Game getGame(GamePlayer fromPlayer) {
        return fromPlayer.getGame();
    }

    public void saveData(Player ... p) {
        for (Player players : p) {
            BowSpleef.get().getPM().update(BowSpleef.get().getPM().getPlayer(players.getUniqueId()));
        }
    }

    public void updateLeaderboards() {
        BowSpleef.get().getPM().updateAllAsync();
    }

    public List<Map.Entry<String, Integer>> getWinsLeaderboard() {
        return BowSpleef.get().getLeaderboardManager().getTopWins();
    }

    public List<Map.Entry<String, Integer>> getShotsLeaderboard() {
        return BowSpleef.get().getLeaderboardManager().getTopShots();
    }

    public OfflineGamePlayer getOfflineGamePlayer(String name) {
        return BowSpleef.get().getLeaderboardManager().get(name);
    }
}

