/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.achievement;

import com.floodeer.bowspleef.BowSpleef;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;

public class Achievement {
    private File file;
    private YamlConfiguration config;

    public void loadAll() throws IOException {
        this.file = new File(BowSpleef.get().getDataFolder() + File.separator + "achievements.yml");
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8);){
            this.config = YamlConfiguration.loadConfiguration((Reader)reader);
        }
        catch (FileNotFoundException | UnsupportedEncodingException ex) {
            this.config = YamlConfiguration.loadConfiguration((File)this.file);
        }
        if (!this.file.exists()) {
            this.loadDefaults();
        }
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    private void loadDefaults() {
        this.config.set("wins.1.enabled", (Object)true);
        this.config.set("wins.1.display-name", (Object)"&8&lIt's my first win!");
        this.config.set("wins.1.description", (Object)"&7First bowspleef win.");
        this.config.set("wins.1.commands", Arrays.asList("bs coins add %player% 100"));
        this.config.set("wins.5.enabled", (Object)true);
        this.config.set("wins.5.display-name", (Object)"&8&lMy arrows are already on fire!");
        this.config.set("wins.5.description", (Object)"&7Win 5 BowSpleef games.");
        this.config.set("wins.5.commands", Arrays.asList("bs coins add %player% 150"));
        this.config.set("games.5.enabled", (Object)true);
        this.config.set("games.5.display-name", (Object)"&b&lStarting my journey!");
        this.config.set("games.5.description", (Object)"&7Play 5 BowSpleef games.");
        this.config.set("games.5.commands", Arrays.asList("bs coins add %player% 100"));
        this.config.set("games.15.enabled", (Object)true);
        this.config.set("games.15.display-name", (Object)"&b&lTrying my best!");
        this.config.set("games.15.description", (Object)"&7Play 15 BowSpleef games.");
        this.config.set("games.15.commands", Arrays.asList("bs coins add %player% 100"));
        this.config.set("shots.50.enabled", (Object)true);
        this.config.set("shots.50.display-name", (Object)"&b&lArrows everywhere!");
        this.config.set("shots.50.description", (Object)"&7Shoot 50 arrows with your bow!");
        this.config.set("shots.50.commands", Arrays.asList("bs coins add %player% 100"));
        this.config.set("shots.250.enabled", (Object)true);
        this.config.set("shots.250.display-name", (Object)"&b&lArrow party!");
        this.config.set("shots.250.description", (Object)"&7Shoot 250 arrows with your bow!");
        this.config.set("shots.250.commands", Arrays.asList("bs coins add %player% 100"));
        this.save();
    }

    public boolean containsAchievement(String str, int i) {
        return this.config.contains(str.toLowerCase() + "." + i + ".display-name");
    }

    public boolean isEnabled(String str, int i) {
        return this.config.getBoolean(str.toLowerCase() + "." + i + ".enabled");
    }

    public List<String> getCommands(String str, int i) {
        return this.config.getStringList(str.toLowerCase() + "." + i + ".commands");
    }

    public String getDescription(String str, int i) {
        return this.config.getString(str.toLowerCase() + "." + i + ".description");
    }

    public String getDisplayName(String str, int i) {
        return this.config.getString(str.toLowerCase() + "." + i + ".display-name");
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

