/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.game.Game;
import com.floodeer.bowspleef.game.GameJoinMenu;
import com.floodeer.bowspleef.game.player.GamePlayer;
import com.floodeer.bowspleef.game.structure.GameArena;
import com.floodeer.bowspleef.storage.enums.Callback;
import com.floodeer.bowspleef.util.ItemFactory;
import com.floodeer.bowspleef.util.LocationUtils;
import com.floodeer.bowspleef.util.MathUtils;
import com.floodeer.bowspleef.util.Runner;
import com.floodeer.bowspleef.util.Selector;
import com.floodeer.bowspleef.util.Util;
import com.floodeer.bowspleef.util.WorldUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowSpleefCommands
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(final @NotNull CommandSender commandSender, @NotNull Command command, @NotNull String label, final @NotNull String[] args) {
        boolean isPlayer = commandSender instanceof Player;
        if (args.length <= 0) {
            if (commandSender.hasPermission("bowspleef.admin")) {
                this.help(commandSender, 1);
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("create")) {
            if (!isPlayer) {
                return true;
            }
            if (!commandSender.hasPermission("bowspleef.admin")) {
                return true;
            }
            if (args.length == 1) {
                commandSender.sendMessage(Util.colorString("&cPlease specify the arena name.", new Player[0]));
                return true;
            }
            if (BowSpleef.get().getGM().doesMapExists(args[1])) {
                commandSender.sendMessage(Util.colorString("&cAn arena with this name already exists.", new Player[0]));
                return true;
            }
            String name = args[1];
            Game game = BowSpleef.get().getGM().createGame(name, false);
            game.getGameArena().create();
            commandSender.sendMessage(Util.colorString("&aArena &e" + name + " &acreated!", new Player[0]));
            if (BowSpleef.get().getOptions().advancedRestore) {
                commandSender.sendMessage(Util.colorString("&eTrying to create the world...", new Player[0]));
                for (String file : BowSpleef.get().getServer().getWorldContainer().list()) {
                    if (!file.equalsIgnoreCase(name)) continue;
                    WorldUtils.loadWorld(name);
                    commandSender.sendMessage(Util.colorString("&eFound a world with the map name in server root, loading world...", new Player[0]));
                }
                if (BowSpleef.get().getServer().getWorld(name) != null) {
                    ((Player)commandSender).teleport(BowSpleef.get().getServer().getWorld(name).getSpawnLocation());
                } else {
                    WorldUtils.createEmptyWorld(name);
                    ((Player)commandSender).teleport(BowSpleef.get().getServer().getWorld(name).getSpawnLocation());
                    commandSender.sendMessage(Util.colorString("&ePaste your map.", new Player[0]));
                }
            }
        } else if (args[0].equalsIgnoreCase("delete")) {
            if (!commandSender.hasPermission("bowspleef.admin")) {
                return true;
            }
            if (args.length == 1) {
                commandSender.sendMessage(Util.colorString("&cPlease specify the arena name.", new Player[0]));
                return true;
            }
            if (BowSpleef.get().getGM().doesMapExists(args[1])) {
                try {
                    BowSpleef.get().getGM().deleteGame(args[1]);
                    commandSender.sendMessage(Util.colorString("&cArena &e" + args[1] + " &cdeleted!", new Player[0]));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    commandSender.sendMessage(Util.colorString("&cFailed: " + e.getMessage(), new Player[0]));
                }
            } else {
                commandSender.sendMessage(Util.colorString("&cError: Invalid arena.", new Player[0]));
            }
        } else if (args[0].equalsIgnoreCase("finish")) {
            if (!commandSender.hasPermission("bowspleef.admin")) {
                return true;
            }
            if (args.length == 1) {
                commandSender.sendMessage(Util.colorString("&cPlease specify the arena name.", new Player[0]));
                return true;
            }
            if (!BowSpleef.get().getGM().doesMapExists(args[1])) {
                commandSender.sendMessage(Util.colorString("&cInvalid arena.", new Player[0]));
                return true;
            }
            Game game = BowSpleef.get().getGM().getGameFromName(args[1]);
            if (game.getState() == Game.GameState.IN_GAME) {
                game.shutdown(true);
            }
            if (BowSpleef.get().getOptions().advancedRestore && BowSpleef.get().getServer().getWorld(args[1]) != null) {
                World world = BowSpleef.get().getServer().getWorld(args[1]);
                world.getPlayers().forEach(Util::sendToSpawn);
            }
            Runner.make(BowSpleef.get()).delay(20).run(() -> {
                game.setState(Game.GameState.RESTORING);
                game.getGameArena().updateSign();
                BowSpleef.get().getGM().getGames().remove(game);
                BowSpleef.get().getGM().finish(args[1]);
                commandSender.sendMessage(Util.colorString("&aGame successfully reloaded!", new Player[0]));
            });
        } else if (args[0].equalsIgnoreCase("edit")) {
            if (!isPlayer) {
                return true;
            }
            if (args.length == 1) {
                commandSender.sendMessage(Util.colorString("&cPlease specify the arena name.", new Player[0]));
                return true;
            }
            Player player = (Player)commandSender;
            if (!commandSender.hasPermission("bowspleef.admin")) {
                return true;
            }
            String name = args[1];
            if (!BowSpleef.get().getGM().doesMapExists(name)) {
                commandSender.sendMessage(Util.colorString("&cInvalid arena.", new Player[0]));
                return true;
            }
            commandSender.sendMessage(Util.colorString("&ePlease wait...", new Player[0]));
            Game game = BowSpleef.get().getGM().getGameFromName(name);
            if (game.getState() == Game.GameState.IN_GAME) {
                game.shutdown(true);
            }
            Runner.make(BowSpleef.get()).delay(60).run(() -> player.teleport(game.getGameArena().getLocation(GameArena.LocationType.PLAYER_SPAWN)));
        } else if (args[0].equalsIgnoreCase("setSpawn")) {
            if (!isPlayer) {
                return true;
            }
            if (args.length == 1) {
                commandSender.sendMessage(Util.colorString("&cPlease specify the arena name.", new Player[0]));
                return true;
            }
            Player player = (Player)commandSender;
            if (!commandSender.hasPermission("bowspleef.admin")) {
                return true;
            }
            String name = args[1];
            if (!BowSpleef.get().getGM().doesMapExists(name)) {
                commandSender.sendMessage(Util.colorString("&cInvalid arena.", new Player[0]));
                return true;
            }
            Game game = BowSpleef.get().getGM().getGameFromName(name);
            game.getGameArena().setLocation(GameArena.LocationType.PLAYER_SPAWN, player.getLocation());
            player.sendMessage(Util.colorString("&aSpawn successfully set!", new Player[0]));
        } else if (args[0].equalsIgnoreCase("setGSpawn")) {
            if (!isPlayer) {
                return true;
            }
            Player player = (Player)commandSender;
            if (!commandSender.hasPermission("bowspleef.admin")) {
                return true;
            }
            BowSpleef.get().getOptions().spawn = LocationUtils.saveLocation(player.getLocation(), true);
            try {
                BowSpleef.get().getOptions().save();
                player.sendMessage(Util.colorString("&aGlobal spawn successfully set!", new Player[0]));
            }
            catch (InvalidConfigurationException e) {
                player.sendMessage(Util.colorString("&cError while setting global spawn! Check console.", new Player[0]));
                e.printStackTrace();
            }
        } else if (args[0].equalsIgnoreCase("setLobby")) {
            if (!isPlayer) {
                return true;
            }
            if (args.length == 1) {
                commandSender.sendMessage(Util.colorString("&cPlease specify the arena name.", new Player[0]));
                return true;
            }
            Player player = (Player)commandSender;
            if (!commandSender.hasPermission("bowspleef.admin")) {
                return true;
            }
            String name = args[1];
            if (!BowSpleef.get().getGM().doesMapExists(name)) {
                commandSender.sendMessage(Util.colorString("&cInvalid arena.", new Player[0]));
                return true;
            }
            Game game = BowSpleef.get().getGM().getGameFromName(name);
            game.getGameArena().setLocation(GameArena.LocationType.LOBBY, player.getLocation());
            player.sendMessage(Util.colorString("&aLobby successfully set!", new Player[0]));
        } else if (args[0].equalsIgnoreCase("setSpectatorSpawn")) {
            if (!isPlayer) {
                return true;
            }
            if (args.length == 1) {
                commandSender.sendMessage(Util.colorString("&cPlease specify the arena name.", new Player[0]));
                return true;
            }
            Player player = (Player)commandSender;
            if (!commandSender.hasPermission("bowspleef.admin")) {
                return true;
            }
            String name = args[1];
            if (!BowSpleef.get().getGM().doesMapExists(name)) {
                commandSender.sendMessage(Util.colorString("&cInvalid arena.", new Player[0]));
                return true;
            }
            Game game = BowSpleef.get().getGM().getGameFromName(name);
            game.getGameArena().setLocation(GameArena.LocationType.SPEC_SPAWN, player.getLocation());
            player.sendMessage(Util.colorString("&aSpectator Spawn successfully set!", new Player[0]));
        } else if (args[0].equalsIgnoreCase("setBounds")) {
            if (!isPlayer) {
                return true;
            }
            if (args.length == 1) {
                commandSender.sendMessage(Util.colorString("&cPlease specify the arena name.", new Player[0]));
                return true;
            }
            Player player = (Player)commandSender;
            if (!commandSender.hasPermission("bowspleef.admin")) {
                return true;
            }
            String name = args[1];
            if (!BowSpleef.get().getGM().doesMapExists(name)) {
                commandSender.sendMessage(Util.colorString("&cInvalid arena.", new Player[0]));
                return true;
            }
            Game game = BowSpleef.get().getGM().getGameFromName(name);
            GamePlayer gp = GamePlayer.get(player);
            Selector s = BowSpleef.get().getSelector();
            if (!s.hasSelection(gp.getPlayer())) {
                commandSender.sendMessage(Util.colorString("&cPlease select the arena corners using BowSpleef's Wand (/bowspleef wand).", new Player[0]));
                return true;
            }
            if (s.getSelection().containsKey(player)) {
                Location min = s.getSelection().get((Object)player).low;
                Location max = s.getSelection().get((Object)player).high;
                game.getGameArena().setLocation(GameArena.LocationType.HIGH, max);
                game.getGameArena().setLocation(GameArena.LocationType.LOW, min);
                commandSender.sendMessage(Util.colorString("&aArena bounds set!", new Player[0]));
            }
        } else if (args[0].equalsIgnoreCase("setMinPlayers")) {
            if (!commandSender.hasPermission("bowspleef.admin")) {
                return true;
            }
            if (args.length <= 1) {
                commandSender.sendMessage(Util.colorString("&cPlease specify the arena name.", new Player[0]));
                return true;
            }
            if (args.length <= 2) {
                commandSender.sendMessage(Util.colorString("&cPlease specify the amount of players.", new Player[0]));
                return true;
            }
            if (BowSpleef.get().getGM().doesMapExists(args[1])) {
                Game game = BowSpleef.get().getGM().getGameFromName(args[1]);
                if (!MathUtils.isInteger(args[2])) {
                    commandSender.sendMessage(Util.colorString("&cMin players must be a number.", new Player[0]));
                    return true;
                }
                game.getGameArena().setMinPlayers(Integer.parseInt(args[2]));
                commandSender.sendMessage(Util.colorString("&aMin players successfully set!", new Player[0]));
            } else {
                commandSender.sendMessage(Util.colorString("&cInvalid arena.", new Player[0]));
            }
        } else if (args[0].equalsIgnoreCase("setMaxPlayers")) {
            if (!commandSender.hasPermission("bowspleef.admin")) {
                return true;
            }
            if (args.length <= 1) {
                commandSender.sendMessage(Util.colorString("&cPlease specify the arena name.", new Player[0]));
                return true;
            }
            if (args.length <= 2) {
                commandSender.sendMessage(Util.colorString("&cPlease specify the amount of players.", new Player[0]));
                return true;
            }
            if (BowSpleef.get().getGM().doesMapExists(args[1])) {
                Game game = BowSpleef.get().getGM().getGameFromName(args[1]);
                if (!MathUtils.isInteger(args[2])) {
                    commandSender.sendMessage(Util.colorString("&cMax players must be a number.", new Player[0]));
                    return true;
                }
                game.getGameArena().setMaxPlayers(Integer.parseInt(args[2]));
                commandSender.sendMessage(Util.colorString("&aMax players successfully set!", new Player[0]));
            } else {
                commandSender.sendMessage(Util.colorString("&cInvalid arena.", new Player[0]));
            }
        } else if (args[0].equalsIgnoreCase("start")) {
            if (!this.perm(commandSender, "bowspleef.admin") || !this.perm(commandSender, "bowspleef.mod")) {
                return true;
            }
            if (args.length == 1) {
                if (!isPlayer) {
                    return true;
                }
                Player p = (Player)commandSender;
                GamePlayer gp = GamePlayer.get(p.getUniqueId());
                if (gp.isInGame() && (gp.getGame().getState() == Game.GameState.PRE_GAME || gp.getGame().getState() == Game.GameState.STARTING)) {
                    gp.getGame().startGraceTime();
                    commandSender.sendMessage(Util.colorString("&aGame started.", new Player[0]));
                }
            } else if (BowSpleef.get().getGM().doesMapExists(args[1])) {
                Game game = BowSpleef.get().getGM().getGameFromName(args[1]);
                if (game.getState() == Game.GameState.PRE_GAME || game.getState() == Game.GameState.STARTING) {
                    commandSender.sendMessage(Util.colorString("&aGame started.", new Player[0]));
                    game.startGraceTime();
                }
            } else {
                commandSender.sendMessage(Util.colorString("&cInvalid arena.", new Player[0]));
            }
        } else if (args[0].equalsIgnoreCase("stop")) {
            if (!this.perm(commandSender, "bowspleef.admin") || !this.perm(commandSender, "bowspleef.mod")) {
                return true;
            }
            if (args.length == 1) {
                if (!isPlayer) {
                    return true;
                }
                Player p = (Player)commandSender;
                GamePlayer gp = GamePlayer.get(p.getUniqueId());
                if (gp.isInGame() && gp.getGame().getState() == Game.GameState.IN_GAME) {
                    commandSender.sendMessage(Util.colorString("&cForced game to stop.", new Player[0]));
                    gp.getGame().endGame(null, false, false);
                }
            } else if (BowSpleef.get().getGM().doesMapExists(args[1])) {
                Game game = BowSpleef.get().getGM().getGameFromName(args[1]);
                if (game.getState() == Game.GameState.IN_GAME) {
                    commandSender.sendMessage(Util.colorString("&cForced game to stop.", new Player[0]));
                    game.endGame(null, false, false);
                }
            } else {
                commandSender.sendMessage(Util.colorString("&cInvalid arena.", new Player[0]));
            }
        } else if (args[0].equalsIgnoreCase("join")) {
            if (!isPlayer) {
                return true;
            }
            Player p = (Player)commandSender;
            if (args.length == 1) {
                if (GamePlayer.get(p.getUniqueId()) == null) {
                    p.sendMessage(Util.colorString(BowSpleef.get().getLanguage().datawait, p));
                    return true;
                }
                if (GamePlayer.get(p.getUniqueId()).isInGame()) {
                    p.sendMessage(Util.colorString(BowSpleef.get().getLanguage().ingame, p));
                    return true;
                }
                if (BowSpleef.get().getGM().findGameFor(GamePlayer.get(p.getUniqueId())) == null) {
                    p.sendMessage(Util.colorString(BowSpleef.get().getLanguage().gamenotfound, p));
                } else {
                    BowSpleef.get().getGM().findGameFor(GamePlayer.get(p.getUniqueId())).addPlayer(GamePlayer.get(p.getUniqueId()));
                }
            } else if (BowSpleef.get().getGM().doesMapExists(args[1])) {
                Game game = BowSpleef.get().getGM().getGameFromName(args[1]);
                if (game.getState() != Game.GameState.PRE_GAME && game.getState() != Game.GameState.STARTING && !BowSpleef.get().getOptions().joinWhileStarting) {
                    if (game.getState() == Game.GameState.ENDING || game.getState() == Game.GameState.RESTORING) {
                        p.sendMessage(Util.colorString(BowSpleef.get().getLanguage().restoring, p));
                        return true;
                    }
                    p.sendMessage(Util.colorString(BowSpleef.get().getLanguage().started, p));
                    return true;
                }
                if (game.getPlayers().size() >= game.getMaxPlayers() && !p.hasPermission("bowspleef.joinfull")) {
                    p.sendMessage(Util.colorString(BowSpleef.get().getLanguage().gamefull, p));
                    return true;
                }
                if (GamePlayer.get(p.getUniqueId()).isInGame()) {
                    p.sendMessage(Util.colorString(BowSpleef.get().getLanguage().ingame, p));
                    return true;
                }
                game.addPlayer(GamePlayer.get(p.getUniqueId()));
            }
        } else if (args[0].equalsIgnoreCase("leave")) {
            if (!isPlayer) {
                return true;
            }
            GamePlayer gp = GamePlayer.get(((Player)commandSender).getUniqueId());
            if (gp.isInGame()) {
                gp.getGame().removePlayer(gp, false, true);
            }
        } else if (args[0].equalsIgnoreCase("wand")) {
            if (!isPlayer) {
                return true;
            }
            Player player = (Player)commandSender;
            if (!commandSender.hasPermission("bowspleef.admin")) {
                return true;
            }
            player.getInventory().addItem(new ItemStack[]{ItemFactory.create(Material.STICK, Util.colorString("&6BowSpleef's Wand", new Player[0]))});
            commandSender.sendMessage(Util.colorString("&eUse &cLeft Click &eto select &cLOW &eand &aRight Click &eto select &aHIGH&e.", new Player[0]));
        } else if (args[0].equalsIgnoreCase("config")) {
            if (!commandSender.hasPermission("bowspleef.admin")) {
                return true;
            }
            if (args.length == 1) {
                commandSender.sendMessage(Util.colorString("&cUse: &e/BowSpleef config set <path> <value>", new Player[0]));
                commandSender.sendMessage(Util.colorString("&cExample: &8/BowSpleef config set Options.Game.Spawn-Falling-Blocks false", new Player[0]));
                return true;
            }
            if (args.length == 2) {
                commandSender.sendMessage(Util.colorString("&cPlease specify the path.", new Player[0]));
                return true;
            }
            if (args.length == 3) {
                commandSender.sendMessage(Util.colorString("&cPlease specify the value.", new Player[0]));
                return true;
            }
            if (args[1].equalsIgnoreCase("save")) {
                try {
                    BowSpleef.get().getOptions().save();
                    commandSender.sendMessage(Util.colorString("&aConfig successfully updated!", new Player[0]));
                }
                catch (InvalidConfigurationException e) {
                    commandSender.sendMessage(Util.colorString("&cFailed on save config!", new Player[0]));
                    e.printStackTrace();
                }
            } else if (args[1].equalsIgnoreCase("set")) {
                YamlConfiguration f = YamlConfiguration.loadConfiguration((File)BowSpleef.get().getOptions().getFile());
                if (!f.contains(args[2])) {
                    commandSender.sendMessage(Util.colorString("&cInvalid path!", new Player[0]));
                    commandSender.sendMessage(Util.colorString("&cExample: &8/BowSpleef config set Options.Game-Length 500", new Player[0]));
                    return true;
                }
                if (args[2].startsWith("Storage") || args[2].contains("Bungee") || args[2].equalsIgnoreCase("Advanced.Cache-In-Memory") || args[2].equalsIgnoreCase("Advanced.Per-World-Arena")) {
                    commandSender.sendMessage(Util.colorString("&cUnable to update &4&l " + args[2] + "&c: The path is being used! Please disable the plugin to modify this value.", new Player[0]));
                    return true;
                }
                f.set(args[2], (Object)args[3]);
                try {
                    f.save(BowSpleef.get().getOptions().getFile());
                    BowSpleef.get().getOptions().load();
                    BowSpleef.get().getOptions().save();
                    commandSender.sendMessage(Util.colorString("&eValue of &b" + args[2] + " &echanged to &a" + args[3], new Player[0]));
                    commandSender.sendMessage(Util.colorString("&aConfig successfully updated!", new Player[0]));
                }
                catch (IOException | InvalidConfigurationException e) {
                    e.printStackTrace();
                }
            }
        } else if (args[0].equalsIgnoreCase("reload")) {
            if (!this.perm(commandSender, "bowspleef.admin")) {
                return true;
            }
            try {
                BowSpleef.get().getOptions().load();
                BowSpleef.get().getLanguage().load();
                commandSender.sendMessage(Util.colorString("&aConfig & Language files successfully updated!", new Player[0]));
            }
            catch (InvalidConfigurationException e) {
                commandSender.sendMessage(Util.colorString("&cFailed while saving or updating config.", new Player[0]));
                e.printStackTrace();
            }
        } else if (args[0].equalsIgnoreCase("coins")) {
            if (!commandSender.hasPermission("BowSpleef.admin")) {
                return true;
            }
            if (args.length == 1) {
                commandSender.sendMessage(Util.colorString("&cUse &e/bs coins <set/remove/add> <player> <amount>", new Player[0]));
                return true;
            }
            if (args.length == 2) {
                commandSender.sendMessage(Util.colorString("&cPlease specify the player name.", new Player[0]));
                return true;
            }
            if (args.length == 3) {
                commandSender.sendMessage(Util.colorString("&cPlease specify the amount.", new Player[0]));
                return true;
            }
            if (!MathUtils.isInteger(args[3])) {
                commandSender.sendMessage(Util.colorString("&cAmount must be a number.", new Player[0]));
                return true;
            }
            if (args[1].equalsIgnoreCase("set")) {
                Player player = Util.find(args[2]);
                if (player == null) {
                    commandSender.sendMessage(Util.colorString("&cPlayer is not online, checking database...", new Player[0]));
                    BowSpleef.get().getStorage().doesPlayerExists(args[2], new Callback<Boolean>(){

                        @Override
                        public void onCall(Boolean result) {
                            if (result.booleanValue()) {
                                commandSender.sendMessage(Util.colorString("&aPlayer found, changing values...", new Player[0]));
                                BowSpleef.get().getStorage().setCoins(args[2], Integer.parseInt(args[3]), result1 -> {
                                    if (result1.booleanValue()) {
                                        commandSender.sendMessage(Util.colorString("&aSet &b" + args[3] + " &acoins to &6" + args[2], new Player[0]) + ".");
                                    } else {
                                        commandSender.sendMessage(Util.colorString("&cProcess failed.", new Player[0]));
                                    }
                                });
                            } else {
                                commandSender.sendMessage(Util.colorString("&cPlayer not found.", new Player[0]));
                            }
                        }
                    });
                } else {
                    GamePlayer.get(player).setMoney(Integer.parseInt(args[3]));
                    commandSender.sendMessage(Util.colorString("&aSet &b" + args[3] + " &acoins to &6" + args[2], new Player[0]) + ".");
                }
            } else if (args[1].equalsIgnoreCase("add")) {
                Player player = Util.find(args[2]);
                if (player == null) {
                    commandSender.sendMessage(Util.colorString("&cPlayer is not online, checking database...", new Player[0]));
                    BowSpleef.get().getStorage().doesPlayerExists(args[2], new Callback<Boolean>(){
                        int coins = 0;

                        @Override
                        public void onCall(Boolean result) {
                            if (result.booleanValue()) {
                                commandSender.sendMessage(Util.colorString("&aPlayer found, changing values...", new Player[0]));
                                BowSpleef.get().getStorage().getCoins(args[2], result12 -> {
                                    this.coins = result12;
                                });
                                BowSpleef.get().getStorage().setCoins(args[2], this.coins + Integer.parseInt(args[3]), new Callback<Boolean>(){

                                    @Override
                                    public void onCall(Boolean result) {
                                        if (result.booleanValue()) {
                                            commandSender.sendMessage(Util.colorString("&aAdded &b" + args[3] + " &acoins from &6" + args[2], new Player[0]) + ".");
                                        } else {
                                            commandSender.sendMessage(Util.colorString("&cProcess failed.", new Player[0]));
                                        }
                                    }
                                });
                            } else {
                                commandSender.sendMessage(Util.colorString("&cPlayer not found.", new Player[0]));
                            }
                        }
                    });
                } else {
                    GamePlayer.get(player).addMoney(Integer.parseInt(args[3]));
                    commandSender.sendMessage(Util.colorString("&aAdded &b" + args[3] + " &acoins from &6" + args[2], new Player[0]) + ".");
                }
            } else if (args[1].equalsIgnoreCase("remove")) {
                Player player = Util.find(args[2]);
                if (player == null) {
                    commandSender.sendMessage(Util.colorString("&cPlayer is not online, checking database...", new Player[0]));
                    BowSpleef.get().getStorage().doesPlayerExists(args[2], new Callback<Boolean>(){
                        int coins = 0;

                        @Override
                        public void onCall(Boolean result) {
                            if (result.booleanValue()) {
                                commandSender.sendMessage(Util.colorString("&aPlayer found, changing values...", new Player[0]));
                                BowSpleef.get().getStorage().getCoins(args[2], result13 -> {
                                    this.coins = result13;
                                });
                                BowSpleef.get().getStorage().setCoins(args[2], this.coins - Integer.parseInt(args[3]), new Callback<Boolean>(){

                                    @Override
                                    public void onCall(Boolean result) {
                                        if (result.booleanValue()) {
                                            commandSender.sendMessage(Util.colorString("&aRemoved &b" + args[3] + " &acoins from &6" + args[2], new Player[0]) + ".");
                                        } else {
                                            commandSender.sendMessage(Util.colorString("&cProcess failed.", new Player[0]));
                                        }
                                    }
                                });
                            } else {
                                commandSender.sendMessage(Util.colorString("&cPlayer not found.", new Player[0]));
                            }
                        }
                    });
                } else {
                    GamePlayer.get(player).removeMoney(Integer.parseInt(args[3]));
                    commandSender.sendMessage(Util.colorString("&aRemoved &b" + args[3] + " &acoins from &6" + args[2], new Player[0]) + ".");
                }
            }
        } else {
            if (args[0].equalsIgnoreCase("stats")) {
                if (!isPlayer) {
                    return true;
                }
                Player p = (Player)commandSender;
                GamePlayer gp = GamePlayer.get(p.getUniqueId());
                List<String> messages = Util.colorList(BowSpleef.get().getLanguage().playerStats);
                messages = Util.replaceAll(messages, "%games_played%", Integer.toString(gp.getGamesPlayed()));
                messages = Util.replaceAll(messages, "%wins%", Integer.toString(gp.getWins()));
                messages = Util.replaceAll(messages, "%losses%", Integer.toString(gp.getLosses()));
                messages = Util.replaceAll(messages, "%shots%", Integer.toString(gp.getArrowsShot()));
                messages = Util.replaceAll(messages, "%balance%", Integer.toString(gp.getMoney()));
                messages = Util.replaceAll(messages, "%player%", p.getName());
                for (String str : messages) {
                    gp.getPlayer().sendMessage(Util.colorString(str, gp.getPlayer()));
                }
                return false;
            }
            if (args[0].equalsIgnoreCase("forceRestore")) {
                if (!commandSender.hasPermission("bowspleef.admin")) {
                    return true;
                }
                if (args.length <= 1) {
                    commandSender.sendMessage(Util.colorString("&cPlease specify the arena name.", new Player[0]));
                    return true;
                }
                BowSpleef.get().getGM().getGameFromName(args[1]).restore(true, true);
            } else if (args[0].equalsIgnoreCase("updateLeaderboard")) {
                if (!commandSender.hasPermission("bowspleef.admin")) {
                    return true;
                }
                commandSender.sendMessage(Util.colorString("&eUpdating leaderboard....", new Player[0]));
                BowSpleef.get().getLeaderboardManager().sendUpdate();
                Runner.make(BowSpleef.get()).delay(180).run(() -> {
                    BowSpleef.get().getLeaderboardManager().receiveUpdate();
                    commandSender.sendMessage(Util.colorString("&aSucess!", new Player[0]));
                });
            } else if (args[0].equalsIgnoreCase("joinmenu") || args[0].equalsIgnoreCase("joingui")) {
                if (!commandSender.hasPermission("bowspleef.joinmenu")) {
                    return true;
                }
                if (!(commandSender instanceof Player)) {
                    return true;
                }
                GamePlayer gp = GamePlayer.get(((Player)commandSender).getUniqueId());
                if (!gp.isInGame()) {
                    GameJoinMenu.showGameJoinMenu(GamePlayer.get(((Player)commandSender).getUniqueId()));
                }
            } else if (args[0].equalsIgnoreCase("help")) {
                this.help(commandSender, args.length);
            }
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            if (commandSender.hasPermission("bowspleef.admin")) {
                return Arrays.asList("create", "setLobby", "setSpawn", "setSpectatorSpawn", "setBounds", "setMinPlayers", "setMaxPlayers", "finish", "edit", "delete", "setgspawn", "start", "stop", "config", "coins", "updateLeaderboard", "forceRestore", "leave", "join", "stats", "reload", "joinmenu", "help");
            }
            return Arrays.asList("stats", "join", "leave", "joinmenu", "help");
        }
        if (args.length >= 2) {
            if (args[1].equalsIgnoreCase("coins")) {
                return Arrays.asList("add", "remove", "set");
            }
            if (args[1].equalsIgnoreCase("config")) {
                return Arrays.asList("set", "save");
            }
        }
        return null;
    }

    private boolean perm(CommandSender p, String perm) {
        return p.hasPermission(perm);
    }

    private void helper(CommandSender s) {
        s.sendMessage(Util.colorString("&cInvalid command usage. Use &6/bowspleef help &cfor help.", new Player[0]));
    }

    private void help(CommandSender p, int page) {
        if (page == 1) {
            p.sendMessage(Util.colorString("&7&m----------------{ &9&lBowSpleef&f&7&m }----------------", new Player[0]));
            p.sendMessage(" ");
            p.sendMessage(Util.colorString("&e/bs setgspawn &f&l- &7Set global spawn", new Player[0]));
            p.sendMessage(" ");
            p.sendMessage(Util.colorString("&e/bs create <name> &f&l- &7Create a new arena", new Player[0]));
            p.sendMessage(Util.colorString("&e/bs setLobby <name> &f&l- &7Set arena waiting lobby", new Player[0]));
            p.sendMessage(Util.colorString("&e/bs setSpawn <name> &f&l- &7Set arena spawn", new Player[0]));
            p.sendMessage(Util.colorString("&e/bs setMinPlayers <name> <amount> &f&l- &7Set min of players to start", new Player[0]));
            p.sendMessage(Util.colorString("&e/bs setMaxPlayers <name> <amount> &f&l- &7Set the player limit", new Player[0]));
            p.sendMessage(Util.colorString("&e/bs setBounds <name> &f&l- &7Set arena bounds", new Player[0]));
            p.sendMessage(Util.colorString("&e/bs finish <name> &f&l- &7Finish the arena setup and create the game", new Player[0]));
            p.sendMessage(" ");
            p.sendMessage(Util.colorString("&7Page &a1&7. Use &e/bs help 2 &7for more commands.", new Player[0]));
            p.sendMessage(" ");
            p.sendMessage(Util.colorString("&7&m----------------{ &9&lBowSpleef&f&7&m }----------------", new Player[0]));
        } else if (page == 2) {
            p.sendMessage(Util.colorString("&7&m----------------{ &9&lBowSpleef&f&7&m }----------------", new Player[0]));
            p.sendMessage(" ");
            p.sendMessage(Util.colorString("&e/bs start <name> &f&l- &7Force the game to start", new Player[0]));
            p.sendMessage(Util.colorString("&e/bs stop <name> &f&l- &7Force the game to stop", new Player[0]));
            p.sendMessage(Util.colorString("&e/bs delete <name> &f&l- &7Delete an arena", new Player[0]));
            p.sendMessage(Util.colorString("&e/bs edit <name> &f&l- &7Edit an arena", new Player[0]));
            p.sendMessage(Util.colorString("&e/bs config &f&l- &7Manager the config options file.", new Player[0]));
            p.sendMessage(Util.colorString("&e/bs coins set/add/remove <player> <amount> &f&l- &7Manager the economy system", new Player[0]));
            p.sendMessage(" ");
            p.sendMessage(Util.colorString("&7Page &a2&7. Use &e/bs help 3 &7for more commands.", new Player[0]));
            p.sendMessage(" ");
            p.sendMessage(Util.colorString("&7&m----------------{ &9&lBowSpleef&f&7&m }----------------", new Player[0]));
        } else if (page == 3) {
            p.sendMessage(Util.colorString("&7&m----------------{ &9&lBowSpleef&f&7&m }----------------", new Player[0]));
            p.sendMessage(" ");
            p.sendMessage(Util.colorString("&e/bs wand &f&l- &7Area selection tool", new Player[0]));
            p.sendMessage(Util.colorString("&e/bs reload &f&l- &7Reload all config files.", new Player[0]));
            p.sendMessage(Util.colorString("&e/bs stats &f&l- &7BowSpleef stats.", new Player[0]));
            p.sendMessage(" ");
            p.sendMessage(Util.colorString("&7&m----------------{ &9&lBowSpleef&f&7&m }----------------", new Player[0]));
        } else {
            this.help(p, 1);
        }
    }
}

