/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef;

import com.floodeer.bowspleef.BowSpleefCommands;
import com.floodeer.bowspleef.ConfigOptions;
import com.floodeer.bowspleef.LanguageOptions;
import com.floodeer.bowspleef.achievement.Achievement;
import com.floodeer.bowspleef.api.BowSpleefAPI;
import com.floodeer.bowspleef.cosmestics.EffectMenu;
import com.floodeer.bowspleef.cosmestics.EffectsCosmetic;
import com.floodeer.bowspleef.cosmestics.EffectsTaskHandler;
import com.floodeer.bowspleef.cosmestics.ShopMenu;
import com.floodeer.bowspleef.cosmestics.TrailsCosmetic;
import com.floodeer.bowspleef.cosmestics.TrailsMenu;
import com.floodeer.bowspleef.event.BungeeEventListener;
import com.floodeer.bowspleef.event.PlayerEvent;
import com.floodeer.bowspleef.event.SignEvent;
import com.floodeer.bowspleef.game.player.GamePlayer;
import com.floodeer.bowspleef.hook.HolographicDisplaysHook;
import com.floodeer.bowspleef.hook.PlaceholderAPIHook;
import com.floodeer.bowspleef.manager.GameManager;
import com.floodeer.bowspleef.manager.LeaderboardManager;
import com.floodeer.bowspleef.manager.PlayerManager;
import com.floodeer.bowspleef.storage.DataStorage;
import com.floodeer.bowspleef.storage.MySQL;
import com.floodeer.bowspleef.storage.SQLite;
import com.floodeer.bowspleef.storage.enums.Database;
import com.floodeer.bowspleef.util.IconCore;
import com.floodeer.bowspleef.util.Selector;
import com.floodeer.bowspleef.util.actionbar.ActionBar;
import com.floodeer.bowspleef.util.particle.ParticleManager;
import com.floodeer.bowspleef.util.update.Updater;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class BowSpleef
extends JavaPlugin {
    public static boolean IS_PLUGIN_ENABLED;
    private static BowSpleef bowSpleef;
    private static ServerVersion serverVersion;
    public static String nmsver;
    public static Economy econ;
    public static int MAX_TRAILS;
    public static int MAX_EFFECTS;
    private PlayerManager playerManager;
    private GameManager gameManager;
    private LeaderboardManager leaderboardManager;
    private DataStorage storage;
    private Database database;
    private ConfigOptions configOptions;
    private LanguageOptions languageOptions;
    private Selector selector;
    private ActionBar actionBar;
    private TrailsCosmetic tCosmetic;
    private EffectsCosmetic eCosmetic;
    private ParticleManager particleManager;
    private IconCore iconCore;
    private Achievement achievements;
    private static BowSpleefAPI api;

    public static BowSpleefAPI getAPI() {
        return api;
    }

    public static BowSpleef get() {
        return bowSpleef;
    }

    public static ServerVersion getServerVersion() {
        return serverVersion;
    }

    public PlayerManager getPM() {
        return this.playerManager;
    }

    public GameManager getGM() {
        return this.gameManager;
    }

    public TrailsCosmetic getTC() {
        return this.tCosmetic;
    }

    public EffectsCosmetic getEC() {
        return this.eCosmetic;
    }

    public DataStorage getStorage() {
        return this.storage;
    }

    public ActionBar getActionBar() {
        return this.actionBar;
    }

    public ParticleManager getParticleManager() {
        return this.particleManager;
    }

    public ConfigOptions getOptions() {
        return this.configOptions;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public LanguageOptions getLanguage() {
        return this.languageOptions;
    }

    public LeaderboardManager getLeaderboardManager() {
        return this.leaderboardManager;
    }

    public IconCore getIconManager() {
        return this.iconCore;
    }

    public Achievement getAchievements() {
        return this.achievements;
    }

    public void onEnable() {
        super.onEnable();
        bowSpleef = this;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.getLogger().info("Loading files...");
        File mapsFolder = new File(this.getDataFolder() + File.separator + "maps");
        if (!mapsFolder.exists()) {
            mapsFolder.mkdirs();
            this.getLogger().info("Created the game maps folder.");
        }
        this.configOptions = new ConfigOptions(new File(this.getDataFolder(), "options.yml"));
        this.languageOptions = new LanguageOptions(new File(this.getDataFolder(), "language.yml"));
        try {
            this.configOptions.load();
            this.getLogger().info("Config Options loaded!");
            this.languageOptions.load();
            this.getLogger().info("Languages loaded!");
        }
        catch (InvalidConfigurationException ex) {
            this.getLogger().severe("Failed to load an config file: " + ex.getMessage());
            ex.printStackTrace();
        }
        if (!this.setupDatabase()) {
            this.setEnabled(false);
            this.getLogger().severe("BowSpleef disabled due an fatal error while starting the database.");
            return;
        }
        this.setupNMS();
        if (this.getOptions().isVaultEnabled) {
            this.getLogger().info("Loading vault support...");
            this.setupEconomy();
        }
        this.getLogger().info("Loading classes...");
        this.playerManager = new PlayerManager();
        this.gameManager = new GameManager();
        this.selector = new Selector();
        this.particleManager = new ParticleManager();
        this.iconCore = new IconCore();
        this.tCosmetic = new TrailsCosmetic();
        this.tCosmetic.loadAll();
        this.eCosmetic = new EffectsCosmetic();
        this.eCosmetic.loadAll();
        this.achievements = new Achievement();
        try {
            this.achievements.loadAll();
        }
        catch (IOException e) {
            this.getLogger().severe("Error while loading achievements...");
            e.printStackTrace();
        }
        this.getLogger().info("Loading events...");
        this.getServer().getPluginManager().registerEvents((Listener)this.iconCore, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SignEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EffectsTaskHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TrailsMenu(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EffectMenu(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ShopMenu(), (Plugin)this);
        this.getCommand("bowspleef").setExecutor((CommandExecutor)new BowSpleefCommands());
        this.getCommand("bs").setExecutor((CommandExecutor)new BowSpleefCommands());
        this.getCommand("bowspleef").setTabCompleter((TabCompleter)new BowSpleefCommands());
        this.getCommand("bs").setTabCompleter((TabCompleter)new BowSpleefCommands());
        this.getLogger().info("Loading tasks...");
        if (!this.getOptions().isBungeeCord) {
            this.getServer().getScheduler().runTaskTimer((Plugin)this, () -> this.getPM().getAll().forEach(p -> this.getStorage().savePlayerAsync((GamePlayer)p)), 60L, (long)(this.getOptions().updateDelay * 1200));
            this.getServer().getScheduler().runTaskTimer((Plugin)this, () -> this.getGM().getGames().stream().filter(g -> g.getGameArena().isSignSet()).forEach(g -> g.getGameArena().updateSign()), 120L, 40L);
        } else {
            this.getServer().getPluginManager().registerEvents((Listener)new BungeeEventListener(), (Plugin)this);
            this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        }
        this.getServer().getScheduler().runTaskTimer((Plugin)this, (Runnable)new Updater(this), 20L, 1L);
        this.getLogger().info("Loading extra resources...");
        if (this.getServer().getPluginManager().isPluginEnabled("HolographicDisplays")) {
            HolographicDisplaysHook.init();
        }
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderAPIHook((Plugin)this).register();
        }
        int ME = 1;
        while (this.getEC().containsEffect(ME)) {
            ++ME;
        }
        MAX_EFFECTS = ME;
        int MT = 1;
        while (this.getTC().containsEffect(MT)) {
            ++MT;
        }
        MAX_TRAILS = MT;
        this.getLogger().info("Finished task loading, plugin enabled!");
        api = new BowSpleefAPI();
        IS_PLUGIN_ENABLED = true;
    }

    public void onDisable() {
        super.onDisable();
        if (IS_PLUGIN_ENABLED) {
            this.getGM().shutdownGames();
            this.getPM().shutdown();
        }
        this.getLogger().info("Splegg was disabled");
    }

    private void setupNMS() {
        nmsver = this.getServer().getClass().getPackage().getName();
        nmsver = nmsver.substring(nmsver.lastIndexOf(".") + 1);
        this.getLogger().info("Detected NMS version: " + nmsver);
        serverVersion = ServerVersion.PRE_13;
        if (nmsver.startsWith("v1_8")) {
            serverVersion = ServerVersion.VERSION_18;
        } else if (nmsver.startsWith("v1_16")) {
            serverVersion = ServerVersion.VERSION_16;
        } else if (nmsver.startsWith("v1_17")) {
            serverVersion = ServerVersion.VERSION_17;
        } else if (nmsver.startsWith("v1_18")) {
            serverVersion = ServerVersion.VERSION_118;
        } else if (nmsver.startsWith("v1_19")) {
            serverVersion = ServerVersion.VERSION_118;
        } else if (nmsver.startsWith("v1_13")) {
            serverVersion = ServerVersion.VERSION_13;
        } else if (nmsver.startsWith("v1_14")) {
            serverVersion = ServerVersion.VERSION_14;
        } else if (nmsver.startsWith("v1_15")) {
            serverVersion = ServerVersion.VERSION_15;
        }
        this.actionBar = new ActionBar();
        this.getLogger().info("Loaded support for " + nmsver);
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        econ = (Economy)rsp.getProvider();
        return econ != null;
    }

    private boolean setupDatabase() {
        DataStorage.StorageType type = DataStorage.StorageType.fromString(this.getOptions().storageType);
        if (type == DataStorage.StorageType.SQLITE) {
            this.getLogger().info("Using SQLite Driver. Now starting SQLite...");
            try {
                this.database = new SQLite();
                this.database.createTables();
            }
            catch (IOException | ClassNotFoundException | SQLException e) {
                this.getLogger().severe("Error while loading SQLite!");
                e.printStackTrace();
                return false;
            }
        }
        if (type == DataStorage.StorageType.MYSQL) {
            this.getLogger().info("Using MysSQL Driver. Now starting MySQL...");
            try {
                this.database = new MySQL(this.getOptions().mysqlHost, this.getOptions().mysqlDatabase, this.getOptions().mysqlUser, this.getOptions().mysqlPassword, this.getOptions().mysqlPort);
                this.database.createTables();
            }
            catch (IOException | ClassNotFoundException | SQLException e) {
                this.getLogger().severe("Error while loading SQLite!");
                e.printStackTrace();
                return false;
            }
        }
        this.storage = new DataStorage(this.database);
        if (this.getOptions().leaderboards) {
            this.leaderboardManager = new LeaderboardManager(this.database);
        }
        return true;
    }

    static {
        econ = null;
        MAX_TRAILS = 0;
        MAX_EFFECTS = 0;
    }

    public static enum ServerVersion {
        VERSION_18,
        PRE_13,
        VERSION_13,
        VERSION_14,
        VERSION_15,
        VERSION_16,
        VERSION_17,
        VERSION_118,
        VERSION_19;


        public static boolean isLegacy() {
            return serverVersion == PRE_13 || serverVersion == VERSION_18;
        }

        public boolean hasHexSupport() {
            return serverVersion == VERSION_16 || serverVersion == VERSION_17 || serverVersion == VERSION_118 || serverVersion == VERSION_19;
        }
    }
}

