/*
 * Decompiled with CFR 0.152.
 */
package me.ImCrazeeh.ur2;

import java.util.logging.Logger;
import net.md_5.bungee.api.ChatColor;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private static final Logger log = Logger.getLogger("Minecraft");
    private static Economy econ = null;
    public Permission use = new Permission("rename.use");
    public Permission reload = new Permission("rename.reload");

    public void onEnable() {
        if (!this.setupEconomy()) {
            log.severe(String.format("[%s] - Disabled due to no Vault dependency found!", this.getDescription().getName()));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
    }

    public void onDisable() {
        this.saveDefaultConfig();
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        econ = (Economy)rsp.getProvider();
        return econ != null;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("rename") && !sender.hasPermission("rename.use") && sender instanceof Player) {
            sender.sendMessage(String.valueOf(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.prefix"))) + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.no-perm")));
        }
        Player p = (Player)sender;
        StringBuilder newName = new StringBuilder();
        int i = 0;
        while (i < args.length) {
            newName.append(String.valueOf(args[i]) + " ");
            ++i;
        }
        if (p.hasPermission("rename.use")) {
            if (this.getConfig().getString("costs.eco-enabled").equals("false") && this.getConfig().getString("costs.xp-enabled").equals("false") && newName.length() <= this.getConfig().getInt("max-char") && !p.getItemInHand().getType().equals((Object)Material.AIR)) {
                if (newName.length() > 0) {
                    ItemStack item = p.getItemInHand();
                    ItemMeta itemsMeta = item.getItemMeta();
                    itemsMeta.setDisplayName(ChatColor.WHITE + ChatColor.translateAlternateColorCodes((char)'&', (String)newName.toString()));
                    item.setItemMeta(itemsMeta);
                    p.sendMessage(String.valueOf(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.prefix"))) + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.success").replace("%new_name%", p.getItemInHand().getItemMeta().getDisplayName().toString())));
                    return true;
                }
                if (newName.length() <= 0 && !p.getItemInHand().getType().equals((Object)Material.AIR)) {
                    p.sendMessage(String.valueOf(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.prefix"))) + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.invalid-args")));
                }
            }
            if (this.getConfig().getString("costs.eco-enabled").equals("false") && this.getConfig().getString("costs.xp-enabled").equals("true") && newName.length() <= this.getConfig().getInt("max-char") && !p.getItemInHand().getType().equals((Object)Material.AIR) && newName.length() > 0) {
                if (p.getLevel() - this.getConfig().getInt("costs.xp-bars") >= 0) {
                    ItemStack item = p.getItemInHand();
                    ItemMeta itemsMeta = item.getItemMeta();
                    itemsMeta.setDisplayName(ChatColor.WHITE + ChatColor.translateAlternateColorCodes((char)'&', (String)newName.toString()));
                    item.setItemMeta(itemsMeta);
                    p.sendMessage(String.valueOf(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.prefix"))) + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.success").replace("%new_name%", p.getItemInHand().getItemMeta().getDisplayName().toString())));
                    p.setLevel(p.getLevel() - this.getConfig().getInt("costs.xp-bars"));
                    return true;
                }
                if (p.getLevel() < this.getConfig().getInt("costs.xp-bars")) {
                    p.sendMessage(String.valueOf(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.prefix"))) + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("costs.not-enough-xp")));
                }
            }
            if (this.getConfig().getString("costs.eco-enabled").equals("true") && this.getConfig().getString("costs.xp-enabled").equals("false") && newName.length() <= this.getConfig().getInt("max-char") && !p.getItemInHand().getType().equals((Object)Material.AIR)) {
                if (newName.length() > 0) {
                    EconomyResponse r = econ.withdrawPlayer((OfflinePlayer)p, (double)this.getConfig().getInt("costs.eco-price"));
                    if (r.transactionSuccess()) {
                        ItemStack item = p.getItemInHand();
                        ItemMeta itemsMeta = item.getItemMeta();
                        itemsMeta.setDisplayName(ChatColor.WHITE + ChatColor.translateAlternateColorCodes((char)'&', (String)newName.toString()));
                        item.setItemMeta(itemsMeta);
                        sender.sendMessage(String.valueOf(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.prefix"))) + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.success").replace("%cost%", econ.format(r.amount)).replace("%new_name%", p.getItemInHand().getItemMeta().getDisplayName().toString())));
                    } else {
                        p.sendMessage(String.valueOf(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.prefix"))) + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.not-enough-money").replace("%price%", this.getConfig().getString("costs.eco-price"))));
                    }
                    return true;
                }
                if (econ.getBalance((OfflinePlayer)p) < (double)this.getConfig().getInt("costs.eco-price") && newName.length() > 0) {
                    p.sendMessage(String.valueOf(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.prefix"))) + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.not-enough-money").replace("%price%", this.getConfig().getString("costs.eco-price"))));
                }
            }
            if (sender.hasPermission("rename.use")) {
                if (p.getItemInHand().getType().equals((Object)Material.AIR)) {
                    p.sendMessage(String.valueOf(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.prefix"))) + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.rename-air")));
                }
                if (newName.length() > this.getConfig().getInt("max-char")) {
                    p.sendMessage(String.valueOf(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.prefix"))) + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.over-max-char").replace("%max_char%", this.getConfig().getString("max-char"))));
                }
                if (!(sender instanceof Player)) {
                    sender.sendMessage(String.valueOf(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.prefix"))) + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.player-only")));
                }
                if (newName.length() <= 0 && !p.getItemInHand().getType().equals((Object)Material.AIR)) {
                    p.sendMessage(String.valueOf(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.prefix"))) + ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.invalid-args")));
                }
            }
        }
        return true;
    }
}

