/*
 * Decompiled with CFR 0.152.
 */
package com.diamonddagger590.caa.util;

import org.bukkit.Bukkit;

public enum Version {
    TOO_OLD(-1),
    v1_7_R1(171),
    v1_7_R2(172),
    v1_7_R3(173),
    v1_7_R4(174),
    v1_8_R1(181),
    v1_8_R2(182),
    v1_8_R3(183),
    v1_9_R1(191),
    v1_9_R2(192),
    v1_10_R1(1101),
    v1_11_R1(1111),
    v1_12_R1(1121),
    v1_13_R2(1132),
    v1_14_R1(1141),
    TOO_NEW(-2);

    public static Version currentVersion;
    private static Version latest;
    private Integer versionInteger;

    private Version(int versionInteger) {
        this.versionInteger = versionInteger;
    }

    public static Version getCurrentVersion() {
        if (currentVersion == null) {
            String ver = Bukkit.getServer().getClass().getPackage().getName();
            int v = Integer.parseInt(ver.substring(ver.lastIndexOf(46) + 1).replaceAll("_", "").replaceAll("R", "").replaceAll("v", ""));
            for (Version version : Version.values()) {
                if (version.getVersionInteger() != v) continue;
                currentVersion = version;
                break;
            }
            if (v > Version.getLatestVersion().getVersionInteger()) {
                currentVersion = Version.getLatestVersion();
            }
            if (currentVersion == null) {
                currentVersion = TOO_NEW;
            }
        }
        return currentVersion;
    }

    public static Version getLatestVersion() {
        if (latest == null) {
            Version v = TOO_OLD;
            for (Version version : Version.values()) {
                if (version.comparedTo(v) != 1) continue;
                v = version;
            }
            return v;
        }
        return latest;
    }

    public Integer getVersionInteger() {
        return this.versionInteger;
    }

    public Integer comparedTo(Version version) {
        int check;
        int resault = -1;
        int current = this.getVersionInteger();
        if (current > (check = version.getVersionInteger().intValue()) || check == -2) {
            resault = 1;
        } else if (current == check) {
            resault = 0;
        } else if (current < check || check == -1) {
            resault = -1;
        }
        return resault;
    }

    public Boolean isNewer(Version version) {
        return this.versionInteger > version.versionInteger || this.versionInteger == -2;
    }

    public Boolean isSame(Version version) {
        return this.versionInteger.equals(version.versionInteger);
    }

    public Boolean isOlder(Version version) {
        return this.versionInteger < version.versionInteger || this.versionInteger == -1;
    }
}

