/*
 * Decompiled with CFR 0.152.
 */
package com.diamonddagger590.caa.datastorage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class FileManager {
    private Plugin plugin;
    private String prefix = "";
    private Boolean log = false;
    private HashMap<Files, File> files = new HashMap();
    private ArrayList<String> homeFolders = new ArrayList();
    private ArrayList<CustomFile> customFiles = new ArrayList();
    private HashMap<String, String> autoGenerateFiles = new HashMap();
    private HashMap<Files, FileConfiguration> configurations = new HashMap();
    private static FileManager instance = new FileManager();

    public static FileManager getInstance() {
        return instance;
    }

    public void setup(Plugin plugin) {
        this.prefix = "[" + plugin.getName() + "] ";
        this.plugin = plugin;
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdirs();
        }
        this.files.clear();
        this.customFiles.clear();
        this.configurations.clear();
        for (Files file : Files.values()) {
            File newFile = new File(plugin.getDataFolder(), file.getFileLocation());
            if (this.log.booleanValue()) {
                System.out.println(this.prefix + "Loading the " + file.getFileName());
            }
            if (!newFile.exists()) {
                try {
                    File serverFile = new File(plugin.getDataFolder(), "/" + file.getFileLocation());
                    InputStream jarFile = this.getClass().getResourceAsStream("/" + file.getFileLocation());
                    this.copyFile(jarFile, serverFile);
                }
                catch (Exception e) {
                    if (this.log.booleanValue()) {
                        System.out.println(this.prefix + "Failed to load " + file.getFileName());
                    }
                    e.printStackTrace();
                    continue;
                }
            }
            this.files.put(file, newFile);
            this.configurations.put(file, (FileConfiguration)YamlConfiguration.loadConfiguration((File)newFile));
            if (!this.log.booleanValue()) continue;
            System.out.println(this.prefix + "Successfully loaded " + file.getFileName());
        }
        if (this.homeFolders.size() > 0) {
            if (this.log.booleanValue()) {
                System.out.println(this.prefix + "Loading custom files.");
            }
            for (String homeFolder : this.homeFolders) {
                if (new File(plugin.getDataFolder(), "/" + homeFolder).exists()) {
                    for (String name : new File(plugin.getDataFolder(), "/" + homeFolder).list()) {
                        CustomFile file;
                        if (!name.endsWith(".yml") || !(file = new CustomFile(name, homeFolder, plugin)).exists().booleanValue()) continue;
                        this.customFiles.add(file);
                        if (!this.log.booleanValue()) continue;
                        System.out.println(this.prefix + "Loaded custom file: " + homeFolder + "/" + name + ".");
                    }
                    continue;
                }
                new File(plugin.getDataFolder(), "/" + homeFolder).mkdir();
                if (this.log.booleanValue()) {
                    System.out.println(this.prefix + "The folder " + homeFolder + "/ was not found so it was created.");
                }
                for (String fileName : this.autoGenerateFiles.keySet()) {
                    if (!this.autoGenerateFiles.get(fileName).equalsIgnoreCase(homeFolder)) continue;
                    homeFolder = this.autoGenerateFiles.get(fileName);
                    try {
                        File serverFile = new File(plugin.getDataFolder(), homeFolder + "/" + fileName);
                        InputStream jarFile = this.getClass().getResourceAsStream(homeFolder + "/" + fileName);
                        this.copyFile(jarFile, serverFile);
                        if (fileName.toLowerCase().endsWith(".yml")) {
                            this.customFiles.add(new CustomFile(fileName, homeFolder, plugin));
                        }
                        if (!this.log.booleanValue()) continue;
                        System.out.println(this.prefix + "Created new default file: " + homeFolder + "/" + fileName + ".");
                    }
                    catch (Exception e) {
                        if (this.log.booleanValue()) {
                            System.out.println(this.prefix + "Failed to create new default file: " + homeFolder + "/" + fileName + "!");
                        }
                        e.printStackTrace();
                    }
                }
            }
            if (this.log.booleanValue()) {
                System.out.println(this.prefix + "Finished loading custom files.");
            }
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public FileManager logInfo(Boolean log) {
        this.log = log;
        return this;
    }

    public Boolean isLogging() {
        return this.log;
    }

    public FileManager registerCustomFilesFolder(String homeFolder) {
        this.homeFolders.add(homeFolder);
        return this;
    }

    public FileManager unregisterCustomFilesFolder(String homeFolder) {
        this.homeFolders.remove(homeFolder);
        return this;
    }

    public FileManager registerDefaultGenerateFiles(String fileName, String homeFolder) {
        this.autoGenerateFiles.put(fileName, homeFolder);
        return this;
    }

    public FileManager unregisterDefaultGenerateFiles(String fileName) {
        this.autoGenerateFiles.remove(fileName);
        return this;
    }

    public FileConfiguration getFile(Files file) {
        return this.configurations.get((Object)file);
    }

    public CustomFile getFile(String name) {
        for (CustomFile file : this.customFiles) {
            if (!file.getName().toLowerCase().equalsIgnoreCase(name.toLowerCase())) continue;
            return file;
        }
        return null;
    }

    public void saveFile(Files file) {
        try {
            this.configurations.get((Object)file).save(this.files.get((Object)file));
        }
        catch (IOException e) {
            System.out.println(this.prefix + "Could not save " + file.getFileName() + "!");
            e.printStackTrace();
        }
    }

    public void saveFile(String name) {
        CustomFile file = this.getFile(name);
        if (file != null) {
            try {
                file.getFile().save(new File(this.plugin.getDataFolder(), file.getHomeFolder() + "/" + file.getFileName()));
                if (this.log.booleanValue()) {
                    System.out.println(this.prefix + "Successfuly saved the " + file.getFileName() + ".");
                }
            }
            catch (Exception e) {
                System.out.println(this.prefix + "Could not save " + file.getFileName() + "!");
                e.printStackTrace();
            }
        } else if (this.log.booleanValue()) {
            System.out.println(this.prefix + "The file " + name + ".yml could not be found!");
        }
    }

    public Boolean saveFile(CustomFile file) {
        return file.saveFile();
    }

    public void reloadFile(Files file) {
        this.configurations.put(file, (FileConfiguration)YamlConfiguration.loadConfiguration((File)this.files.get((Object)file)));
    }

    public void reloadFile(String name) {
        CustomFile file = this.getFile(name);
        if (file != null) {
            try {
                file.file = (FileConfiguration)YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), "/" + file.getHomeFolder() + "/" + file.getFileName()));
                if (this.log.booleanValue()) {
                    System.out.println(this.prefix + "Successfuly reload the " + file.getFileName() + ".");
                }
            }
            catch (Exception e) {
                System.out.println(this.prefix + "Could not reload the " + file.getFileName() + "!");
                e.printStackTrace();
            }
        } else if (this.log.booleanValue()) {
            System.out.println(this.prefix + "The file " + name + ".yml could not be found!");
        }
    }

    public Boolean reloadFile(CustomFile file) {
        return file.reloadFile();
    }

    public void reloadAllFiles() {
        for (Files file : Files.values()) {
            file.relaodFile();
        }
        for (CustomFile file : this.customFiles) {
            file.reloadFile();
        }
    }

    public ArrayList<String> getAllCratesNames() {
        ArrayList<String> files = new ArrayList<String>();
        for (String name : new File(this.plugin.getDataFolder(), "/Crates").list()) {
            if (!name.endsWith(".yml")) continue;
            files.add(name.replaceAll(".yml", ""));
        }
        return files;
    }

    private void copyFile(InputStream in, File out) throws Exception {
        try (InputStream fis = in;
             FileOutputStream fos = new FileOutputStream(out);){
            int i;
            byte[] buf = new byte[1024];
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
    }

    public class CustomFile {
        private String name;
        private Plugin plugin;
        private String fileName;
        private String homeFolder;
        private FileConfiguration file;

        public CustomFile(String name, String homeFolder, Plugin plugin) {
            this.name = name.replace(".yml", "");
            this.plugin = plugin;
            this.fileName = name;
            this.homeFolder = homeFolder;
            if (new File(plugin.getDataFolder(), "/" + homeFolder).exists()) {
                this.file = new File(plugin.getDataFolder(), "/" + homeFolder + "/" + name).exists() ? YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "/" + homeFolder + "/" + name)) : null;
            } else {
                new File(plugin.getDataFolder(), "/" + homeFolder).mkdir();
                if (FileManager.this.log.booleanValue()) {
                    System.out.println(FileManager.this.prefix + "The folder " + homeFolder + "/ was not found so it was created.");
                }
                this.file = null;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getHomeFolder() {
            return this.homeFolder;
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        public FileConfiguration getFile() {
            return this.file;
        }

        public Boolean exists() {
            return this.file != null;
        }

        public Boolean saveFile() {
            if (this.file != null) {
                try {
                    this.file.save(new File(this.plugin.getDataFolder(), this.homeFolder + "/" + this.fileName));
                    if (FileManager.this.log.booleanValue()) {
                        System.out.println(FileManager.this.prefix + "Successfuly saved the " + this.fileName + ".");
                    }
                    return true;
                }
                catch (Exception e) {
                    System.out.println(FileManager.this.prefix + "Could not save " + this.fileName + "!");
                    e.printStackTrace();
                    return false;
                }
            }
            if (FileManager.this.log.booleanValue()) {
                System.out.println(FileManager.this.prefix + "There was a null custom file that could not be found!");
            }
            return false;
        }

        public Boolean reloadFile() {
            if (this.file != null) {
                try {
                    this.file = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), "/" + this.homeFolder + "/" + this.fileName));
                    if (FileManager.this.log.booleanValue()) {
                        System.out.println(FileManager.this.prefix + "Successfuly reload the " + this.fileName + ".");
                    }
                    return true;
                }
                catch (Exception e) {
                    System.out.println(FileManager.this.prefix + "Could not reload the " + this.fileName + "!");
                    e.printStackTrace();
                }
            } else if (FileManager.this.log.booleanValue()) {
                System.out.println(FileManager.this.prefix + "There was a null custom file that was not found!");
            }
            return false;
        }
    }

    public static enum Files {
        CONFIG("config.yml", "config.yml");

        private String fileName;
        private String fileLocation;

        private Files(String fileName, String fileLocation) {
            this.fileName = fileName;
            this.fileLocation = fileLocation;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFileLocation() {
            return this.fileLocation;
        }

        public FileConfiguration getFile() {
            return FileManager.getInstance().getFile(this);
        }

        public void saveFile() {
            FileManager.getInstance().saveFile(this);
        }

        public void relaodFile() {
            FileManager.getInstance().reloadFile(this);
        }
    }
}

