/*
 * Decompiled with CFR 0.152.
 */
package me.imjustasking.staffutilities.listeners;

import me.imjustasking.staffutilities.Core;
import me.imjustasking.staffutilities.commands.FreezeCMD;
import me.imjustasking.staffutilities.managers.GUIManager;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FrozenPlayerListeners
implements Listener {
    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        Player player = e.getPlayer();
        FileConfiguration config = Core.plugin.getConfig();
        if (FreezeCMD.frozenPlayers.contains(player.getUniqueId())) {
            player.teleport(FreezeCMD.frozenPlayersLoc.get(player.getUniqueId()));
            player.sendMessage(config.getString("Errors.YouAreFrozen").replace("&", "\u00a7"));
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent e) {
        if (e.getEntity() instanceof Player && e.getDamager() instanceof Player) {
            Player player = (Player)e.getEntity();
            Player attacker = (Player)e.getDamager();
            FileConfiguration config = Core.plugin.getConfig();
            if (FreezeCMD.frozenPlayers.contains(player.getUniqueId())) {
                e.setCancelled(true);
                attacker.sendMessage(config.getString("Errors.AttackedPlayerIsFrozen").replace("&", "\u00a7"));
            }
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent e) {
        Player player;
        if (e.getEntity() instanceof Player && FreezeCMD.frozenPlayers.contains((player = (Player)e.getEntity()).getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        FileConfiguration config = Core.plugin.getConfig();
        if (FreezeCMD.frozenPlayers.contains(player.getUniqueId())) {
            Player[] playerArray = Bukkit.getOnlinePlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player staff = playerArray[n2];
                if (staff.hasPermission("staffutils.freeze")) {
                    staff.sendMessage(String.valueOf(config.getString("Prefixes.Main").replace("&", "\u00a7")) + " " + config.getString("Messages.FrozenPlayerDisconnected").replace("&", "\u00a7").replace("%player%", player.getName()));
                }
                ++n2;
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        final Player player = (Player)e.getPlayer();
        if (FreezeCMD.frozenPlayers.contains(player.getUniqueId())) {
            new BukkitRunnable(){

                public void run() {
                    new GUIManager().frozenInventory(player);
                }
            }.runTaskLater((Plugin)Core.plugin, 2L);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        Player player = (Player)e.getWhoClicked();
        FileConfiguration config = Core.plugin.getConfig();
        if (FreezeCMD.frozenPlayers.contains(player.getUniqueId()) && e.getInventory().getName().equals(config.getString("GUIMenus.FreezeGUI.Title").replace("&", "\u00a7"))) {
            e.setCancelled(true);
        }
    }
}

