/*
 * Decompiled with CFR 0.152.
 */
package com.officialjonesy.maintenance;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Maintenance
extends JavaPlugin
implements Listener {
    private static Maintenance p;

    public void onEnable() {
        this.saveDefaultConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        p = this;
    }

    public static Maintenance getInstance() {
        return p;
    }

    @EventHandler
    public void onLogin(PlayerLoginEvent e) {
        if (!this.getConfig().getBoolean("maintenance")) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        this.reloadConfig();
        if (!e.getPlayer().hasPermission(this.getConfig().getString("bypass-permission"))) {
            for (String s : this.getConfig().getStringList("messages")) {
                sb.append(this.tl(String.valueOf(s) + "\n"));
            }
            e.disallow(PlayerLoginEvent.Result.KICK_OTHER, sb.toString());
        }
    }

    public String tl(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("maintenance")) {
            boolean maintenance = this.getConfig().getBoolean("maintenance");
            if (!sender.hasPermission(this.getConfig().getString("command-execute-permission"))) {
                sender.sendMessage(this.tl(this.getConfig().getString("command-no-permission-message")));
                return true;
            }
            if (args.length < 1) {
                if (maintenance) {
                    sender.sendMessage(this.tl(this.getConfig().getString("maintenance-on-message")));
                } else {
                    sender.sendMessage(this.tl(this.getConfig().getString("maintenance-off-message")));
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("true") || args[0].equalsIgnoreCase("1") || args[0].equalsIgnoreCase("on")) {
                this.getConfig().set("maintenance", (Object)true);
                this.saveConfig();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (p.hasPermission(this.getConfig().getString("bypass-permission"))) continue;
                    StringBuilder sb = new StringBuilder();
                    this.reloadConfig();
                    for (String s : this.getConfig().getStringList("messages")) {
                        sb.append(this.tl(String.valueOf(s) + "\n"));
                    }
                    p.kickPlayer(sb.toString());
                }
                sender.sendMessage(this.tl(this.getConfig().getString("maintenance-enabled-message")));
            } else {
                this.getConfig().set("maintenance", (Object)false);
                this.saveConfig();
                sender.sendMessage(this.tl(this.getConfig().getString("maintenance-disabled-message")));
            }
            return true;
        }
        return false;
    }

    @EventHandler
    public void onServerPing(ServerListPingEvent e) {
        if (this.getConfig().getBoolean("maintenance") && this.getConfig().getBoolean("change-server-list-message")) {
            e.setMotd(this.tl(this.getConfig().getString("motd")));
        }
    }
}

