/*
 * Decompiled with CFR 0.152.
 */
package cz.Vanda.anni.object;

import cz.Vanda.anni.Main;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class Shop
implements Listener {
    private String name;
    private ArrayList<ShopItem> items;

    public Shop(Main plugin, String name, Configuration config) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.name = name;
        this.loadConfig(config);
    }

    @EventHandler
    public void onSignClick(PlayerInteractEvent e) {
        Material type;
        if (e.getClickedBlock() != null && ((type = e.getClickedBlock().getType()) == Material.WALL_SIGN || type == Material.SIGN_POST)) {
            Sign sign = (Sign)e.getClickedBlock().getState();
            String line0 = sign.getLine(0);
            String line1 = sign.getLine(1);
            if (line0.equals(ChatColor.DARK_PURPLE + "[Shop]") && line1.equals(this.name)) {
                this.openShop(e.getPlayer());
            }
        }
    }

    @EventHandler
    public void onSignClick2(PlayerInteractEvent e) {
        Material type;
        if (e.getClickedBlock() != null && ((type = e.getClickedBlock().getType()) == Material.WALL_SIGN || type == Material.SIGN_POST)) {
            Sign sign = (Sign)e.getClickedBlock().getState();
            String line0 = sign.getLine(0);
            String line1 = sign.getLine(1);
            if (line0.equals("Shop") && line1.equals(this.name)) {
                this.openShop(e.getPlayer());
            }
        }
    }

    @EventHandler
    public void onShopInventoryClick(InventoryClickEvent e) {
        Player buyer = (Player)e.getWhoClicked();
        if (e.getInventory().getName().equals(String.valueOf(this.name) + " Shop")) {
            int slot = e.getRawSlot();
            if (slot < e.getInventory().getSize() && slot >= 0) {
                if (slot < this.items.size() && this.items.get(slot) != null) {
                    this.sellItem(buyer, this.items.get(slot));
                }
                e.setCancelled(true);
            }
            buyer.updateInventory();
        }
    }

    private void openShop(Player player) {
        if (Main.getInstance().getPhase() < 4 && (this.name == "Brewing" || this.name == "brewing")) {
            String prefix = Main.getInstance().getConfig().getString("prefix").replace("&", "\u00a7");
            player.sendMessage(String.valueOf(prefix) + " \u00a7eBrewing shop is aviable in phase IV");
            return;
        }
        int size = 9 * (int)Math.ceil((double)this.items.size() / 9.0);
        Inventory shopInv = Bukkit.getServer().createInventory((InventoryHolder)player, size, String.valueOf(this.name) + " Shop");
        int i = 0;
        while (i < this.items.size()) {
            ShopItem item = this.items.get(i);
            if (item != null) {
                shopInv.setItem(i, item.getShopStack());
            } else {
                shopInv.setItem(i, null);
            }
            ++i;
        }
        player.openInventory(shopInv);
    }

    private void sellItem(Player buyer, ShopItem item) {
        PlayerInventory buyerInv = buyer.getInventory();
        ItemStack stackToGive = item.getItemStack();
        int price = item.getPrice();
        String stackName = ChatColor.WHITE + item.getName();
        if (buyerInv.contains(Material.GOLD_INGOT, price)) {
            buyerInv.removeItem(new ItemStack[]{new ItemStack(Material.GOLD_INGOT, price)});
            buyerInv.addItem(new ItemStack[]{stackToGive});
            buyer.sendMessage(String.valueOf(Main.getInstance().getConfig().getString("prefix").replace("&", "\u00a7")) + " \u00a77You bought item: \u00a7b" + stackName);
        } else {
            buyer.sendMessage(String.valueOf(Main.getInstance().getConfig().getString("prefix").replace("&", "\u00a7")) + " \u00a7cYou don't have lot of gold's to bought: \u00a7b" + stackName);
        }
    }

    private void loadConfig(Configuration config) {
        this.items = new ArrayList();
        List list = config.getStringList(this.name.toLowerCase());
        for (String entry : list) {
            if (entry.equalsIgnoreCase("nextline")) {
                int end = 9 * (int)Math.ceil((double)this.items.size() / 9.0);
                int i = this.items.size();
                while (i < end) {
                    this.items.add(null);
                    ++i;
                }
                continue;
            }
            String[] params = entry.split(",");
            if (params.length < 3) continue;
            Material type = Material.getMaterial((String)params[0]);
            int qty = Integer.valueOf(params[1]);
            int price = Integer.valueOf(params[2]);
            ShopItem item = new ShopItem(type, qty, price);
            if (params.length >= 4) {
                String itemName = params[3].replace("\"", "");
                item.setName(ChatColor.translateAlternateColorCodes((char)'&', (String)itemName));
            }
            this.items.add(item);
        }
    }

    private static class ShopItem {
        private ItemStack item;
        private int price;

        public ShopItem(Material type, int qty, int price) {
            this.item = new ItemStack(type);
            this.price = price;
            this.item.setAmount(qty);
        }

        public ShopItem setName(String name) {
            ItemMeta meta = this.item.getItemMeta();
            meta.setDisplayName(ChatColor.AQUA + name);
            this.item.setItemMeta(meta);
            return this;
        }

        public ItemStack getShopStack() {
            ItemStack stack = this.item.clone();
            String priceStr = String.valueOf(ChatColor.YELLOW.toString()) + this.price + " Gold";
            ItemMeta meta = stack.getItemMeta();
            if (meta.hasLore()) {
                meta.getLore().add(priceStr);
            } else {
                meta.setLore(Arrays.asList(priceStr));
            }
            stack.setItemMeta(meta);
            return stack;
        }

        public ItemStack getItemStack() {
            return this.item;
        }

        public int getPrice() {
            return this.price;
        }

        public String getName() {
            String name;
            ItemMeta meta = this.item.getItemMeta();
            if (meta.hasDisplayName()) {
                name = meta.getDisplayName();
            } else {
                name = this.item.getType().name();
                name = name.replace("_", " ").toLowerCase();
                name = WordUtils.capitalize((String)name);
                name = String.valueOf(name) + ChatColor.WHITE;
            }
            if (this.item.getAmount() > 1) {
                name = String.valueOf(this.item.getAmount()) + " " + name;
            }
            return name;
        }
    }
}

