/*
 * Decompiled with CFR 0.152.
 */
package cz.Vanda.anni.object;

import cz.Vanda.anni.Main;
import cz.Vanda.anni.listeners.SoulboundListener;
import cz.Vanda.anni.object.GameTeam;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public enum Kit {
    CIVILIAN(Material.WORKBENCH){
        {
            this.spawnItems.add(new ItemStack(Material.WOOD_SWORD));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            this.spawnItems.add(new ItemStack(Material.WORKBENCH));
            this.lore.add("You are the backbone.");
            this.lore.add("");
            this.lore.add("Fuel all facets of the");
            this.lore.add("war machine with your");
            this.lore.add("set of wooden tools and");
            this.lore.add("prepare for battle!");
        }
    }
    ,
    WARRIOR(Material.STONE_SWORD){
        {
            this.spawnItems.add(new ItemStack(Material.STONE_SWORD));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            this.spawnItems.add(new Potion(PotionType.INSTANT_HEAL, 1).toItemStack(1));
            ((ItemStack)this.spawnItems.get(0)).addEnchantment(Enchantment.KNOCKBACK, 1);
            this.lore.add("You are the sword.");
            this.lore.add("");
            this.lore.add("You deal +1 damage with");
            this.lore.add("any melee weapon.");
            this.lore.add("");
            this.lore.add("Spawn with a knockback");
            this.lore.add("sword and a health potion");
            this.lore.add("which enable you to move");
            this.lore.add("immediately on the enemy");
            this.lore.add("and attack!");
        }
    }
    ,
    ARCHER(Material.BOW){
        {
            this.spawnItems.add(new ItemStack(Material.WOOD_SWORD));
            this.spawnItems.add(new ItemStack(Material.BOW));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_SPADE));
            this.spawnItems.add(new Potion(PotionType.INSTANT_HEAL, 1).toItemStack(1));
            this.spawnItems.add(new ItemStack(Material.ARROW, 16));
            ((ItemStack)this.spawnItems.get(1)).addEnchantment(Enchantment.ARROW_KNOCKBACK, 1);
            this.lore.add("You are the rain.");
            this.lore.add("");
            this.lore.add("You deal +1 damage with");
            this.lore.add("a bow and can craft arrows");
            this.lore.add("without feathers.");
            this.lore.add("");
            this.lore.add("Place flint on top of sticks");
            this.lore.add("in your crafting interface");
            this.lore.add("to create 3 arrows!");
        }
    }
    ,
    MINER(Material.STONE_PICKAXE){
        {
            this.spawnItems.add(new ItemStack(Material.WOOD_SWORD));
            this.spawnItems.add(new ItemStack(Material.STONE_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            this.spawnItems.add(new ItemStack(Material.FURNACE));
            this.spawnItems.add(new ItemStack(Material.COAL, 4));
            ((ItemStack)this.spawnItems.get(1)).addEnchantment(Enchantment.DIG_SPEED, 1);
            ((ItemStack)this.spawnItems.get(1)).addEnchantment(Enchantment.LOOT_BONUS_BLOCKS, 1);
            this.lore.add("You are the hands.");
            this.lore.add("");
            this.lore.add("Spawn with an efficiency and Fortune");
            this.lore.add("stone pickaxe and mine");
            this.lore.add("precious resources for");
            this.lore.add("your team more quickly with");
            this.lore.add("your doubled ore drops!");
        }
    }
    ,
    LUMBERJACK(Material.STONE_AXE){
        {
            this.spawnItems.add(new ItemStack(Material.WOOD_SWORD));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.STONE_AXE));
            ((ItemStack)this.spawnItems.get(2)).addEnchantment(Enchantment.DIG_SPEED, 1);
            this.lore.add("You are the wedge.");
            this.lore.add("");
            this.lore.add("Spawn with an efficiency");
            this.lore.add("stone axe and use your");
            this.lore.add("doubled log drops to obtain");
            this.lore.add("large amounts of wood for");
            this.lore.add("your team's builders!");
        }
    }
    ,
    SCOUT(Material.FISHING_ROD){
        {
            this.spawnItems.add(new ItemStack(Material.GOLD_SWORD));
            this.spawnItems.add(new ItemStack(Material.FISHING_ROD));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            ItemMeta meta = ((ItemStack)this.spawnItems.get(1)).getItemMeta();
            meta.setDisplayName("Grapple");
            ((ItemStack)this.spawnItems.get(1)).setItemMeta(meta);
            this.lore.add("You are the feet.");
            this.lore.add("");
            this.lore.add("Use your permanent speed");
            this.lore.add("boost to maneuver around");
            this.lore.add("the battlefield and your");
            this.lore.add("grapple to climb obstacles");
            this.lore.add("and enemy defenses!");
            this.lore.add("");
            this.lore.add("You can only wear light");
            this.lore.add("armor; anything heavier");
            this.lore.add("than chainmail will slow");
            this.lore.add("you down.");
        }
    }
    ,
    BERSERKER(Material.CHAINMAIL_CHESTPLATE){
        {
            this.spawnItems.add(new ItemStack(Material.STONE_SWORD));
            this.spawnItems.add(new ItemStack(Material.WOOD_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.WOOD_AXE));
            this.spawnItems.add(new Potion(PotionType.INSTANT_HEAL, 1).toItemStack(1));
            this.lore.add("You are the tank.");
            this.lore.add("");
            this.lore.add("Start each life with only");
            this.lore.add("7 hearts. For every enemy");
            this.lore.add("kill, you garner yourself");
            this.lore.add("an extra heart, allowing");
            this.lore.add("you to gain up to 15 hearts!");
        }
    }
    ,
    SPY(Material.POTION){
        {
            this.spawnItems.add(new ItemStack(Material.STONE_SWORD));
            this.spawnItems.add(new ItemStack(Material.STONE_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.STONE_AXE));
            this.lore.add("You are the Spy");
            this.lore.add("");
            this.lore.add("You Click Shift");
            this.lore.add("You give Potion Effect Invisibility 10 secounds!");
        }
    }
    ,
    DEFENDER(Material.IRON_CHESTPLATE){
        {
            this.spawnItems.add(new ItemStack(Material.STONE_SWORD));
            this.spawnItems.add(new ItemStack(Material.STONE_PICKAXE));
            this.spawnItems.add(new ItemStack(Material.STONE_AXE));
            this.lore.add("You are the Defender");
            this.lore.add("");
            this.lore.add("Killer is low Damage");
            this.lore.add("You KILLER!");
        }
    };

    private ItemStack icon;
    List<String> lore = new ArrayList<String>();
    List<ItemStack> spawnItems = new ArrayList<ItemStack>();
    ItemStack[] spawnArmor = new ItemStack[]{new ItemStack(Material.LEATHER_BOOTS), new ItemStack(Material.LEATHER_LEGGINGS), new ItemStack(Material.LEATHER_CHESTPLATE), new ItemStack(Material.LEATHER_HELMET)};

    static {
        Kit[] kitArray = Kit.values();
        int n = kitArray.length;
        int n2 = 0;
        while (n2 < n) {
            Kit kit = kitArray[n2];
            kit.init();
            ++n2;
        }
    }

    private Kit(Material m) {
        this.icon = new ItemStack(m);
        ItemMeta meta = this.icon.getItemMeta();
        meta.setDisplayName(this.getName());
        this.icon.setItemMeta(meta);
    }

    private void init() {
        int i = 0;
        while (i < this.lore.size()) {
            String s = this.lore.get(i);
            s = ChatColor.AQUA + s;
            this.lore.set(i, s);
            ++i;
        }
        ItemMeta meta = this.icon.getItemMeta();
        meta.setLore(this.lore);
        this.icon.setItemMeta(meta);
    }

    public static Kit getKit(String name) {
        Kit[] kitArray = Kit.values();
        int n = kitArray.length;
        int n2 = 0;
        while (n2 < n) {
            Kit type = kitArray[n2];
            if (type.name().equalsIgnoreCase(name)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public void give(Player recipient, GameTeam team) {
        PlayerInventory inv = recipient.getInventory();
        inv.clear();
        for (ItemStack item : this.spawnItems) {
            ItemStack toGive = item.clone();
            SoulboundListener.soulbind(toGive);
            inv.addItem(new ItemStack[]{toGive});
        }
        recipient.removePotionEffect(PotionEffectType.SPEED);
        ItemStack compass = new ItemStack(Material.COMPASS);
        ItemMeta compassMeta = compass.getItemMeta();
        Main plugin = Main.getInstance();
        String kompas = plugin.getConfig().getString("CompassItem").replace("&", "\u00a7").replace("%TEAM%", String.valueOf(team.toString())).replaceAll("%COLOR%", String.valueOf(team.color()));
        compassMeta.setDisplayName(kompas);
        compass.setItemMeta(compassMeta);
        SoulboundListener.soulbind(compass);
        inv.addItem(new ItemStack[]{compass});
        recipient.setCompassTarget(team.getNexus().getLocation());
        inv.setArmorContents(this.spawnArmor);
        this.colorizeArmor(inv, this.getTeamColor(team));
        ItemStack[] itemStackArray = inv.getArmorContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack armor = itemStackArray[n2];
            SoulboundListener.soulbind(armor);
            ++n2;
        }
        if (this == SCOUT) {
            this.addScoutParticles(recipient);
        }
        if (this == BERSERKER) {
            recipient.setMaxHealth(14.0);
        } else {
            recipient.setMaxHealth(20.0);
        }
    }

    private Color getTeamColor(GameTeam team) {
        switch (team) {
            case RED: {
                return Color.RED;
            }
            case YELLOW: {
                return Color.YELLOW;
            }
            case GREEN: {
                return Color.GREEN;
            }
            case BLUE: {
                return Color.BLUE;
            }
        }
        return Color.WHITE;
    }

    private void colorizeArmor(PlayerInventory inv, Color color) {
        ItemStack[] itemStackArray = inv.getArmorContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            if (item.getItemMeta() instanceof LeatherArmorMeta) {
                LeatherArmorMeta meta = (LeatherArmorMeta)item.getItemMeta();
                meta.setColor(color);
                item.setItemMeta((ItemMeta)meta);
            }
            ++n2;
        }
    }

    public String getName() {
        return String.valueOf(this.name().substring(0, 1)) + this.name().substring(1).toLowerCase();
    }

    public boolean isOwnedBy(Player p) {
        return p.isOp() || this == CIVILIAN || p.hasPermission("anni.class." + this.getName().toLowerCase());
    }

    public void addScoutParticles(Player p) {
        if (this != SCOUT) {
            return;
        }
        p.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 0, true), true);
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    /* synthetic */ Kit(String string, int n, Material material, Kit kit) {
        this(material);
    }
}

