/*
 * Decompiled with CFR 0.152.
 */
package cz.Vanda.anni.object;

import cz.Vanda.anni.object.Nexus;
import cz.Vanda.anni.object.PlayerMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public enum GameTeam {
    RED,
    YELLOW,
    GREEN,
    BLUE,
    NONE;

    private final ChatColor color = this.name().equals("NONE") ? ChatColor.WHITE : ChatColor.valueOf((String)this.name());
    private List<Location> spawns = new ArrayList<Location>();
    private Nexus nexus;

    public String toString() {
        return String.valueOf(this.name().substring(0, 1)) + this.name().substring(1).toLowerCase();
    }

    public String coloredName() {
        return String.valueOf(this.color().toString()) + this.toString();
    }

    public ChatColor color() {
        return this.color;
    }

    public Nexus getNexus() {
        if (this != NONE) {
            return this.nexus;
        }
        return null;
    }

    public void loadNexus(Location loc, int health) {
        if (this != NONE) {
            this.nexus = new Nexus(this, loc, health);
        }
    }

    public void addSpawn(Location loc) {
        if (this != NONE) {
            this.spawns.add(loc);
        }
    }

    public Location getRandomSpawn() {
        if (!this.spawns.isEmpty() && this != NONE) {
            return this.spawns.get(new Random().nextInt(this.spawns.size()));
        }
        return null;
    }

    public List<Location> getSpawns() {
        return this.spawns;
    }

    public List<Player> getPlayers() {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (PlayerMeta.getMeta(p).getTeam() != this || this == NONE) continue;
            players.add(p);
        }
        return players;
    }

    public static GameTeam[] teams() {
        return new GameTeam[]{RED, YELLOW, GREEN, BLUE};
    }

    public Color getColor(GameTeam gt) {
        if (gt == RED) {
            return Color.RED;
        }
        if (gt == BLUE) {
            return Color.BLUE;
        }
        if (gt == GREEN) {
            return Color.LIME;
        }
        if (gt == YELLOW) {
            return Color.YELLOW;
        }
        return null;
    }

    public void loadNexus(Location loc, YamlConfiguration config) {
    }
}

