/*
 * Decompiled with CFR 0.152.
 */
package cz.Vanda.anni.maps;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.bukkit.Bukkit;

public class MapLoader {
    private final Logger log;
    private final File dataFolder;

    public MapLoader(Logger log, File dataFolder) {
        this.dataFolder = dataFolder;
        this.log = log;
    }

    public boolean loadMap(String name) {
        File mapsFolder = new File(this.dataFolder, "maps");
        if (!mapsFolder.exists()) {
            return false;
        }
        File source = new File(mapsFolder, name);
        if (!source.exists()) {
            return false;
        }
        Bukkit.unloadWorld((String)name, (boolean)false);
        File destination = new File(this.dataFolder.getParentFile().getParentFile(), String.valueOf(name) + File.separator + "region");
        try {
            this.copyFolder(source, destination);
            return true;
        }
        catch (IOException e) {
            this.log.severe("unable to load map " + name);
            return false;
        }
    }

    public boolean saveMap(String name) {
        File source;
        File mapsFolder = new File(this.dataFolder, "maps");
        if (!mapsFolder.exists()) {
            mapsFolder.mkdir();
        }
        if (!(source = new File(this.dataFolder.getParentFile().getParentFile(), String.valueOf(name) + File.separator + "region")).exists()) {
            return false;
        }
        File destination = new File(mapsFolder, name);
        try {
            this.copyFolder(source, destination);
            return true;
        }
        catch (IOException e) {
            this.log.severe("unable to save map " + name);
            return false;
        }
    }

    private void copyFolder(File src, File dest) throws IOException {
        if (!src.exists()) {
            this.log.severe("File " + src.toString() + " does not exist, cannot copy");
            return;
        }
        if (src.isDirectory()) {
            boolean existed = dest.exists();
            if (!existed) {
                dest.mkdir();
            }
            String[] srcFiles = src.list();
            if (existed) {
                this.log.info("Copying folder " + src.getAbsolutePath() + " and overwriting " + dest.getAbsolutePath());
            } else {
                this.log.info("Copying folder " + src.getAbsolutePath() + " to " + dest.getAbsolutePath());
            }
            String[] stringArray = srcFiles;
            int n = srcFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                this.copyFolder(srcFile, destFile);
                ++n2;
            }
            if (existed) {
                this.log.info("Overwrote folder " + dest.getAbsolutePath());
            } else {
                this.log.info("Copied folder " + dest.getAbsolutePath());
            }
        } else {
            int length;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            boolean existed = dest.exists();
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            if (existed) {
                this.log.info("Overwrote file " + dest.getName());
            } else {
                this.log.info("Copied file " + dest.getName());
            }
        }
    }
}

