/*
 * Decompiled with CFR 0.152.
 */
package cz.Vanda.anni.manager;

import cz.Vanda.anni.Main;
import cz.Vanda.anni.Util;
import cz.Vanda.anni.object.GameTeam;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.configuration.file.YamlConfiguration;

public class SignManager {
    private Main plugin;
    private HashMap<GameTeam, ArrayList<Location>> signs = new HashMap();

    public SignManager(Main instance) {
        this.plugin = instance;
    }

    public void loadSigns() {
        YamlConfiguration config = this.plugin.getConfigManager().getConfig("maps.yml");
        GameTeam[] gameTeamArray = GameTeam.teams();
        int n = gameTeamArray.length;
        int n2 = 0;
        while (n2 < n) {
            GameTeam team = gameTeamArray[n2];
            this.signs.put(team, new ArrayList());
            String name = team.name().toLowerCase();
            for (String l : config.getStringList("lobby.signs." + name)) {
                Location loc = Util.parseLocation(Bukkit.getWorld((String)"lobby"), l);
                if (loc == null) continue;
                this.addTeamSign(team, loc);
            }
            ++n2;
        }
    }

    public void addTeamSign(GameTeam team, Location loc) {
        Block b = loc.getBlock();
        if (b == null) {
            return;
        }
        Material m = b.getType();
        if (m == Material.SIGN_POST || m == Material.WALL_SIGN) {
            this.signs.get((Object)team).add(loc);
            this.updateSigns(team);
        }
    }

    public void updateSigns(GameTeam t) {
        if (t == GameTeam.NONE) {
            return;
        }
        for (Location l : this.signs.get((Object)t)) {
            Block b = l.getBlock();
            if (b == null) {
                return;
            }
            Material m = b.getType();
            if (m != Material.SIGN_POST && m != Material.WALL_SIGN) continue;
            Sign s = (Sign)b.getState();
            s.setLine(0, ChatColor.DARK_PURPLE + "[Team]");
            s.setLine(1, t.coloredName());
            s.setLine(2, String.valueOf(ChatColor.UNDERLINE.toString()) + t.getPlayers().size() + (t.getPlayers().size() == 1 ? " Player" : " Player's"));
            if (t.getNexus() != null && this.plugin.getPhase() > 0) {
                s.setLine(3, String.valueOf(ChatColor.BOLD.toString()) + "Nexus: " + t.getNexus().getHealth());
            } else {
                s.setLine(3, " ");
            }
            s.update(true);
        }
    }
}

