/*
 * Decompiled with CFR 0.152.
 */
package cz.Vanda.anni.manager;

import cz.Vanda.anni.Main;
import cz.Vanda.anni.Util;
import cz.Vanda.anni.bar.ActionAPI;
import cz.Vanda.anni.manager.PhaseManager;
import cz.Vanda.anni.object.GameTeam;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RestartHandler {
    private final Main plugin;
    private long time;
    private long delay;
    private int taskID;
    private int fwID;

    public RestartHandler(Main plugin, long delay) {
        this.plugin = plugin;
        this.delay = delay;
    }

    public void start(long gameTime, final Color c) {
        for (Entity entity : this.plugin.getMapManager().getCurrentMap().getWorld().getEntities()) {
            if (entity.getType() != EntityType.IRON_GOLEM) continue;
            entity.remove();
        }
        this.time = this.delay;
        final String totalTime = PhaseManager.timeString(gameTime);
        this.taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (RestartHandler.this.time <= 0L) {
                    RestartHandler.this.stop();
                    return;
                }
                String msg = RestartHandler.this.plugin.getConfig().getString("ActionRestart").replace("&", "\u00a7").replace("%TOTAL%", totalTime).replace("%RESTART%", String.valueOf(RestartHandler.this.time));
                float percent = (float)RestartHandler.this.time / (float)RestartHandler.this.delay;
                for (Player p : Bukkit.getOnlinePlayers()) {
                    ActionAPI.sendPlayerAnnouncement(p, msg);
                }
                RestartHandler restartHandler = RestartHandler.this;
                restartHandler.time = restartHandler.time - 1L;
            }
        }, 0L, 20L);
        this.fwID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                GameTeam[] gameTeamArray = GameTeam.values();
                int n = gameTeamArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GameTeam gt = gameTeamArray[n2];
                    if (gt != GameTeam.NONE) {
                        for (Location l : gt.getSpawns()) {
                            Util.spawnFirework(l, c, c);
                        }
                    }
                    ++n2;
                }
            }
        }, 0L, 40L);
    }

    private void stop() {
        Bukkit.getScheduler().cancelTask(this.taskID);
        Bukkit.getScheduler().cancelTask(this.fwID);
        if (this.plugin.runCommand) {
            for (String c : this.plugin.commands) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)c);
            }
        } else {
            this.plugin.reset();
        }
    }
}

