/*
 * Decompiled with CFR 0.152.
 */
package cz.Vanda.anni.manager;

import cz.Vanda.anni.Main;
import cz.Vanda.anni.Util;
import cz.Vanda.anni.bar.ActionAPI;
import cz.Vanda.anni.chat.ChatUtil;
import cz.Vanda.anni.object.GameTeam;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class PhaseManager {
    private long time;
    private long startTime;
    private long phaseTime;
    private int phase;
    private boolean isRunning;
    private final Main plugin;
    private int taskID;

    public PhaseManager(Main plugin, int start, int period) {
        this.plugin = plugin;
        this.startTime = start;
        this.phaseTime = period;
        this.phase = 0;
    }

    public void start() {
        if (!this.isRunning) {
            BukkitScheduler scheduler = this.plugin.getServer().getScheduler();
            this.taskID = scheduler.scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    PhaseManager.this.onSecond();
                }
            }, 20L, 20L);
            this.isRunning = true;
        }
        this.time = -this.startTime;
        for (Player p : Bukkit.getOnlinePlayers()) {
            ActionAPI.sendAnnouncement(p, ChatColor.GREEN + "Starting in: " + -this.time);
        }
        this.plugin.getSignHandler().updateSigns(GameTeam.RED);
        this.plugin.getSignHandler().updateSigns(GameTeam.BLUE);
        this.plugin.getSignHandler().updateSigns(GameTeam.GREEN);
        this.plugin.getSignHandler().updateSigns(GameTeam.YELLOW);
    }

    public void stop() {
        if (this.isRunning) {
            this.isRunning = false;
            Bukkit.getServer().getScheduler().cancelTask(this.taskID);
        }
    }

    public void reset() {
        this.stop();
        this.time = -this.startTime;
        this.phase = 0;
    }

    public long getTime() {
        return this.time;
    }

    public long getRemainingPhaseTime() {
        if (this.phase == 5) {
            return this.phaseTime;
        }
        if (this.phase >= 1) {
            return this.time % this.phaseTime;
        }
        return -this.time;
    }

    public int getPhase() {
        return this.phase;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void onSecond() {
        String text;
        ++this.time;
        if (this.getRemainingPhaseTime() == 0L) {
            ++this.phase;
            this.plugin.advancePhase();
        }
        if (this.phase == 0) {
            text = ChatColor.GREEN + "Starting in: " + -this.time;
        } else {
            text = String.valueOf(Util.getPhaseColor(this.phase)) + "Phase " + ChatUtil.translateRoman(this.phase) + " - " + PhaseManager.timeString(this.time);
            this.plugin.getSignHandler().updateSigns(GameTeam.RED);
            this.plugin.getSignHandler().updateSigns(GameTeam.BLUE);
            this.plugin.getSignHandler().updateSigns(GameTeam.GREEN);
            this.plugin.getSignHandler().updateSigns(GameTeam.YELLOW);
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            ActionAPI.sendAnnouncement(p, text);
        }
        this.plugin.onSecond();
    }

    public static String timeString(long time) {
        long hours = time / 3600L;
        long minutes = (time - hours * 3600L) / 60L;
        long seconds = time - hours * 3600L - minutes * 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds).replace("-", "");
    }
}

