/*
 * Decompiled with CFR 0.152.
 */
package cz.Vanda.anni.manager;

import cz.Vanda.anni.Main;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DatabaseManager {
    private static final Logger logger = Bukkit.getLogger();
    protected boolean connected = false;
    private String driver;
    private String connectionString;
    private Main plugin;
    public Connection c = null;

    public DatabaseManager(String hostname, int port, String database, String username, String password, Main plugin) {
        this.driver = "com.mysql.jdbc.Driver";
        this.connectionString = "jdbc:mysql://" + hostname + ":" + port + "/" + database + "?user=" + username + "&password=" + password;
        this.plugin = plugin;
    }

    public DatabaseManager(Main plugin) {
        this.plugin = plugin;
    }

    public Connection open() {
        try {
            Class.forName(this.driver);
            this.c = DriverManager.getConnection(this.connectionString);
            return this.c;
        }
        catch (SQLException e) {
            System.out.println("Don't load database! because: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            System.out.println(String.valueOf(this.driver) + " not found!");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return this.c;
    }

    public Connection getConn() {
        return this.c;
    }

    public void close() {
        try {
            if (this.c != null) {
                this.c.close();
            }
        }
        catch (SQLException ex) {
            this.plugin.log(ex.getMessage(), Level.SEVERE);
        }
        this.c = null;
    }

    public boolean isConnected() {
        try {
            return this.c != null && !this.c.isClosed();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Result query(String query) {
        if (!this.isConnected()) {
            this.open();
        }
        return this.query(query, true);
    }

    public Result query(final String query, boolean retry) {
        if (!this.isConnected()) {
            this.open();
        }
        try {
            PreparedStatement statement;
            block8: {
                statement = null;
                try {
                    if (!this.isConnected()) {
                        this.open();
                    }
                    if ((statement = this.c.prepareStatement(query)).execute()) {
                        return new Result(statement, statement.getResultSet());
                    }
                }
                catch (SQLException e) {
                    String msg = e.getMessage();
                    logger.severe("Database query error: " + msg);
                    if (!retry || !msg.contains("_BUSY")) break block8;
                    logger.severe("Retrying query...");
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            DatabaseManager.this.query(query, false);
                        }
                    }, 20L);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException ex) {
            this.plugin.log(ex.getMessage(), Level.SEVERE);
        }
        return null;
    }

    protected Statements getStatement(String query) {
        String trimmedQuery = query.trim();
        if (trimmedQuery.substring(0, 6).equalsIgnoreCase("SELECT")) {
            return Statements.SELECT;
        }
        if (trimmedQuery.substring(0, 6).equalsIgnoreCase("INSERT")) {
            return Statements.INSERT;
        }
        if (trimmedQuery.substring(0, 6).equalsIgnoreCase("UPDATE")) {
            return Statements.UPDATE;
        }
        if (trimmedQuery.substring(0, 6).equalsIgnoreCase("DELETE")) {
            return Statements.DELETE;
        }
        if (trimmedQuery.substring(0, 6).equalsIgnoreCase("CREATE")) {
            return Statements.CREATE;
        }
        if (trimmedQuery.substring(0, 5).equalsIgnoreCase("ALTER")) {
            return Statements.ALTER;
        }
        if (trimmedQuery.substring(0, 4).equalsIgnoreCase("DROP")) {
            return Statements.DROP;
        }
        if (trimmedQuery.substring(0, 8).equalsIgnoreCase("TRUNCATE")) {
            return Statements.TRUNCATE;
        }
        if (trimmedQuery.substring(0, 6).equalsIgnoreCase("RENAME")) {
            return Statements.RENAME;
        }
        if (trimmedQuery.substring(0, 2).equalsIgnoreCase("DO")) {
            return Statements.DO;
        }
        if (trimmedQuery.substring(0, 7).equalsIgnoreCase("REPLACE")) {
            return Statements.REPLACE;
        }
        if (trimmedQuery.substring(0, 4).equalsIgnoreCase("LOAD")) {
            return Statements.LOAD;
        }
        if (trimmedQuery.substring(0, 7).equalsIgnoreCase("HANDLER")) {
            return Statements.HANDLER;
        }
        if (trimmedQuery.substring(0, 4).equalsIgnoreCase("CALL")) {
            return Statements.CALL;
        }
        return Statements.SELECT;
    }

    public class Result {
        private ResultSet resultSet;
        private Statement statement;

        public Result(Statement statement, ResultSet resultSet) {
            this.statement = statement;
            this.resultSet = resultSet;
        }

        public ResultSet getResultSet() {
            return this.resultSet;
        }

        public void close() {
            try {
                this.statement.close();
                this.resultSet.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    protected static enum Statements {
        SELECT,
        INSERT,
        UPDATE,
        DELETE,
        DO,
        REPLACE,
        LOAD,
        HANDLER,
        CALL,
        CREATE,
        ALTER,
        DROP,
        TRUNCATE,
        RENAME,
        START,
        COMMIT,
        ROLLBACK,
        SAVEPOINT,
        LOCK,
        UNLOCK,
        PREPARE,
        EXECUTE,
        DEALLOCATE,
        SET,
        SHOW,
        DESCRIBE,
        EXPLAIN,
        HELP,
        USE,
        ANALYZE,
        ATTACH,
        BEGIN,
        DETACH,
        END,
        INDEXED,
        ON,
        PRAGMA,
        REINDEX,
        RELEASE,
        VACUUM;

    }
}

