/*
 * Decompiled with CFR 0.152.
 */
package cz.Vanda.anni.manager;

import cz.Vanda.anni.Main;
import cz.Vanda.anni.Util;
import cz.Vanda.anni.object.Boss;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;

public class BossManager {
    public HashMap<String, Boss> bosses = new HashMap();
    public HashMap<String, Boss> bossNames = new HashMap();
    private Main plugin;

    public BossManager(Main instance) {
        this.plugin = instance;
    }

    public void loadBosses(HashMap<String, Boss> b) {
        this.bosses = b;
    }

    public void spawnBosses() {
        for (Boss b : this.bosses.values()) {
            this.spawn(b);
        }
    }

    public void spawn(Boss b) {
        Location spawn = b.getSpawn();
        if (spawn != null && spawn.getWorld() != null) {
            Bukkit.getWorld((String)spawn.getWorld().getName()).loadChunk(spawn.getChunk());
            IronGolem boss = (IronGolem)spawn.getWorld().spawnEntity(spawn, EntityType.IRON_GOLEM);
            boss.setMaxHealth((double)b.getHealth());
            boss.setHealth((double)b.getHealth());
            boss.setCanPickupItems(false);
            boss.setPlayerCreated(false);
            boss.setRemoveWhenFarAway(false);
            boss.setCustomNameVisible(true);
            boss.setCustomName(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(b.getBossName()) + " &8\u00c2\u00bb &a" + b.getHealth() + " HP")));
            this.bossNames.put(boss.getCustomName(), b);
            Util.spawnFirework(b.getSpawn());
            Util.spawnFirework(b.getSpawn());
            Util.spawnFirework(b.getSpawn());
        }
    }

    public void update(Boss boss, IronGolem g) {
        boss.setHealth((int)g.getHealth());
        g.setCustomName(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(boss.getBossName()) + " &8\u00c2\u00bb &a" + boss.getHealth() + " HP")));
        this.bossNames.put(g.getCustomName(), boss);
        this.bosses.put(boss.getConfigName(), boss);
    }

    public Boss newBoss(Boss b) {
        String boss = b.getConfigName();
        this.bosses.remove(boss);
        this.bossNames.remove(boss);
        YamlConfiguration config = this.plugin.getConfigManager().getConfig("maps.yml");
        ConfigurationSection section = config.getConfigurationSection(this.plugin.getMapManager().getCurrentMap().getName());
        ConfigurationSection sec = section.getConfigurationSection("bosses");
        Boss bb = new Boss(boss, sec.getInt(String.valueOf(boss) + ".hearts") * 2, sec.getString(String.valueOf(boss) + ".name"), Util.parseLocation(this.plugin.getMapManager().getCurrentMap().getWorld(), sec.getString(String.valueOf(boss) + ".spawn")), Util.parseLocation(this.plugin.getMapManager().getCurrentMap().getWorld(), sec.getString(String.valueOf(boss) + ".chest")));
        this.bosses.put(boss, bb);
        return bb;
    }
}

