/*
 * Decompiled with CFR 0.152.
 */
package cz.Vanda.anni.listeners;

import cz.Vanda.anni.Main;
import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockIterator;

public class WandListener
implements Listener {
    private final Main plugin;
    private static final String prefix = String.valueOf(ChatColor.YELLOW.toString()) + ChatColor.BOLD.toString();
    public static final String apprenticeName = String.valueOf(prefix) + "Apprentice Wand";
    public static final String masterName = String.valueOf(prefix) + "Master Wand";
    private static final int RANGE = 10;
    private static final double APPRENTICE_DAMAGE = 10.0;
    private static final int MASTER_FIRE_TICKS = 80;
    private static final long WAND_COOLDOWN = 5L;
    private final HashMap<String, Boolean> apprenticeCooldown = new HashMap();
    private final HashMap<String, Boolean> masterCooldown = new HashMap();

    public WandListener(Main plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onWandUse(PlayerInteractEvent e) {
        if (e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Player user = e.getPlayer();
            LivingEntity target = this.getTargetEntity(user);
            if (target == null) {
                return;
            }
            ItemStack item = user.getItemInHand();
            if (item == null) {
                return;
            }
            if (item.getType() == Material.BLAZE_ROD) {
                ItemMeta meta = item.getItemMeta();
                if (!meta.hasDisplayName()) {
                    return;
                }
                if (meta.getDisplayName().contains(apprenticeName)) {
                    this.useApprenticeWand(user, target);
                }
                if (meta.getDisplayName().contains(masterName)) {
                    this.useMasterWand(user, target);
                }
            }
        }
    }

    private LivingEntity getTargetEntity(Player player) {
        List nearby = player.getNearbyEntities(10.0, 10.0, 10.0);
        LivingEntity target = null;
        BlockIterator bit = new BlockIterator((LivingEntity)player, 10);
        while (bit.hasNext()) {
            Block b = bit.next();
            for (Entity e : nearby) {
                if (!(e instanceof LivingEntity) || !this.nearBlock(b, (LivingEntity)e)) continue;
                target = (LivingEntity)e;
            }
        }
        return target;
    }

    private boolean nearBlock(Block b, LivingEntity e) {
        Location bLoc = b.getLocation();
        Location eLoc = e.getLocation();
        double bx = bLoc.getX();
        double by = bLoc.getY();
        double bz = bLoc.getZ();
        double ex = eLoc.getX();
        double ey = eLoc.getY();
        double ez = eLoc.getZ();
        return Math.abs(bx - ex) < 0.5 && by - ey < e.getEyeHeight() && by - ey > -0.5 && Math.abs(bz - ez) < 0.5;
    }

    private void useApprenticeWand(Player user, LivingEntity target) {
        if (!this.apprenticeCooldown.containsKey(user.getName())) {
            this.apprenticeCooldown.put(user.getName(), false);
        }
        if (this.apprenticeCooldown.get(user.getName()).booleanValue()) {
            return;
        }
        target.damage(10.0, (Entity)user);
        target.getWorld().playEffect(target.getEyeLocation(), Effect.POTION_BREAK, 1, 1);
        final String name = user.getName();
        this.apprenticeCooldown.put(name, true);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                WandListener.this.apprenticeCooldown.put(name, false);
            }
        }, 100L);
    }

    private void useMasterWand(Player user, LivingEntity target) {
        if (!this.masterCooldown.containsKey(user.getName())) {
            this.masterCooldown.put(user.getName(), false);
        }
        if (this.masterCooldown.get(user.getName()).booleanValue()) {
            return;
        }
        target.setFireTicks(80);
        final String name = user.getName();
        this.masterCooldown.put(name, true);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                WandListener.this.masterCooldown.put(name, false);
            }
        }, 100L);
    }
}

