/*
 * Decompiled with CFR 0.152.
 */
package cz.Vanda.anni.listeners;

import cz.Vanda.anni.manager.SoundManager;
import java.util.Arrays;
import java.util.Iterator;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SoulboundListener
implements Listener {
    private static final String soulboundTag = ChatColor.GOLD + "Soulbound";

    @EventHandler
    public void onSoulboundDrop(PlayerDropItemEvent e) {
        if (SoulboundListener.isSoulbound(e.getItemDrop().getItemStack())) {
            Player p = e.getPlayer();
            SoundManager.playSoundForPlayer(p, Sound.BLAZE_HIT, 1.0f, 0.25f, 0.5f);
            e.getItemDrop().remove();
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        Iterator it = e.getDrops().iterator();
        while (it.hasNext()) {
            if (!SoulboundListener.isSoulbound((ItemStack)it.next())) continue;
            it.remove();
        }
    }

    public static boolean isSoulbound(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        return item.hasItemMeta() && meta.hasLore() && meta.getLore().contains(soulboundTag);
    }

    public static void soulbind(ItemStack stack) {
        ItemMeta meta = stack.getItemMeta();
        if (!meta.hasLore()) {
            meta.setLore(Arrays.asList(soulboundTag));
        } else {
            meta.getLore().add(soulboundTag);
        }
        stack.setItemMeta(meta);
    }
}

