/*
 * Decompiled with CFR 0.152.
 */
package cz.Vanda.anni.listeners;

import cz.Vanda.anni.Main;
import cz.Vanda.anni.Util;
import cz.Vanda.anni.api.NexusDamageEvent;
import cz.Vanda.anni.api.NexusDestroyEvent;
import cz.Vanda.anni.bar.TitleAPI;
import cz.Vanda.anni.chat.ChatUtil;
import cz.Vanda.anni.manager.PhaseManager;
import cz.Vanda.anni.object.GameTeam;
import cz.Vanda.anni.object.Kit;
import cz.Vanda.anni.object.PlayerMeta;
import cz.Vanda.anni.stats.StatType;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.PacketPlayInClientCommand;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class PlayerListener
implements Listener {
    private final Main plugin;
    private final HashMap<String, Kit> kitsToGive = new HashMap();

    public PlayerListener(Main plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onMOTDPing(ServerListPingEvent e) {
        if (this.plugin.motd) {
            String motd = this.plugin.getConfig().getString("motdPhase").replaceAll("%PHASE%", ChatUtil.translateRoman(this.plugin.getPhase()));
            try {
                if (this.plugin.getPhase() == 0) {
                    e.setMotd(this.plugin.getConfig().getString("motdLobby").replace("&", "\u00a7"));
                } else {
                    this.plugin.getPhaseManager();
                    motd = motd.replaceAll("%TIME%", PhaseManager.timeString(this.plugin.getPhaseManager().getTime()));
                    motd = motd.replaceAll("%PLAYERCOUNT%", String.valueOf(Bukkit.getOnlinePlayers().size()));
                    motd = motd.replaceAll("%MAXPLAYERS%", String.valueOf(Bukkit.getMaxPlayers()));
                    motd = motd.replaceAll("%GREENNEXUS%", String.valueOf(this.getNexus(GameTeam.GREEN)));
                    motd = motd.replaceAll("%GREENCOUNT%", String.valueOf(this.getPlayers(GameTeam.GREEN)));
                    motd = motd.replaceAll("%REDNEXUS%", String.valueOf(this.getNexus(GameTeam.RED)));
                    motd = motd.replaceAll("%REDCOUNT%", String.valueOf(this.getPlayers(GameTeam.GREEN)));
                    motd = motd.replaceAll("%BLUENEXUS%", String.valueOf(this.getNexus(GameTeam.BLUE)));
                    motd = motd.replaceAll("%BLUECOUNT%", String.valueOf(this.getPlayers(GameTeam.GREEN)));
                    motd = motd.replaceAll("%YELLOWNEXUS%", String.valueOf(this.getNexus(GameTeam.YELLOW)));
                    motd = motd.replaceAll("%YELLOWCOUNT%", String.valueOf(this.getPlayers(GameTeam.GREEN)));
                    e.setMotd(ChatColor.translateAlternateColorCodes((char)'&', (String)motd));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int getNexus(GameTeam t) {
        int health = 0;
        if (t.getNexus() != null) {
            health = t.getNexus().getHealth();
        }
        return health;
    }

    private int getPlayers(GameTeam t) {
        int size = 0;
        for (Player p : Bukkit.getOnlinePlayers()) {
            PlayerMeta meta = PlayerMeta.getMeta(p);
            if (meta.getTeam() != t) continue;
            ++size;
        }
        return size;
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        String teamName;
        GameTeam team;
        Sign s;
        Material clickedType;
        ItemStack handItem;
        Player player = e.getPlayer();
        PlayerMeta pmeta = PlayerMeta.getMeta(player);
        Action a = e.getAction();
        if ((a == Action.RIGHT_CLICK_AIR || a == Action.RIGHT_CLICK_BLOCK) && (handItem = player.getItemInHand()) != null) {
            int id = this.plugin.getConfig().getInt("ItemClassID");
            if (handItem.getType() == Material.getMaterial((int)id) && handItem.getItemMeta().hasDisplayName()) {
                String item = this.plugin.getConfig().getString("JoinItemClassName").replace("&", "\u00a7");
                if (handItem.getItemMeta().getDisplayName().contains(item)) {
                    String namei = this.plugin.getConfig().getString("TitleClassMenu").replace("&", "\u00a7");
                    Util.showClassSelector(e.getPlayer(), namei);
                    return;
                }
            }
            if (handItem.getType() == Material.COMPASS) {
                boolean setCompass = false;
                boolean setToNext = false;
                block0: while (!setCompass) {
                    GameTeam[] gameTeamArray = GameTeam.teams();
                    int n = gameTeamArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GameTeam team2 = gameTeamArray[n2];
                        if (setToNext) {
                            ItemMeta meta = handItem.getItemMeta();
                            String kompas = this.plugin.getConfig().getString("CompassItem").replace("&", "\u00a7").replace("%TEAM%", String.valueOf(team2.toString())).replaceAll("%COLOR%", String.valueOf(team2.color()));
                            meta.setDisplayName(kompas);
                            handItem.setItemMeta(meta);
                            player.setCompassTarget(team2.getNexus().getLocation());
                            setCompass = true;
                            continue block0;
                        }
                        if (handItem.getItemMeta().getDisplayName().contains(team2.toString())) {
                            setToNext = true;
                        }
                        ++n2;
                    }
                }
            }
        }
        if (e.getClickedBlock() != null && ((clickedType = e.getClickedBlock().getType()) == Material.SIGN_POST || clickedType == Material.WALL_SIGN) && (s = (Sign)e.getClickedBlock().getState()).getLine(0).contains(ChatColor.DARK_PURPLE + "[Team]") && (team = GameTeam.valueOf((teamName = ChatColor.stripColor((String)s.getLine(1))).toUpperCase())) != null && pmeta.getTeam() == GameTeam.NONE) {
            this.plugin.joinTeam(e.getPlayer(), teamName);
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        Player p = e.getPlayer();
        if (p.getWorld().getName().contains("lobby")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteractTeam(PlayerInteractEvent e) {
        ItemStack handItem;
        Player player = e.getPlayer();
        Action a = e.getAction();
        if ((a == Action.RIGHT_CLICK_AIR || a == Action.RIGHT_CLICK_BLOCK) && (handItem = player.getItemInHand()) != null) {
            int id = this.plugin.getConfig().getInt("ItemTeamID");
            if (handItem.getType() == Material.getMaterial((int)id) && handItem.getItemMeta().hasDisplayName()) {
                String item = this.plugin.getConfig().getString("JoinItemTeamName").replace("&", "\u00a7");
                if (handItem.getItemMeta().getDisplayName().contains(item)) {
                    // empty if block
                }
                this.plugin.Team(player);
            }
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent e) {
        Player player = e.getPlayer();
        PlayerMeta meta = PlayerMeta.getMeta(player);
        if (meta.isAlive()) {
            if (this.kitsToGive.containsKey(e.getPlayer().getName())) {
                meta.setKit(this.kitsToGive.get(e.getPlayer().getName()));
                this.kitsToGive.remove(e.getPlayer().getName());
            }
            e.setRespawnLocation(meta.getTeam().getRandomSpawn());
            meta.getKit().give(player, meta.getTeam());
        } else {
            int id = this.plugin.getConfig().getInt("ItemClassID");
            e.setRespawnLocation(this.plugin.getMapManager().getLobbySpawnPoint());
            ItemStack selector = new ItemStack(Material.getMaterial((int)id));
            ItemMeta itemMeta = selector.getItemMeta();
            String item = this.plugin.getConfig().getString("JoinItemClassName").replace("&", "\u00a7");
            itemMeta.setDisplayName(item);
            selector.setItemMeta(itemMeta);
            int slot = this.plugin.getConfig().getInt("JoinItemClassSlot");
            player.getInventory().setItem(slot - 1, selector);
        }
    }

    @EventHandler
    public void onKick(PlayerKickEvent e) {
        if (e.getReason().equals(ChatColor.RED + "ANNIHILATION-TRIGGER-KICK-01")) {
            e.setReason(ChatColor.RED + "You can't join to this phase!");
            e.setLeaveMessage(null);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        String prefix = this.plugin.getConfig().getString("prefix").replace("&", "\u00a7");
        String msg = this.plugin.getConfig().getString("JoinTitle").replace("&", "\u00a7");
        String msg1 = this.plugin.getConfig().getString("JoinSubTitle").replace("&", "\u00a7");
        final Player player = e.getPlayer();
        this.plugin.getPhaseManager();
        player.setGameMode(GameMode.SURVIVAL);
        String msg2 = this.plugin.getConfig().getString("Footer").replace("&", "\u00a7").replaceAll(this.plugin.getPhase() == 0 ? this.plugin.getConfig().getString("motdLobby") : "%PHASE%", ChatUtil.translateRoman(this.plugin.getPhase())).replaceAll("%TIME%", PhaseManager.timeString(this.plugin.getPhaseManager().getTime()));
        e.setJoinMessage("");
        PlayerMeta meta = PlayerMeta.getMeta(player);
        if (Main.getInstance().getConfig().getBoolean("EnableTab")) {
            TitleAPI.sendTabTitle(player, String.valueOf(this.plugin.getMapManager().getCurrentMap() == null ? this.plugin.getConfig().getString("Voting") : this.plugin.getConfig().getString("Header").replaceAll("%MAP%", WordUtils.capitalize((String)Main.voting.getWinner()))), String.valueOf(this.plugin.getPhase() == 0 ? this.plugin.getConfig().getString("motdLobby") : msg2));
        }
        player.sendMessage(String.valueOf(prefix) + " \u00a77Welcome in Annihilation!");
        if (this.plugin.getPhase() > this.plugin.lastJoinPhase && !player.hasPermission("anni.bypass.phaselimiter")) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    player.kickPlayer(ChatColor.RED + "ANNIHILATION-TRIGGER-KICK-01");
                }
            }, 1L);
            e.setJoinMessage("");
            return;
        }
        if (Main.getInstance().getConfig().getBoolean("EnableJoinTitle")) {
            TitleAPI.sendTitle(player, 20, 50, 20, msg, msg1);
        }
        if (meta.isAlive()) {
            player.teleport(meta.getTeam().getRandomSpawn());
        } else {
            player.setGameMode(GameMode.ADVENTURE);
            player.teleport(this.plugin.getMapManager().getLobbySpawnPoint());
            PlayerInventory inv = player.getInventory();
            inv.setHelmet(null);
            inv.setChestplate(null);
            inv.setLeggings(null);
            inv.setBoots(null);
            player.setHealth(20.0);
            player.setFoodLevel(20);
            player.getInventory().clear();
            for (PotionEffect effect : player.getActivePotionEffects()) {
                player.removePotionEffect(effect.getType());
            }
            player.setLevel(0);
            player.setExp(0.0f);
            player.setSaturation(20.0f);
            int id = this.plugin.getConfig().getInt("ItemClassID");
            ItemStack selector = new ItemStack(Material.getMaterial((int)id));
            ItemMeta itemMeta = selector.getItemMeta();
            String item = this.plugin.getConfig().getString("JoinItemClassName").replace("&", "\u00a7");
            itemMeta.setDisplayName(item);
            Util.giveTeamSelector(player);
            selector.setItemMeta(itemMeta);
            int slot = this.plugin.getConfig().getInt("JoinItemClassSlot");
            player.getInventory().setItem(slot - 1, selector);
            player.updateInventory();
        }
        if (this.plugin.useMysql) {
            this.plugin.getDatabaseHandler().query("INSERT IGNORE INTO `annihilation` (`username`, `kills`, `deaths`, `wins`, `losses`, `nexus_damage`) VALUES ('" + player.getName() + "', '0', '0', '0', '0', '0');");
        }
        if (this.plugin.getPhase() == 0 && this.plugin.getVotingManager().isRunning()) {
            this.plugin.checkStarting();
        }
        this.plugin.getSignHandler().updateSigns(meta.getTeam());
        this.plugin.getScoreboardHandler().update();
    }

    @EventHandler
    public void leaveRemoveGameTeam(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        PlayerMeta meta = PlayerMeta.getMeta(player);
        if (event.getPlayer().getWorld().getName().equals("lobby")) {
            if (meta.isAlive()) {
                meta.setAlive(false);
            }
            meta.setTeam(GameTeam.NONE);
            this.plugin.getSignHandler().updateSigns(meta.getTeam());
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        PlayerMeta meta;
        final Player p = e.getEntity();
        if (this.plugin.getPhase() > 0 && !(meta = PlayerMeta.getMeta(p)).getTeam().getNexus().isAlive()) {
            meta.setAlive(false);
            for (Player pp : Bukkit.getOnlinePlayers()) {
                pp.hidePlayer(p);
            }
        }
        this.plugin.getStatsManager().setValue(StatType.DEATHS, p, this.plugin.getStatsManager().getStat(StatType.DEATHS, p) + 1);
        if (p.getKiller() != null && !p.getKiller().equals(p)) {
            Player killer = p.getKiller();
            this.plugin.getStatsManager().incrementStat(StatType.KILLS, killer);
            e.setDeathMessage(ChatUtil.formatDeathMessage(p, p.getKiller(), e.getDeathMessage()));
            if (PlayerMeta.getMeta(killer).getKit() == Kit.BERSERKER) {
                this.addHeart(killer);
            }
        } else {
            e.setDeathMessage(ChatUtil.formatDeathMessage(p, e.getDeathMessage()));
        }
        if (p.getKiller() instanceof Player) {
            p.getKiller().giveExpLevels(this.plugin.getConfig().getInt("KillXP"));
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                PacketPlayInClientCommand in = new PacketPlayInClientCommand(PacketPlayInClientCommand.EnumClientCommand.PERFORM_RESPAWN);
                EntityPlayer cPlayer = ((CraftPlayer)p).getHandle();
                cPlayer.playerConnection.a(in);
            }
        }, 1L);
    }

    @EventHandler
    public void onPlayerPortal(PlayerPortalEvent e) {
        final Player player = e.getPlayer();
        PlayerMeta meta = PlayerMeta.getMeta(player);
        final String namei = this.plugin.getConfig().getString("TitleClassMenu").replace("&", "\u00a7");
        player.teleport(meta.getTeam().getRandomSpawn());
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Util.showClassSelector(player, namei);
            }
        }, 20L);
        if (!this.plugin.getPortalPlayers().containsKey(player)) {
            this.plugin.getPortalPlayers().put(player, player.getName());
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player && e.getEntity().getWorld().getName().equals("lobby")) {
            e.setCancelled(true);
            if (e.getCause() == EntityDamageEvent.DamageCause.VOID) {
                e.getEntity().teleport(this.plugin.getMapManager().getLobbySpawnPoint());
            }
        }
    }

    @EventHandler
    public void onPlayerAttack(EntityDamageByEntityEvent e) {
        Entity damager = e.getDamager();
        if (damager instanceof Player) {
            String lowercaseName;
            ItemStack hand;
            if (damager.getWorld().getName().equals("lobby")) {
                e.setCancelled(true);
                return;
            }
            if (this.plugin.getPhase() < 1) {
                e.setCancelled(true);
                return;
            }
            Player attacker = (Player)damager;
            if (PlayerMeta.getMeta(attacker).getKit() == Kit.WARRIOR && (hand = attacker.getItemInHand()) != null && ((lowercaseName = hand.getType().toString().toLowerCase()).contains("sword") || lowercaseName.contains("axe"))) {
                e.setDamage(e.getDamage() + 1.0);
            }
        }
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent e) {
        String prefix = this.plugin.getConfig().getString("prefix").replace("&", "\u00a7");
        if (this.plugin.getPhase() > 0) {
            if (Util.isEmptyColumn(e.getBlock().getLocation())) {
                e.setCancelled(true);
            }
            if (this.tooClose(e.getBlock().getLocation()) && !e.getPlayer().hasPermission("anni.buildbypass")) {
                e.getPlayer().sendMessage(String.valueOf(prefix) + " \u00a7cYou don't build near to nexus!");
                e.setCancelled(true);
            }
        } else if (!e.getPlayer().hasPermission("anni.buildbypass")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onSignPlace(SignChangeEvent e) {
        if (e.getPlayer().hasPermission("anni.buildbypass") && e.getLine(0).toLowerCase().contains("[Shop]".toLowerCase())) {
            e.setLine(0, ChatColor.DARK_PURPLE + "[Shop]");
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBreak(BlockBreakEvent e) {
        String prefix = this.plugin.getConfig().getString("prefix").replace("&", "\u00a7");
        if (this.plugin.getPhase() > 0) {
            GameTeam[] gameTeamArray = GameTeam.teams();
            int n = gameTeamArray.length;
            int n2 = 0;
            while (n2 < n) {
                GameTeam t = gameTeamArray[n2];
                if (t.getNexus().getLocation().equals((Object)e.getBlock().getLocation())) {
                    e.setCancelled(true);
                    if (t.getNexus().isAlive()) {
                        this.breakNexus(t, e.getPlayer());
                    }
                    return;
                }
                ++n2;
            }
            if (this.tooClose(e.getBlock().getLocation()) && !e.getPlayer().hasPermission("anni.buildbypass") && e.getBlock().getType() != Material.ENDER_STONE) {
                e.getPlayer().sendMessage(String.valueOf(prefix) + " \u00a77You don't deytroing block near the nexus!");
                e.setCancelled(true);
            }
        } else if (!e.getPlayer().hasPermission("anni.buildbypass")) {
            e.setCancelled(true);
        }
    }

    private boolean tooClose(Location loc) {
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        GameTeam[] gameTeamArray = GameTeam.teams();
        int n = gameTeamArray.length;
        int n2 = 0;
        while (n2 < n) {
            GameTeam team = gameTeamArray[n2];
            Location nexusLoc = team.getNexus().getLocation();
            double nX = nexusLoc.getX();
            double nY = nexusLoc.getY();
            double nZ = nexusLoc.getZ();
            if (Math.abs(nX - x) <= (double)this.plugin.build && Math.abs(nY - y) <= (double)this.plugin.build && Math.abs(nZ - z) <= (double)this.plugin.build) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void addHeart(Player player) {
        double maxHealth = player.getMaxHealth();
        if (maxHealth < 30.0) {
            double newMaxHealth = maxHealth + 2.0;
            player.setMaxHealth(newMaxHealth);
            player.setHealth(player.getHealth() + 2.0);
        }
    }

    private void breakNexus(final GameTeam victim, Player breaker) {
        String prefix = this.plugin.getConfig().getString("prefix").replace("&", "\u00a7");
        final GameTeam attacker = PlayerMeta.getMeta(breaker).getTeam();
        if (victim == attacker) {
            breaker.sendMessage(String.valueOf(prefix) + " \u00a7cYou can't destroy you nexus!");
        } else if (this.plugin.getPhase() == 1) {
            breaker.sendMessage(String.valueOf(prefix) + " \u00a7cYou can't destroy nexus in phase I.  !");
        } else {
            this.plugin.getScoreboardHandler().sb.getTeam(String.valueOf(victim.name()) + "SB").setPrefix(ChatColor.RESET.toString());
            victim.getNexus().damage(this.plugin.getPhase() == 5 ? 2 : 1);
            this.plugin.getStatsManager().incrementStat(StatType.NEXUS_DAMAGE, breaker, this.plugin.getPhase() == 5 ? 2 : 1);
            String msg = ChatUtil.nexusBreakMessage(breaker, attacker, victim);
            for (Player p : attacker.getPlayers()) {
                p.sendMessage(msg);
            }
            this.plugin.getScoreboardHandler().scores.get(victim.name()).setScore(victim.getNexus().getHealth());
            Bukkit.getServer().getPluginManager().callEvent((Event)new NexusDamageEvent(breaker, victim, victim.getNexus().getHealth()));
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    ((PlayerListener)PlayerListener.this).plugin.getScoreboardHandler().sb.getTeam(String.valueOf(victim.name()) + "SB").setPrefix(victim.color().toString());
                }
            }, 2L);
            Random r = new Random();
            float pitch = 0.5f + r.nextFloat() * 0.5f;
            victim.getNexus().getLocation().getWorld().playSound(victim.getNexus().getLocation(), Sound.ANVIL_BREAK, 1.0f, pitch);
        }
        if (this.plugin.getPhase() > 1) {
            Random s = new Random();
            float pitch = 5.0f + s.nextFloat() * 2.0f;
            Location nexus = victim.getNexus().getLocation().clone();
            Util.ParticleEffect.FLAME.display(pitch, pitch, pitch, pitch, 10, nexus, pitch);
            Util.ParticleEffect.ENCHANTMENT_TABLE.display(pitch, pitch, pitch, pitch, 10, nexus, pitch);
            if (victim.getNexus().getHealth() == 0) {
                this.plugin.getScoreboardHandler().sb.resetScores(this.plugin.getScoreboardHandler().scores.remove(victim.name()).getPlayer());
                Bukkit.getServer().getPluginManager().callEvent((Event)new NexusDestroyEvent(breaker, victim));
                ChatUtil.nexusDestroyed(attacker, victim, breaker);
                this.plugin.checkWin();
                for (Player p : victim.getPlayers()) {
                    this.plugin.getStatsManager().incrementStat(StatType.LOSSES, p);
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    Util.ParticleEffect.EXPLOSION_NORMAL.display(pitch, pitch, pitch, pitch, 1, nexus, 2.0);
                    player.getWorld().playSound(player.getLocation(), Sound.EXPLODE, 2.0f, 1.25f);
                }
                for (final Location spawn : victim.getSpawns()) {
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            Util.spawnFirework(spawn, attacker.getColor(attacker), attacker.getColor(attacker));
                        }
                    }, (long)new Random().nextInt(20));
                }
                Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        Location nexus = victim.getNexus().getLocation().clone();
                        boolean found = false;
                        int y = 0;
                        while (!found) {
                            ++y;
                            Block b = nexus.add(0.0, 1.0, 0.0).getBlock();
                            if (b != null && b.getType() == Material.BEACON) {
                                b.setType(Material.AIR);
                            }
                            if (y <= 10) continue;
                            found = true;
                        }
                    }
                });
            }
            this.plugin.getSignHandler().updateSigns(victim);
        }
    }

    @EventHandler
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        if (event.getEntity().getWorld().getName().equals("lobby")) {
            event.setCancelled(true);
            event.setFoodLevel(20);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        String prefix = this.plugin.getConfig().getString("prefix").replace("&", "\u00a7");
        String msg1 = String.valueOf(prefix) + " \u00a77Selected class \u00a7r";
        String msg2 = String.valueOf(prefix) + " \u00a77This class you get after respawn!";
        Inventory inv = e.getInventory();
        Player player = (Player)e.getWhoClicked();
        String namei = this.plugin.getConfig().getString("TitleClassMenu").replace("&", "\u00a7");
        if (inv.getTitle().startsWith(namei)) {
            if (e.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            player.closeInventory();
            e.setCancelled(true);
            String name = e.getCurrentItem().getItemMeta().getDisplayName();
            PlayerMeta meta = PlayerMeta.getMeta(player);
            if (!Kit.valueOf(ChatColor.stripColor((String)name).toUpperCase()).isOwnedBy(player)) {
                player.sendMessage(String.valueOf(prefix) + ChatColor.RED + " You're not allowed to this");
                return;
            }
            String msgT = this.plugin.getConfig().getString("ClassTitleSelect").replace("&", "\u00a7").replace("%CLASS%", name);
            String msgST = this.plugin.getConfig().getString("ClassSubTitleSelect").replace("&", "\u00a7").replace("%CLASS%", name);
            player.sendMessage(String.valueOf(msg1) + "\u00a7b" + name);
            TitleAPI.sendTitle(player, 20, 50, 20, msgT, msgST);
            player.sendMessage(msg2);
            meta.setKit(Kit.getKit(ChatColor.stripColor((String)name)));
            if (Main.getInstance().getConfig().getBoolean("EnableClassTitle")) {
                TitleAPI.sendTitle(player, 20, 50, 20, msgT, msgST);
            }
            if (this.plugin.getPortalPlayers().containsKey(player)) {
                this.plugin.getPortalPlayers().remove(player);
                player.setHealth(0.0);
            }
        }
    }
}

