/*
 * Decompiled with CFR 0.152.
 */
package cz.Vanda.anni.listeners;

import cz.Vanda.anni.Main;
import cz.Vanda.anni.object.GameTeam;
import cz.Vanda.anni.object.PlayerMeta;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;

public class EnderChestListener
implements Listener {
    private HashMap<GameTeam, Location> enderchests = new HashMap();
    private HashMap<String, Inventory> inventories = new HashMap();

    @EventHandler
    public void onChestOpen(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block b = e.getClickedBlock();
        if (b.getType() != Material.ENDER_CHEST) {
            return;
        }
        Location loc = b.getLocation();
        Player player = e.getPlayer();
        GameTeam team = PlayerMeta.getMeta(player).getTeam();
        if (team == null || !this.enderchests.containsKey((Object)team)) {
            return;
        }
        if (this.enderchests.get((Object)team).equals((Object)loc)) {
            e.setCancelled(true);
            this.openEnderChest(player);
        } else if (this.enderchests.containsValue(loc)) {
            e.setCancelled(true);
        }
    }

    public void setEnderChestLocation(GameTeam team, Location loc) {
        this.enderchests.put(team, loc);
    }

    private void openEnderChest(Player player) {
        GameTeam team = PlayerMeta.getMeta(player).getTeam();
        String name = player.getName();
        if (!this.inventories.containsKey(name)) {
            Inventory inv = Bukkit.createInventory(null, (int)18, (String)(team.color() + "\u00a7a" + name));
            this.inventories.put(name, inv);
        }
        player.openInventory(this.inventories.get(name));
        player.sendMessage(String.valueOf(Main.getInstance().getConfig().getString("prefix").replace("&", "\u00a7")) + " \u00a77This ender chest protect youre item's. :)");
    }

    @EventHandler
    public void onEnderChestBreak(BlockBreakEvent e) {
        if (this.enderchests.values().contains(e.getBlock().getLocation())) {
            e.setCancelled(true);
        }
    }
}

