/*
 * Decompiled with CFR 0.152.
 */
package cz.Vanda.anni.listeners;

import cz.Vanda.anni.object.Kit;
import cz.Vanda.anni.object.PlayerMeta;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;

public class CraftingListener
implements Listener {
    private ShapedRecipe arrowRecipe = new ShapedRecipe(new ItemStack(Material.ARROW, 3));

    public CraftingListener() {
        this.arrowRecipe.shape(new String[]{"F", "S"});
        this.arrowRecipe.setIngredient('F', Material.FLINT);
        this.arrowRecipe.setIngredient('S', Material.STICK);
        Bukkit.addRecipe((Recipe)this.arrowRecipe);
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent e) {
        Player player = (Player)e.getView().getPlayer();
        if (e.getRecipe() instanceof ShapedRecipe) {
            ShapedRecipe recipe = (ShapedRecipe)e.getRecipe();
            if (PlayerMeta.getMeta(player).getKit() != Kit.ARCHER && this.sameRecipe(recipe, this.arrowRecipe)) {
                e.getInventory().setResult(null);
            }
        }
    }

    @EventHandler
    public void onCraft(CraftItemEvent e) {
        Player player = (Player)e.getWhoClicked();
        if (e.getRecipe() instanceof ShapedRecipe) {
            ShapedRecipe recipe = (ShapedRecipe)e.getRecipe();
            if (PlayerMeta.getMeta(player).getKit() != Kit.ARCHER && this.sameRecipe(recipe, this.arrowRecipe)) {
                e.setCancelled(true);
            }
        }
    }

    private boolean sameRecipe(ShapedRecipe r1, ShapedRecipe r2) {
        if (r1 == r2) {
            return true;
        }
        if (r1 == null || r2 == null) {
            return false;
        }
        if (!r1.getResult().equals((Object)r2.getResult())) {
            return false;
        }
        return Arrays.equals(r1.getShape(), r2.getShape());
    }
}

