/*
 * Decompiled with CFR 0.152.
 */
package cz.Vanda.anni.listeners;

import cz.Vanda.anni.Main;
import cz.Vanda.anni.Util;
import cz.Vanda.anni.bar.TitleAPI;
import cz.Vanda.anni.chat.ChatUtil;
import cz.Vanda.anni.object.Boss;
import cz.Vanda.anni.object.PlayerMeta;
import org.bukkit.Bukkit;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;

public class BossListener
implements Listener {
    private Main plugin;

    public BossListener(Main instance) {
        this.plugin = instance;
    }

    @EventHandler
    public void onHit(EntityDamageEvent event) {
        if (event.getEntity() instanceof IronGolem) {
            IronGolem g = (IronGolem)event.getEntity();
            if (g.getCustomName() == null) {
                return;
            }
            final Boss b = this.plugin.getBossManager().bossNames.get(g.getCustomName());
            if (b == null) {
                return;
            }
            if (event.getCause() == EntityDamageEvent.DamageCause.VOID) {
                event.getEntity().remove();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        Boss n = BossListener.this.plugin.getBossManager().newBoss(b);
                        BossListener.this.plugin.getBossManager().spawn(n);
                    }
                });
            }
        }
    }

    @EventHandler
    public void onHit(EntityDamageByEntityEvent event) {
        if (event.getEntity() instanceof IronGolem) {
            IronGolem g;
            if (!(event.getDamager() instanceof Player)) {
                event.setCancelled(true);
            }
            if ((g = (IronGolem)event.getEntity()).getCustomName() == null) {
                return;
            }
            final Boss b = this.plugin.getBossManager().bossNames.get(g.getCustomName());
            if (b == null) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    BossListener.this.plugin.getBossManager().update(b, g);
                }
            });
        }
    }

    @EventHandler
    public void onDeath(EntityDeathEvent event) {
        if (event.getEntity() instanceof IronGolem) {
            IronGolem g = (IronGolem)event.getEntity();
            if (g.getCustomName() == null) {
                return;
            }
            Boss b = this.plugin.getBossManager().bossNames.get(g.getCustomName());
            if (b == null) {
                return;
            }
            event.getDrops().clear();
            b.spawnLootChest();
            if (g.getKiller() != null) {
                Player killer = g.getKiller();
                ChatUtil.bossDeath(b, killer, PlayerMeta.getMeta(killer).getTeam());
                this.respawn(b);
                killer.giveExpLevels(this.plugin.getConfig().getInt("KillBossXP"));
                Util.spawnFirework(event.getEntity().getLocation(), PlayerMeta.getMeta(killer).getTeam().getColor(PlayerMeta.getMeta(killer).getTeam()), PlayerMeta.getMeta(killer).getTeam().getColor(PlayerMeta.getMeta(killer).getTeam()));
            } else {
                g.teleport(b.getSpawn());
            }
        }
    }

    private void respawn(final Boss b) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Boss n = BossListener.this.plugin.getBossManager().newBoss(b);
                ChatUtil.bossRespawn(b);
                String title = BossListener.this.plugin.getConfig().getString("SpawnBossTitle").replace("&", "\u00a7").replace("%boss%", b.getBossName());
                String sub = BossListener.this.plugin.getConfig().getString("SpawnBossSubTitle").replace("&", "\u00a7").replace("%boss%", b.getBossName());
                if (Main.getInstance().getConfig().getBoolean("EnableBossTitle")) {
                    TitleAPI.AllTitle(title, sub);
                }
                BossListener.this.plugin.getBossManager().spawn(n);
            }
        }, (long)(20 * this.plugin.respawn * 60));
    }
}

