/*
 * Decompiled with CFR 0.152.
 */
package cz.Vanda.anni.chat;

import cz.Vanda.anni.Main;
import cz.Vanda.anni.Util;
import cz.Vanda.anni.VaultHooks;
import cz.Vanda.anni.bar.TitleAPI;
import cz.Vanda.anni.object.Boss;
import cz.Vanda.anni.object.GameTeam;
import cz.Vanda.anni.object.PlayerMeta;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class ChatUtil {
    private static final String RESET = ChatColor.RESET.toString();
    private static boolean roman = false;

    public static void setRoman(boolean b) {
        roman = b;
    }

    public static void allMessage(GameTeam team, Player sender, String message, boolean dead) {
        String username;
        String group1;
        if (team == GameTeam.NONE) {
            group1 = Main.getInstance().getConfig().getString("LobbyChat").replace("&", "\u00a7");
            username = String.valueOf(RESET) + sender.getName();
        } else {
            group1 = Main.getInstance().getConfig().getString("AllChat").replace("&", "\u00a7").replace("%color%", String.valueOf(team.color()));
            username = team.color() + sender.getName();
            if (dead) {
                group1 = String.valueOf(Main.getInstance().getConfig().getString("DeadChat").replace("&", "\u00a7")) + " " + group1;
            }
        }
        String msg = message;
        String permGroup = VaultHooks.getGroup(sender.getName());
        if (!permGroup.equals("")) {
            group1 = String.valueOf(group1) + " " + permGroup + RESET;
        }
        String toSend = String.valueOf(group1) + " " + username + RESET + " " + Main.getInstance().getConfig().getString("ChatEnd").replace("&", "\u00a7") + "\u00a7r " + msg;
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(toSend);
        }
    }

    public static void teamMessage(GameTeam team, Player sender, String message, boolean dead) {
        String permGroup;
        if (team == GameTeam.NONE) {
            ChatUtil.allMessage(team, sender, message, false);
            return;
        }
        String group = Main.getInstance().getConfig().getString("TeamChat").replace("&", "\u00a7").replace("%color%", String.valueOf(team.color()));
        if (dead) {
            group = String.valueOf(Main.getInstance().getConfig().getString("DeadChat").replace("&", "\u00a7")) + " " + group;
        }
        if (!(permGroup = VaultHooks.getGroup(sender.getName())).equals("")) {
            group = String.valueOf(group) + " " + permGroup + RESET;
        }
        String toSend = String.valueOf(group) + " " + team.color() + sender.getName() + RESET + " " + Main.getInstance().getConfig().getString("ChatEnd").replace("&", "\u00a7") + "\u00a7r " + message;
        for (Player player : team.getPlayers()) {
            player.sendMessage(toSend);
        }
    }

    public static void broadcast(String message) {
        Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    public static void nexusDestroyed(GameTeam attacker, GameTeam victim, Player p) {
        String title = Main.getInstance().getConfig().getString("NexusZnicenTitle").replace("&", "\u00a7").replace("%ZNICEN%", victim.coloredName()).replace("%KILLER%", String.valueOf(attacker.color().toString()) + p.getName()).replace("%TEAM%", attacker.coloredName());
        String sub = Main.getInstance().getConfig().getString("NexusZnicenSubTitle").replace("&", "\u00a7").replace("%ZNICEN%", victim.coloredName()).replace("%KILLER%", String.valueOf(attacker.color().toString()) + p.getName()).replace("%TEAM%", attacker.coloredName());
        ChatUtil.broadcast("\u00a78===============[ \u00a7aNexus Destroyed \u00a78]===============");
        ChatUtil.broadcast("\u00a7r");
        ChatUtil.broadcast(String.valueOf(attacker.color().toString()) + p.getName() + " \u00a77from team \u00a7r" + attacker.coloredName() + " \u00a77destroy " + victim.coloredName() + " \u00a77Nexus!");
        ChatUtil.broadcast("\u00a7r");
        ChatUtil.broadcast("\u00a78==============================================");
        if (Main.getInstance().getConfig().getBoolean("EnableNexusTitle")) {
            TitleAPI.AllTitle(title, sub);
        }
    }

    public static String nexusBreakMessage(Player breaker, GameTeam attacker, GameTeam victim) {
        return String.valueOf(ChatUtil.colorizeName(breaker, attacker)) + " \u00a77destroying team nexus " + victim.coloredName() + " \u00a77!";
    }

    private static String colorizeName(Player player, GameTeam team) {
        return team.color() + player.getName();
    }

    public static void phaseMessage(int phase) {
        String title = Main.getInstance().getConfig().getString("PhaseTitle").replace("&", "\u00a7").replace("%PHASE%", ChatUtil.translateRoman(phase));
        String sub = Main.getInstance().getConfig().getString("PhaseSubTitle").replace("&", "\u00a7").replace("%PHASE%", ChatUtil.translateRoman(phase));
        ChatUtil.broadcast("\u00a78===========[ \u00a79Procedure \u00a78]===========");
        ChatUtil.broadcast(String.valueOf(Util.getPhaseColor(phase)) + "Phase " + ChatUtil.translateRoman(phase) + " \u00a77started!");
        switch (phase) {
            case 1: {
                ChatUtil.broadcast("\u00a77Nexuses will be destroying in the phase " + ChatUtil.translateRoman(2));
                if (!Main.getInstance().getConfig().getBoolean("EnablePhaseTitle")) break;
                TitleAPI.AllTitle(title, sub);
                break;
            }
            case 2: {
                ChatUtil.broadcast("\u00a77Nexuses can destroy! Destroy the nexus!");
                ChatUtil.broadcast("\u00a77Bosses are spawned!");
                if (!Main.getInstance().getConfig().getBoolean("EnablePhaseTitle")) break;
                TitleAPI.AllTitle(title, sub);
                break;
            }
            case 3: {
                ChatUtil.broadcast("\u00a7bDiamond's \u00a77are spawned on the mid!");
                if (!Main.getInstance().getConfig().getBoolean("EnablePhaseTitle")) break;
                TitleAPI.AllTitle(title, sub);
                break;
            }
            case 4: {
                ChatUtil.broadcast("\u00a7eShop brewing \u00a77can now aviable! Fighting ahhhh!!");
                if (!Main.getInstance().getConfig().getBoolean("EnablePhaseTitle")) break;
                TitleAPI.AllTitle(title, sub);
                break;
            }
            case 5: {
                ChatUtil.broadcast("\u00a7cDouble nexus damage! BUM, BUM !");
                if (!Main.getInstance().getConfig().getBoolean("EnablePhaseTitle")) break;
                TitleAPI.AllTitle(title, sub);
            }
        }
        ChatUtil.broadcast("\u00a78================================");
    }

    public static void winMessage(GameTeam winner) {
        String title = Main.getInstance().getConfig().getString("EndGameTitle").replace("&", "\u00a7").replace("%TEAM%", winner.coloredName());
        String sub = Main.getInstance().getConfig().getString("EndGameSubTitle").replace("&", "\u00a7").replace("%TEAM%", winner.coloredName());
        ChatUtil.broadcast("\u00a78================[ \u00a75Annihilation game \u00a78]================");
        ChatUtil.broadcast("\u00a77Team \u00a7r" + winner.coloredName() + " \u00a77Win Anni!");
        ChatUtil.broadcast("");
        ChatUtil.broadcast("\u00a77We wish you luck in the next game! \u00a7c\u00a7lRestarting...");
        ChatUtil.broadcast("\u00a78=============================================");
        if (Main.getInstance().getConfig().getBoolean("EnableEndTitle")) {
            TitleAPI.AllTitle(title, sub);
        }
    }

    public static void bossDeath(Boss b, Player killer, GameTeam team) {
        ChatUtil.broadcast("\u00a78==========[ \u00a76Boss Killed \u00a78]==========");
        ChatUtil.broadcast("\u00a77Boss \u00a7r" + b.getBossName() + " \u00a77was killed by " + ChatUtil.colorizeName(killer, team));
        ChatUtil.broadcast("\u00a78===================================");
    }

    public static void bossRespawn(Boss b) {
        ChatUtil.broadcast("\u00a78================[ \u00a76Boss \u00a78]================");
        ChatUtil.broadcast("\u00a77Boss \u00a7r" + b.getBossName() + " \u00a77are spawned! go kill he and get the good items!!");
        ChatUtil.broadcast("\u00a78========================================");
    }

    public static String formatDeathMessage(Player victim, Player killer, String original) {
        GameTeam killerTeam = PlayerMeta.getMeta(killer).getTeam();
        String killerColor = killerTeam != null ? killerTeam.color().toString() : ChatColor.DARK_PURPLE.toString();
        String killerName = String.valueOf(killerColor) + killer.getName() + ChatColor.GRAY;
        String message = ChatColor.GRAY + ChatUtil.formatDeathMessage(victim, original);
        message = message.replace(killer.getName(), killerName);
        return message;
    }

    public static String formatDeathMessage(Player victim, String original) {
        GameTeam victimTeam = PlayerMeta.getMeta(victim).getTeam();
        String victimColor = victimTeam != null ? victimTeam.color().toString() : ChatColor.DARK_PURPLE.toString();
        String victimName = String.valueOf(victimColor) + victim.getName() + ChatColor.GRAY;
        String message = ChatColor.GRAY + original;
        if ((message = message.replace(victim.getName(), victimName)).contains(" \u00a78")) {
            String[] arr = message.split(" \u00a78\u00a7");
            message = arr[0];
        }
        return message.replace("was slain by", "was killed by");
    }

    public static String translateRoman(int number) {
        if (!roman) {
            return String.valueOf(number);
        }
        switch (number) {
            case 0: {
                return "0";
            }
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
            case 6: {
                return "VI";
            }
            case 7: {
                return "VII";
            }
            case 8: {
                return "VIII";
            }
            case 9: {
                return "IX";
            }
            case 10: {
                return "X";
            }
            case 11: {
                return "XI";
            }
        }
        return String.valueOf(number);
    }
}

