/*
 * Decompiled with CFR 0.152.
 */
package tk.thewoosh.hcf.command;

import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import tk.thewoosh.hcf.HCF;
import tk.thewoosh.hcf.faction.FactionPlayer;
import tk.thewoosh.hcf.rank.Rank;

public class CommandUpdateRank
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command arg1, String arg2, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            FactionPlayer fp = HCF.getManager().getPlayer(p);
            if (fp.getRank().hasFullPermissions()) {
                this.updateRank(sender, args);
            }
        } else if (sender instanceof ConsoleCommandSender) {
            this.updateRank(sender, args);
        }
        return false;
    }

    public void updateRank(CommandSender sender, String[] args) {
        if (args.length != 2) {
            sender.sendMessage(ChatColor.RED + "Usage: /updaterank <player> <rank>");
        } else {
            FactionPlayer fp = HCF.getManager().getPlayer(args[0]);
            if (fp == null) {
                sender.sendMessage(ChatColor.RED + "That player has never joined the server.");
            } else {
                Rank oldRank = fp.getRank();
                Rank newRank = Rank.getRank(args[1]);
                if (newRank == null) {
                    sender.sendMessage(ChatColor.RED + "Invalid rank! Ranks: " + Rank.getRanks());
                } else {
                    fp.setRank(newRank);
                    sender.sendMessage(ChatColor.GOLD + fp.getName() + ChatColor.GRAY + "'s rank has been updated from: " + ChatColor.GOLD + oldRank.toString() + ChatColor.GRAY + " to: " + ChatColor.GOLD + newRank.toString() + ChatColor.GRAY + ".");
                    HCF.getManager().sendUpdateRank(oldRank, newRank, sender.getName(), fp.getName());
                }
            }
        }
    }
}

