/*
 * Decompiled with CFR 0.152.
 */
package tk.thewoosh.hcf.command;

import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import tk.thewoosh.hcf.HCF;
import tk.thewoosh.hcf.faction.Faction;
import tk.thewoosh.hcf.faction.FactionManager;
import tk.thewoosh.hcf.faction.FactionPlayer;
import tk.thewoosh.hcf.faction.FactionRole;

public class CommandFaction
implements CommandExecutor {
    private static final HashMap<String, String> COMMANDS = new HashMap();

    static {
        COMMANDS.put("create", "Create a faction.");
        COMMANDS.put("join", "Allows you to join a faction.");
        COMMANDS.put("leave", "Allows you to leave a faction.");
        COMMANDS.put("info", "Shows info about your faction.");
        COMMANDS.put("who", "Shows info about a faction.");
        COMMANDS.put("desc", "Sets the description of your faction");
        COMMANDS.put("description", "Sets the description of your faction");
    }

    public boolean onCommand(CommandSender sender, Command arg1, String arg2, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            FactionManager fm = HCF.getManager();
            FactionPlayer fp = fm.getPlayer(p);
            Faction f = fp.getFaction();
            if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
                p.sendMessage("\u00a77 -=\u00a7aFactions Help\u00a77=-");
                for (String s : COMMANDS.keySet()) {
                    p.sendMessage("   \u00a77- \u00a7a" + s + "\u00a77: " + COMMANDS.get(s));
                }
            } else if (args[0].equalsIgnoreCase("create")) {
                if (fp.getFaction() != null) {
                    p.sendMessage("\u00a77You are already in faction: \u00a7a" + fp.getFactionName());
                } else if (args.length == 1) {
                    p.sendMessage("\u00a7cYou need to specify a name!");
                } else if (args.length == 2) {
                    if (fm.getFaction(args[1]) != null) {
                        p.sendMessage("\u00a77A faction already claimed that name. You can try to join, or choose another name.");
                        return true;
                    }
                    f = new Faction(args[1], "No description.");
                    fm.addFaction(f);
                    fm.addFactionSQL(f);
                    fp.setFaction(f);
                    String message = "\u00a77Faction: \u00a7a" + args[1] + " \u00a77was created by: \u00a7a" + p.getName();
                    for (Player pl : Bukkit.getOnlinePlayers()) {
                        if (pl == p) continue;
                        pl.sendMessage(message);
                    }
                    fp.setRole(FactionRole.LEADER);
                    Bukkit.getLogger().info("[FactionNotifier]: " + ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)message));
                    p.sendMessage("\u00a77You created faction: \u00a7a" + args[1]);
                }
            } else if (args[0].equalsIgnoreCase("info") || args.length == 1 && args[0].equalsIgnoreCase("who")) {
                if (f != null) {
                    p.sendMessage("\u00a7aShowing your factions info");
                    p.sendMessage(" \u00a77Name: \u00a7a" + f.getName());
                    p.sendMessage(" \u00a77Description: \u00a7a" + f.getDescription());
                    ArrayList<FactionPlayer> members = new ArrayList<FactionPlayer>();
                    for (FactionPlayer facpl : fm.getPlayers()) {
                        if (facpl.getFaction() == null || facpl.getFaction() != f && facpl.getFactionName() != f.getName() && !facpl.getFaction().getName().equalsIgnoreCase(f.getName())) continue;
                        members.add(facpl);
                    }
                    if (fp.getRole() == FactionRole.LEADER) {
                        p.sendMessage(" \u00a77Leader: \u00a7a" + fp.getName() + "\u00a77 / \u00a7aYou");
                    } else {
                        for (FactionPlayer fpl : members) {
                            if (fpl.getRole() != FactionRole.LEADER) continue;
                            p.sendMessage(" \u00a77Leader: \u00a7a" + fpl.getName());
                            break;
                        }
                    }
                    String mods = "";
                    String recruits = "";
                    for (FactionPlayer fpl : members) {
                        if (fpl == fp) continue;
                        if (fpl.getRole() == FactionRole.MOD) {
                            mods = String.valueOf(mods) + (mods == "" ? "\u00a7a" : "\u00a77, \u00a7a") + fpl.getName();
                            continue;
                        }
                        recruits = String.valueOf(recruits) + (recruits == "" ? "\u00a7a" : "\u00a77, \u00a7a") + fpl.getName();
                    }
                    if (mods == "") {
                        mods = "No mods.";
                    }
                    if (recruits == "") {
                        recruits = "No recruits";
                    }
                    p.sendMessage(" \u00a77Mods: \u00a7a" + mods);
                    p.sendMessage(" \u00a77Recruits: \u00a7a" + recruits);
                } else {
                    p.sendMessage("\u00a77You are not in a faction!");
                }
            } else if (args[0].equalsIgnoreCase("desc") || args[0].equalsIgnoreCase("description")) {
                if (f == null) {
                    p.sendMessage("\u00a77You are not in a faction!");
                } else {
                    if (args.length == 1) {
                        p.sendMessage("\u00a77Description: \u00a7a" + f.getDescription());
                        return true;
                    }
                    if (fp.getRole() == FactionRole.RECRUIT) {
                        p.sendMessage("\u00a77You are not allowed to change \u00a7ayour factions description\u00a77! Maybe ask a mod or the leader?");
                    } else {
                        String newDesc = "";
                        if (args.length == 2) {
                            newDesc = args[1];
                        } else {
                            int i = 1;
                            while (i < args.length) {
                                newDesc = String.valueOf(newDesc) + args[i];
                                ++i;
                            }
                        }
                        f.setDescription(newDesc);
                        p.sendMessage("\u00a77You have set the description to: " + newDesc);
                        f.notifyMembers("\u00a7a" + p.getName() + " \u00a77has changed the description to: \u00a7a" + newDesc);
                    }
                }
            } else if (args[0].equalsIgnoreCase("who") && args.length > 1) {
                FactionPlayer target = fm.getPlayer(args[1]);
                if (target == null) {
                    p.sendMessage("\u00a77Player not found!");
                } else {
                    p.sendMessage("\u00a77Showing info of player: \u00a7a" + target.getName());
                    if (target.getFaction() != null) {
                        p.sendMessage("  \u00a77Faction: \u00a7a" + target.getFaction().getName());
                        p.sendMessage("  \u00a77Faction Role: \u00a7a" + target.getRole().toString().toLowerCase());
                    } else {
                        p.sendMessage("  \u00a77This player is not in a faction.");
                    }
                    p.sendMessage("  \u00a77Rank: \u00a7r" + target.getRank().getPrefix());
                }
            }
        }
        return false;
    }
}

