/*
 * Decompiled with CFR 0.152.
 */
package tk.thewoosh.hcf.command;

import org.bukkit.Chunk;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import tk.thewoosh.hcf.HCF;
import tk.thewoosh.hcf.Settings;
import tk.thewoosh.hcf.claims.ClaimInfo;
import tk.thewoosh.hcf.claims.ClaimManager;
import tk.thewoosh.hcf.claims.ClaimType;
import tk.thewoosh.hcf.faction.Faction;
import tk.thewoosh.hcf.faction.FactionPlayer;
import tk.thewoosh.hcf.faction.FactionRole;

public class CommandClaim
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        FactionPlayer fp = HCF.getManager().getPlayer(player);
        Faction faction = fp.getFaction();
        if (!fp.getRank().hasFullPermissions()) {
            this.handleNormal(faction, player, fp);
        } else if (args.length == 0) {
            this.handleTypes(player);
        } else {
            ClaimType type;
            try {
                type = ClaimType.valueOf(args[0]);
            }
            catch (Exception e) {
                player.sendMessage(e.getClass().getSimpleName());
                this.handleTypes(player);
                return false;
            }
            if (type.equals((Object)ClaimType.FACTION)) {
                this.handleNormal(faction, player, fp);
            } else {
                Chunk c = player.getLocation().getChunk();
                if (ClaimManager.isClaimed(c)) {
                    player.sendMessage(Settings.CLAIM_CLAIMED);
                } else {
                    ClaimManager.registerClaim(c, new ClaimInfo(type, null));
                    player.sendMessage(Settings.CLAIM_STAFF);
                    HCF.getManager().sendStaffClaim(c, fp);
                }
            }
        }
        return false;
    }

    private void handleTypes(Player player) {
        StringBuilder sb = new StringBuilder();
        ClaimType[] claimTypeArray = ClaimType.values();
        int n = claimTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClaimType type = claimTypeArray[n2];
            sb.append(String.valueOf(type.toString()) + ", ");
            ++n2;
        }
        String s = sb.toString();
        s = s.substring(0, s.length() - 2);
        player.sendMessage(Settings.CLAIM_USABLE.replaceAll("CLAIMTYPES", s));
    }

    public void handleNormal(Faction faction, Player player, FactionPlayer fp) {
        Chunk c = player.getLocation().getChunk();
        if (faction != null) {
            if (fp.getRole() == FactionRole.RECRUIT) {
                player.sendMessage(Settings.CLAIM_ROLE);
            } else if (ClaimManager.isClaimed(c)) {
                player.sendMessage(Settings.CLAIM_CLAIMED);
            } else {
                ClaimManager.registerClaim(c, new ClaimInfo(ClaimType.FACTION, faction));
                faction.notifyMembers(Settings.CLAIM_DONE.replaceAll("who", player.getName()).replaceAll("x", "" + c.getX()).replaceAll("z", "" + c.getZ()));
            }
        } else {
            player.sendMessage(Settings.CLAIM_FACTION);
        }
    }
}

