/*
 * Decompiled with CFR 0.152.
 */
package com.huskehhh.mysql.sqlite;

import com.huskehhh.mysql.Database;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class SQLite
extends Database {
    private final String dbLocation;

    public SQLite(String dbLocation) {
        this.dbLocation = dbLocation;
    }

    @Override
    public Connection openConnection() throws SQLException, ClassNotFoundException {
        File file;
        if (this.checkConnection()) {
            return this.connection;
        }
        File dataFolder = new File("sqlite-db/");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        if (!(file = new File(dataFolder, this.dbLocation)).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                System.out.println("Unable to create database!");
            }
        }
        Class.forName("org.sqlite.JDBC");
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + dataFolder + "/" + this.dbLocation);
        return this.connection;
    }
}

