/*
 * Decompiled with CFR 0.152.
 */
package tk.thewoosh.plugins.wac.util;

import org.bukkit.Location;
import org.bukkit.Material;
import tk.thewoosh.plugins.wac.util.MaterialCheck;

public class MovementUtil {
    public static final double PLAYER_WIDTH = 0.6;
    public static final double PLAYER_HEIGTH = 1.8;
    public static final double PLAYER_HEIGTH_SNEAKING = 1.6;
    private static final MaterialCheck CHECK_STAIR = new MaterialCheck(){

        @Override
        public boolean checkMaterial(Material material) {
            switch (material) {
                case WOOD_STAIRS: 
                case COBBLESTONE_STAIRS: 
                case BRICK_STAIRS: 
                case SMOOTH_STAIRS: 
                case NETHER_BRICK_STAIRS: 
                case SANDSTONE_STAIRS: 
                case SPRUCE_WOOD_STAIRS: 
                case BIRCH_WOOD_STAIRS: 
                case JUNGLE_WOOD_STAIRS: 
                case QUARTZ_STAIRS: 
                case ACACIA_STAIRS: 
                case DARK_OAK_STAIRS: 
                case RED_SANDSTONE_STAIRS: {
                    return true;
                }
            }
            return false;
        }
    };
    private static final MaterialCheck CHECK_STEP = new MaterialCheck(){

        @Override
        public boolean checkMaterial(Material material) {
            switch (material) {
                case STEP: 
                case WOOD_STEP: {
                    return true;
                }
            }
            return false;
        }
    };

    public static boolean isStepping(Location location) {
        return MovementUtil.isColliding(location, CHECK_STAIR) || MovementUtil.isColliding(location, CHECK_STEP);
    }

    public static boolean isColliding(Location location, MaterialCheck material) {
        double d = 0.3;
        return material.checkMaterial(location) || material.checkMaterial(location.clone().add(d, 0.0, 0.0)) || material.checkMaterial(location.clone().add(-d, 0.0, 0.0)) || material.checkMaterial(location.clone().add(d, 0.0, d)) || material.checkMaterial(location.clone().add(-d, 0.0, d)) || material.checkMaterial(location.clone().add(d, 0.0, -d)) || material.checkMaterial(location.clone().add(-d, 0.0, -d)) || material.checkMaterial(location.clone().add(0.0, 0.0, -d)) || material.checkMaterial(location.clone().add(0.0, 0.0, d));
    }

    public static boolean shouldNotFlag(Location loc) {
        return MovementUtil.isMaterialGlideable(loc.getBlock().getType()) || MovementUtil.isMaterialGlideable(loc.clone().add(0.3, 0.0, 0.0).getBlock().getType()) || MovementUtil.isMaterialGlideable(loc.clone().add(0.3, 0.0, 0.3).getBlock().getType()) || MovementUtil.isMaterialGlideable(loc.clone().add(0.3, 0.0, -0.3).getBlock().getType()) || MovementUtil.isMaterialGlideable(loc.clone().add(-0.3, 0.0, 0.0).getBlock().getType()) || MovementUtil.isMaterialGlideable(loc.clone().add(-0.3, 0.0, -0.3).getBlock().getType()) || MovementUtil.isMaterialGlideable(loc.clone().add(0.0, 0.0, -0.3).getBlock().getType()) || MovementUtil.isMaterialGlideable(loc.clone().add(0.0, 0.0, 0.3).getBlock().getType()) || MovementUtil.isOnGround(loc.clone().add(0.0, 0.0, 0.0));
    }

    public static boolean isOnGround(Location loc) {
        return loc.getBlock().getLocation().clone().add(0.0, -1.0, 0.0).getBlock().getType().isSolid() || loc.clone().add(0.3, -1.0, 0.0).getBlock().getType().isSolid() || loc.clone().add(0.3, -1.0, 0.3).getBlock().getType().isSolid() || loc.clone().add(0.3, -1.0, -0.3).getBlock().getType().isSolid() || loc.clone().add(-0.3, -1.0, 0.0).getBlock().getType().isSolid() || loc.clone().add(-0.3, -1.0, -0.3).getBlock().getType().isSolid() || loc.clone().add(0.0, -1.0, -0.3).getBlock().getType().isSolid() || loc.clone().add(0.0, -1.0, 0.3).getBlock().getType().isSolid();
    }

    public static boolean isMaterialGlideable(Material mat) {
        switch (mat) {
            case LADDER: 
            case VINE: {
                return true;
            }
        }
        return false;
    }
}

