/*
 * Decompiled with CFR 0.152.
 */
package tk.thewoosh.plugins.wac.checks.movement;

import org.bukkit.Bukkit;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import tk.thewoosh.plugins.wac.checks.CancelType;
import tk.thewoosh.plugins.wac.checks.CheckResult;
import tk.thewoosh.plugins.wac.checks.CheckType;
import tk.thewoosh.plugins.wac.checks.MoveCheck;
import tk.thewoosh.plugins.wac.util.Distance;
import tk.thewoosh.plugins.wac.util.MovementUtil;
import tk.thewoosh.plugins.wac.util.Settings;
import tk.thewoosh.plugins.wac.util.User;
import tk.thewoosh.plugins.wac.util.YMap;

public class NormalMovements
extends MoveCheck {
    public static final CheckResult PASS = new CheckResult(false, CheckType.NORMALMOVEMENTS, "");

    public NormalMovements() {
        super(CheckType.NORMALMOVEMENTS);
        this.cancelType = CancelType.NOTHING;
    }

    @Override
    public CheckResult runCheck(User user, Distance distance) {
        int ticksUp;
        if (!distance.isGoingUp() || distance.getYDifference() == 0.0) {
            user.wasGoingUp = false;
            user.oldYModifier = 0;
            user.ticksUp = 0;
            return PASS;
        }
        user.wasGoingUp = true;
        user.oldTicksUp = ticksUp = user.ticksUp++;
        double speed = Settings.round(distance.getYDifference());
        int id = this.getYModifier(user);
        if (id > user.oldYModifier) {
            user.oldYModifier = id;
        }
        id = user.oldYModifier;
        YMap map = YMap.get(id);
        if (distance.isGoingUp() && distance.isMovingHorizontally()) {
            boolean step = MovementUtil.isStepping(distance.getFrom()) || MovementUtil.isStepping(distance.getTo());
            boolean yMap = map != null && map.contains(speed);
            this.debug(yMap);
            if (step) {
                if (speed > 0.5) {
                    return new CheckResult(true, CheckType.NORMALMOVEMENTS, "reason: step, type: " + (speed > 0.5 ? "high" : "low") + ", y: " + speed);
                }
                return PASS;
            }
        }
        if (map == null) {
            Bukkit.getLogger().warning("Modifier '" + id + "' has no contents!");
            return PASS;
        }
        if (!map.hasSpeed(ticksUp)) {
            return new CheckResult(true, CheckType.NORMALMOVEMENTS, "reason: long, s: " + ticksUp + ", m: " + map.size());
        }
        if (!(map.size() > ticksUp || id != 0 && distance.isMovingHorizontally() && map.size() == ticksUp && speed == map.getSpeed(ticksUp))) {
            new CheckResult(true, CheckType.NORMALMOVEMENTS, "reason: too high (ticksUp: " + ticksUp + ", max: " + (map.size() - 1));
        }
        if (map.size() < ticksUp) {
            return PASS;
        }
        double expected = map.getSpeed(ticksUp);
        if (expected != speed) {
            return new CheckResult(true, CheckType.NORMALMOVEMENTS, "reason: normal, type: " + (expected < speed ? "high" : "low") + " (speed: " + speed + ", expected: " + expected);
        }
        return PASS;
    }

    public int getYModifier(User user) {
        if (user.getPlayer().hasPotionEffect(PotionEffectType.JUMP)) {
            for (PotionEffect pe : user.getPlayer().getActivePotionEffects()) {
                if (!pe.getType().equals((Object)PotionEffectType.JUMP)) continue;
                return pe.getAmplifier() + 1;
            }
        }
        return 0;
    }
}

