/*
 * Decompiled with CFR 0.152.
 */
package tk.thewoosh.plugins.wac;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import tk.thewoosh.plugins.wac.Cleaner;
import tk.thewoosh.plugins.wac.checks.CheckResult;
import tk.thewoosh.plugins.wac.checks.CheckType;
import tk.thewoosh.plugins.wac.events.CheckManager;
import tk.thewoosh.plugins.wac.events.JoinLeaveListener;
import tk.thewoosh.plugins.wac.util.User;

public class WAC
extends JavaPlugin {
    public static final HashMap<UUID, User> USERS = new HashMap();
    public static final ArrayList<CheckType> DISABLED_CHECKS = new ArrayList();
    public static final boolean SIMPLE_LOG = false;

    public void onEnable() {
        PluginManager pm = Bukkit.getPluginManager();
        pm.registerEvents((Listener)new JoinLeaveListener(), (Plugin)this);
        pm.registerEvents((Listener)new CheckManager(), (Plugin)this);
        new Cleaner().runTaskTimerAsynchronously((Plugin)this, 200L, 200L);
        for (Player p : Bukkit.getOnlinePlayers()) {
            USERS.put(p.getUniqueId(), new User(p));
        }
    }

    public static void log(User u, CheckResult result) {
        if (DISABLED_CHECKS.contains((Object)result.getType())) {
            throw new IllegalStateException("Error! Tried to log a disabled check!");
        }
        String message = String.valueOf(ChatColor.DARK_PURPLE.toString()) + ChatColor.BOLD + "WAC: " + ChatColor.AQUA.toString() + u.getPlayer().getName() + ChatColor.GRAY + " tried to use " + ChatColor.RED + result.getType().getName();
        message = String.valueOf(message) + ChatColor.GRAY + ", " + result.getMessage();
        u.getPlayer().sendMessage(message);
        Bukkit.getLogger().info(message);
    }

    public static User getUser(Player player) {
        for (User user : USERS.values()) {
            if (user.getPlayer() != player && !user.getPlayer().getUniqueId().equals(player.getUniqueId())) continue;
            return user;
        }
        return null;
    }

    public static boolean shouldCheck(User user, CheckType type) {
        return !DISABLED_CHECKS.contains((Object)type);
    }

    public static boolean isSilent() {
        return false;
    }
}

