/*
 * Decompiled with CFR 0.152.
 */
package cluster.report;

import cluster.report.JsonMaker;
import cluster.report.Message;
import cluster.report.PlayerReports;
import cluster.report.Report;
import cluster.report.ReportSystem;
import cluster.report.ReportedPlayer;
import java.util.HashMap;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ReportsCommand
implements CommandExecutor {
    private static final String s1 = "[\"\",{\"text\":\"List of players who sent complaints\",\"color\":\"gold\",\"underlined\":true,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/reports alist\"}}]";
    private static final String s2 = "[\"\",{\"text\":\"List of players on which complaints were sent\",\"color\":\"gold\",\"underlined\":true,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/reports glist\"}}]";
    private ReportSystem instance;

    public ReportsCommand(ReportSystem system) {
        this.instance = system;
    }

    /*
     * WARNING - void declaration
     */
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!sender.hasPermission("report.admin")) {
            Message.noPermission.send(sender);
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7b--------------------");
            sender.sendMessage("\u00a73Reports:");
            if (sender instanceof Player) {
                ReportSystem.nms.sendRawMessage((Player)sender, s1);
                ReportSystem.nms.sendRawMessage((Player)sender, s2);
            }
            sender.sendMessage("");
            sender.sendMessage("\u00a7aComplaints from player \u00a77- \u00a7b/reports get <player>");
            sender.sendMessage("\u00a7aComplaints on player \u00a77- \u00a7b/reports of <player>");
            sender.sendMessage("\u00a7cDelete complaints on player \u00a77- \u00a7b/reports rm <player>");
            sender.sendMessage("\u00a7cDelete complaints from player \u00a77- \u00a7b/reports rs <player>");
            return true;
        }
        if (args[0].equalsIgnoreCase("alist")) {
            List<PlayerReports> reports = this.instance.getAllReports();
            if (reports.isEmpty()) {
                sender.sendMessage("\u00a7cThere are no reports.");
                return true;
            }
            sender.sendMessage("\u00a79\u00a7m---------------------------------");
            sender.sendMessage("\u00a7bThere are \u00a7c" + reports.size() + "\u00a7b players have sent the report:");
            for (PlayerReports r : reports) {
                StringBuilder builder = new StringBuilder();
                for (Report rp : r.getReports()) {
                    builder.append("\u00a7b" + rp.formatTime() + " \u00a76reported \u00a7a" + rp.getPlayer());
                    builder.append('\n');
                }
                JsonMaker.sendAsRepoter((Player)sender, r.getPlayer(), r.getReports().size(), builder.toString());
            }
            sender.sendMessage("\u00a79\u00a7m---------------------------------");
            return true;
        }
        if (args[0].equalsIgnoreCase("glist")) {
            List<PlayerReports> reports = this.instance.getAllReports();
            if (reports.isEmpty()) {
                sender.sendMessage("\u00a7cThere are no reports.");
                return true;
            }
            HashMap<String, void> map = new HashMap<String, void>();
            for (PlayerReports r : reports) {
                for (Report rep : r.getReports()) {
                    void var12_27;
                    String player = rep.getPlayer();
                    if (map.containsKey(player)) {
                        ReportedPlayer reportedPlayer = (ReportedPlayer)map.get(player);
                    } else {
                        ReportedPlayer reportedPlayer = new ReportedPlayer(player);
                    }
                    var12_27.addSender(new Report(r.getPlayer(), rep.getMessage(), rep.getTime()));
                    map.put(player, var12_27);
                }
            }
            if (map.isEmpty()) {
                sender.sendMessage("\u00a7cThere are no reports.");
                return true;
            }
            sender.sendMessage("\u00a79\u00a7m---------------------------------");
            sender.sendMessage("\u00a7bThere are \u00a7c" + map.size() + "\u00a7b players have been reported:");
            for (String key : map.keySet()) {
                ReportedPlayer value = (ReportedPlayer)map.get(key);
                List<Report> senders = value.getSenders();
                StringBuilder builder = new StringBuilder();
                for (Report report : senders) {
                    builder.append("\u00a7b" + report.formatTime() + " \u00a76was reported by \u00a7a" + report.getPlayer());
                    builder.append('\n');
                }
                JsonMaker.sendAsRepoted((Player)sender, key, senders.size(), builder.toString());
            }
            sender.sendMessage("\u00a79\u00a7m---------------------------------");
            return true;
        }
        if (args[0].equalsIgnoreCase("get")) {
            if (args.length < 2) {
                sender.sendMessage("\u00a72Reports from player \u00a77- \u00a7b/reports get <player>");
                return true;
            }
            PlayerReports reports = this.instance.getReports(args[1]);
            int size = reports.getReports().size();
            if (size == 0) {
                sender.sendMessage("\u00a7cPlayer " + reports.getPlayer() + " did not sent \u0430ny reports.");
                return true;
            }
            sender.sendMessage("\u00a79\u00a7m---------------------------------");
            sender.sendMessage("\u00a76Player " + reports.getPlayer() + " sent " + size + " reports:");
            for (Report r : reports.getReports()) {
                JsonMaker.sendMsg3((Player)sender, r.getPlayer(), r.getMessage(), r.formatTime());
            }
            sender.sendMessage("\u00a79\u00a7m---------------------------------");
            return true;
        }
        if (args[0].equalsIgnoreCase("of")) {
            if (args.length < 2) {
                sender.sendMessage("\u00a72Complaints on player \u00a77- \u00a7b/reports of <player>");
                return true;
            }
            ReportedPlayer player = this.instance.getPlayer(args[1]);
            int n = player.getSenders().size();
            if (n == 0) {
                sender.sendMessage("\u00a7cPlayer " + player.getPlayer() + " did not receive any reports.");
                return true;
            }
            sender.sendMessage("\u00a79\u00a7m---------------------------------");
            sender.sendMessage("\u00a72Player " + args[1] + " have " + n + " reports:");
            for (Report r : player.getSenders()) {
                JsonMaker.sendMsg2((Player)sender, r.getPlayer(), r.getMessage(), r.formatTime());
            }
            sender.sendMessage("\u00a79\u00a7m---------------------------------");
            return true;
        }
        if (args[0].equalsIgnoreCase("rm")) {
            if (args.length < 2) {
                sender.sendMessage("\u00a72Delete all complaints on the specified player \u00a77- \u00a7b/reports rm <player>");
                return true;
            }
            int r = this.instance.unreportPlayer(args[1]);
            sender.sendMessage("\u00a7aRemoved " + r + " reports!");
            return true;
        }
        if (args[0].equalsIgnoreCase("rs")) {
            if (args.length < 2) {
                sender.sendMessage("\u00a72Delete all complaints sent by specified player \u00a77- \u00a7b/reports rs <player>");
                return true;
            }
            if (this.instance.unreportAll(args[1])) {
                sender.sendMessage("\u00a7aAll reports sent by " + args[1] + " have been removed");
            } else {
                sender.sendMessage("\u00a7cThis player have not sent any reports");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            ReportSystem.instance.reloadConfig();
            ReportSystem.instance.reportExecutor.load();
            Message.load(ReportSystem.instance.getConfig());
            sender.sendMessage("\u00a7aConfiguration reloaded!");
        }
        return true;
    }
}

