/*
 * Decompiled with CFR 0.152.
 */
package cluster.report;

import cluster.report.Message;
import cluster.report.PlayerReports;
import cluster.report.Report;
import cluster.report.ReportCommand;
import cluster.report.ReportedPlayer;
import cluster.report.ReportsCommand;
import cluster.report.nms.NMS;
import cluster.report.nms.V1_10_R1;
import cluster.report.nms.V1_11_R1;
import cluster.report.nms.V1_12_R1;
import cluster.report.nms.V1_8_R1;
import cluster.report.nms.V1_8_R2;
import cluster.report.nms.V1_8_R3;
import cluster.report.nms.V1_9_R1;
import cluster.report.nms.V1_9_R2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ReportSystem
extends JavaPlugin {
    public static ReportSystem instance;
    public static NMS nms;
    public ReportCommand reportExecutor;
    private ReportsCommand reportsExecutor;
    private File file;
    private FileConfiguration config;

    public void onEnable() {
        instance = this;
        String ver = ReportSystem.getVersionAPI();
        if (ver.equals("v1_8_R3")) {
            nms = new V1_8_R3();
        } else if (ver.equals("v1_8_R2")) {
            nms = new V1_8_R2();
        } else if (ver.equals("v1_8_R1")) {
            nms = new V1_8_R1();
        } else if (ver.equals("v1_9_R1")) {
            nms = new V1_9_R1();
        } else if (ver.equals("v1_9_R2")) {
            nms = new V1_9_R2();
        } else if (ver.equals("v1_10_R1")) {
            nms = new V1_10_R1();
        } else if (ver.equals("v1_11_R1")) {
            nms = new V1_11_R1();
        } else if (ver.equals("v1_12_R1")) {
            nms = new V1_12_R1();
        } else {
            this.getLogger().warning("Your version (" + ver + ") is not supported. You may have some problems with plugin.");
        }
        this.reportExecutor = new ReportCommand(this);
        this.reportsExecutor = new ReportsCommand(this);
        this.getCommand("report").setExecutor((CommandExecutor)this.reportExecutor);
        this.getCommand("reports").setExecutor((CommandExecutor)this.reportsExecutor);
        if (!new File(this.getDataFolder(), "config.yml").exists()) {
            this.getConfig().options().copyDefaults(true);
            this.saveDefaultConfig();
        }
        try {
            this.file = new File(this.getDataFolder(), "reports.yml");
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            this.config = YamlConfiguration.loadConfiguration((File)this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.reloadConfig();
        Message.load(this.getConfig());
    }

    public boolean isValidPlayer(String name) {
        return true;
    }

    public void reportPlayer(Report report, String srcPlayer) {
        this.config.set(String.valueOf(srcPlayer) + "." + report.getPlayer() + ".message", (Object)report.getMessage());
        this.config.set(String.valueOf(srcPlayer) + "." + report.getPlayer() + ".time", (Object)report.getTime());
        this.save();
    }

    public boolean unreportPlayer(String reported, String srcPlayer) {
        if (!this.config.contains(String.valueOf(srcPlayer) + "." + reported + ".message")) {
            return false;
        }
        this.config.set(String.valueOf(srcPlayer) + "." + reported, null);
        this.save();
        return true;
    }

    public boolean unreportAll(String srcPlayer) {
        if (!this.config.contains(srcPlayer)) {
            return false;
        }
        this.config.set(srcPlayer, null);
        this.save();
        return true;
    }

    public int unreportPlayer(String reported) {
        Set keys = this.config.getKeys(false);
        if (keys == null || keys.isEmpty()) {
            return 0;
        }
        int n = 0;
        for (String k : keys) {
            if (!this.config.contains(String.valueOf(k) + "." + reported + ".message")) continue;
            this.config.set(String.valueOf(k) + "." + reported, null);
            ++n;
        }
        this.save();
        return n;
    }

    public PlayerReports getReports(String srcPlayer) {
        ArrayList<Report> reports = new ArrayList<Report>();
        ConfigurationSection section = this.config.getConfigurationSection(srcPlayer);
        if (section == null) {
            return new PlayerReports(srcPlayer, reports);
        }
        Set keys = section.getKeys(false);
        if (keys == null || keys.isEmpty()) {
            return new PlayerReports(srcPlayer, reports);
        }
        for (String k : keys) {
            String link = this.config.getString(String.valueOf(srcPlayer) + "." + k + ".message", "???");
            long time = this.config.getLong(String.valueOf(srcPlayer) + "." + k + ".time");
            reports.add(new Report(k, link, time));
        }
        return new PlayerReports(srcPlayer, reports);
    }

    public List<PlayerReports> getAllReports() {
        Set keys = this.config.getKeys(false);
        if (keys == null || keys.isEmpty()) {
            return new ArrayList<PlayerReports>();
        }
        ArrayList<PlayerReports> list = new ArrayList<PlayerReports>();
        for (String k : keys) {
            PlayerReports reports = this.getReports(k);
            if (reports == null || reports.getReports().isEmpty()) continue;
            list.add(reports);
        }
        return list;
    }

    public ReportedPlayer getPlayer(String name) {
        ReportedPlayer player = new ReportedPlayer(name);
        for (PlayerReports pr : this.getAllReports()) {
            for (Report r : pr.getReports()) {
                if (!r.getPlayer().equalsIgnoreCase(name)) continue;
                player.addSender(new Report(pr.getPlayer(), r.getMessage(), r.getTime()));
            }
        }
        return player;
    }

    public static String getVersionAPI() {
        String packageName = instance.getServer().getClass().getPackage().getName();
        return packageName.substring(packageName.lastIndexOf(46) + 1);
    }

    private void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

