/*
 * Decompiled with CFR 0.152.
 */
package cluster.report;

import cluster.report.JsonMaker;
import cluster.report.Message;
import cluster.report.PlayerReports;
import cluster.report.Report;
import cluster.report.ReportSystem;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ReportCommand
implements CommandExecutor {
    private ReportSystem instance;
    private int limit;

    public ReportCommand(ReportSystem system) {
        this.instance = system;
        this.load();
    }

    public void load() {
        this.limit = ReportSystem.instance.getConfig().getInt("limit", 8);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!sender.hasPermission("report.report")) {
            Message.noPermission.send(sender);
            return true;
        }
        if (!(sender instanceof Player)) {
            return true;
        }
        Player p = (Player)sender;
        if (args.length == 0) {
            Message.usage.send((CommandSender)p);
            return true;
        }
        if (args[0].startsWith("-")) {
            if (args[0].equalsIgnoreCase("-rm")) {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7cRemove report - /report -rm <player>");
                    return true;
                }
                String target = args[1];
                if (this.instance.unreportPlayer(target, sender.getName())) {
                    Message.removed.replace("{player}", target).send((CommandSender)p);
                } else {
                    Message.noReport.replace("{player}", target).send((CommandSender)p);
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("-list")) {
                PlayerReports rps = this.instance.getReports(sender.getName());
                int n = rps.getReports().size();
                if (n == 0) {
                    Message.youHaveNoReports.send((CommandSender)p);
                    return true;
                }
                Message.youHaveReports.replace("{amount}", String.valueOf(n)).send((CommandSender)p);
                for (Report r : rps.getReports()) {
                    JsonMaker.sendMsg(p, r.getPlayer(), r.getMessage(), r.formatTime());
                }
                return true;
            }
            sender.sendMessage("Usage: /report -<cmd>");
            sender.sendMessage("Commands: rm, list");
            return true;
        }
        if (args.length < 2) {
            Message.usage.send((CommandSender)p);
            return true;
        }
        String target = args[0];
        String msg = "";
        int i = 1;
        while (i < args.length) {
            msg = String.valueOf(msg) + args[i] + " ";
            ++i;
        }
        msg = msg.trim();
        if (this.instance.getReports(sender.getName()).getReports().size() >= this.limit) {
            Message.overlimit.replace("{limit}", String.valueOf(this.limit)).send((CommandSender)p);
            return true;
        }
        if (target.equalsIgnoreCase(sender.getName()) || !this.instance.isValidPlayer(target)) {
            Message.playerExempt.send((CommandSender)p);
            return true;
        }
        this.instance.reportPlayer(new Report(target, msg, System.currentTimeMillis()), p.getName());
        Message.success.replace("{player}", target).replace("{message}", msg).send((CommandSender)p);
        return true;
    }
}

