/*
 * Decompiled with CFR 0.152.
 */
package cluster.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public enum Message {
    noPermission,
    usage,
    success,
    playerExempt,
    overlimit,
    noReport,
    removed,
    youHaveReports,
    youHaveNoReports;

    private static Map<Message, List<String>> msg;

    static {
        msg = new HashMap<Message, List<String>>();
    }

    public static void load(FileConfiguration c) {
        msg.clear();
        Message[] messageArray = Message.values();
        int n = messageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Message m = messageArray[n2];
            Object obj = c.get("messages." + m.name().replace("_", "."));
            if (obj instanceof List) {
                msg.put(m, (List)obj);
            } else if (obj instanceof String) {
                ArrayList<String> list = new ArrayList<String>();
                list.add((String)obj);
                msg.put(m, list);
            }
            ++n2;
        }
    }

    public void send(CommandSender sender) {
        new Sender(this).send(sender);
    }

    public Sender replace(String from, String to) {
        Sender s = new Sender(this);
        s.replace(from, to);
        return s;
    }

    public List<String> lines() {
        return msg.get((Object)this);
    }

    public class Sender {
        private Message msg;
        private Map<String, String> cache = new HashMap<String, String>();

        public Sender(Message msg) {
            this.msg = msg;
        }

        public Sender replace(String from, String to) {
            this.cache.put(from, to);
            return this;
        }

        public void send(CommandSender player) {
            List a = (List)msg.get((Object)this.msg);
            if (a == null) {
                return;
            }
            for (String m : a) {
                String s = this.placeholders(m);
                player.sendMessage(s);
            }
        }

        private String placeholders(String input) {
            if (!(input = input.replace("&", "\u00a7")).contains("{")) {
                return input;
            }
            for (Map.Entry<String, String> entry : this.cache.entrySet()) {
                input = input.replace(entry.getKey(), entry.getValue());
            }
            return input;
        }
    }
}

