/*
 * Decompiled with CFR 0.152.
 */
package be.makshouw.easyspawn;

import be.makshouw.easyspawn.commands.SpawnCommands;
import be.makshouw.easyspawn.listeners.PlayerJoinEvent;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class EasySpawn
extends JavaPlugin {
    public static EasySpawn instance;
    public HashMap<String, String> configResult = new HashMap();

    public void onEnable() {
        instance = this;
        Bukkit.getLogger().info("----------------------------------------------------------------");
        Bukkit.getLogger().info("EasySpawn by MAKSHOUW");
        Bukkit.getLogger().info("This is a FREE PLUGIN. If you want the source code, let me know.");
        Bukkit.getLogger().info("----------------------------------------------------------------");
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.rlConfig();
        this.getCommand("spawn").setExecutor((CommandExecutor)new SpawnCommands());
        this.getCommand("setspawn").setExecutor((CommandExecutor)new SpawnCommands());
        if (this.getMessage("teleport_on_connect").equals("true")) {
            PluginManager pluginManager = Bukkit.getServer().getPluginManager();
            pluginManager.registerEvents((Listener)new PlayerJoinEvent(), (Plugin)this);
        }
    }

    public void rlConfig() {
        this.reloadConfig();
        this.configResult.clear();
        this.configResult.put("teleport_accepted", this.getConfig().getString("message.teleport_accepted").replace("&", "\u00a7"));
        this.configResult.put("sender_is_not_player", this.getConfig().getString("message.sender_is_not_player").replace("&", "\u00a7"));
        this.configResult.put("no_permission", this.getConfig().getString("message.no_permission").replace("&", "\u00a7"));
        this.configResult.put("set_spawn_success", this.getConfig().getString("message.set_spawn_success").replace("&", "\u00a7"));
        this.configResult.put("config_reloaded_success", this.getConfig().getString("message.config_reloaded_success").replace("&", "\u00a7"));
        this.configResult.put("prefix", this.getConfig().getString("main.prefix").replace("&", "\u00a7"));
        this.configResult.put("teleport_on_connect", this.getConfig().getString("main.teleport_on_connect"));
        this.configResult.put("send_teleport_message_on_join", this.getConfig().getString("main.send_teleport_message_on_join"));
        this.configResult.put("setspawn_permission", this.getConfig().getString("permission.setspawn_permission").replace("&", "\u00a7"));
        this.configResult.put("reload_config_permission", this.getConfig().getString("permission.reload_config_permission").replace("&", "\u00a7"));
        this.configResult.put("spawn_loc", this.getConfig().getString("location.loc"));
    }

    public String getMessage(String s) {
        if (this.configResult.get(s) != null) {
            return this.configResult.get(s).toString();
        }
        return "Hello, i found a problem in the configuration file. Reset the configuration and contact me if the problem persists. Error code: " + s;
    }

    public Location StringToLocation(String locationString) {
        Location loc = null;
        String[] parties = locationString.split(":");
        String worldName = parties[0];
        double x = Double.valueOf(parties[1]);
        double y = Double.valueOf(parties[2]);
        double z = Double.valueOf(parties[3]);
        float yaw = Float.valueOf(parties[4]).floatValue();
        float pitch = Float.valueOf(parties[5]).floatValue();
        loc = new Location(Bukkit.getWorld((String)worldName), x, y, z, yaw, pitch);
        return loc;
    }

    public String RealLocationToOneLine(Location location) {
        String worldName = location.getWorld().getName();
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        float yaw = location.getYaw();
        float pitch = location.getPitch();
        return String.valueOf(worldName) + ":" + x + ":" + y + ":" + z + ":" + yaw + ":" + pitch;
    }

    public void onDisable() {
        this.saveConfig();
    }

    public static EasySpawn getMainClass() {
        return instance;
    }
}

