/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.Core;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.scoreboard.ScoreboardManager;

public class GameLoop {
    Core core;
    int count = 0;
    int keep = 0;
    boolean lever = true;
    int i = 0;

    public GameLoop(Core core) {
        this.core = core;
    }

    public void tick() throws IOException {
        block16: {
            ChatColor c;
            Sign s;
            block15: {
                this.restock();
                ++this.count;
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (this.core.getMap(p) != null) {
                        if (!this.core.running.contains(this.core.getMap(p))) continue;
                        this.core.scoreboard(this.core.getMap(p));
                        if (this.count != 10 || this.core.starting.contains(this.core.getMap(p))) continue;
                        ItemStack is = new ItemStack(Material.EGG, 1);
                        ItemMeta im = is.getItemMeta();
                        im.setDisplayName(ChatColor.WHITE + ChatColor.BOLD + "Magic Egg");
                        is.setItemMeta(im);
                        p.getInventory().addItem(new ItemStack[]{is});
                        continue;
                    }
                    ScoreboardManager sm = Bukkit.getServer().getScoreboardManager();
                    p.setScoreboard(sm.getNewScoreboard());
                }
                if (this.count == 10) {
                    this.count = 0;
                }
                if (!this.core.getValue("signanimation")) break block15;
                for (Location loc : this.core.getSigns()) {
                    if (loc.getBlock().getType() != Material.WALL_SIGN && loc.getBlock().getType() != Material.SIGN && loc.getBlock().getType() != Material.SIGN_POST) continue;
                    s = (Sign)loc.getBlock().getState();
                    if (this.lever) {
                        ++this.keep;
                        if (this.keep == 60) {
                            this.keep = 50;
                            this.lever = false;
                        }
                    } else {
                        --this.keep;
                        if (this.keep == -1) {
                            this.keep = 0;
                            this.lever = true;
                        }
                    }
                    c = ChatColor.AQUA;
                    if (this.keep > 0 && this.keep < 11) {
                        c = ChatColor.AQUA;
                    }
                    if (this.keep > 10 && this.keep < 21) {
                        c = ChatColor.DARK_AQUA;
                    }
                    if (this.keep > 20 && this.keep < 31) {
                        c = ChatColor.DARK_BLUE;
                    }
                    if (this.keep > 30 && this.keep < 41) {
                        c = ChatColor.BLUE;
                    }
                    if (this.keep > 40 && this.keep < 51) {
                        c = ChatColor.LIGHT_PURPLE;
                    }
                    if (this.keep > 50) {
                        c = ChatColor.DARK_PURPLE;
                    }
                    s.setLine(0, c + ChatColor.BOLD + "[" + this.core.getName() + "]");
                    s.update();
                }
                break block16;
            }
            if (this.i != 0) break block16;
            ++this.i;
            for (Location loc : this.core.getSigns()) {
                if (loc.getBlock().getType() != Material.WALL_SIGN && loc.getBlock().getType() != Material.SIGN && loc.getBlock().getType() != Material.SIGN_POST) continue;
                s = (Sign)loc.getBlock().getState();
                c = ChatColor.AQUA;
                s.setLine(0, c + ChatColor.BOLD + "[" + this.core.getName() + "]");
                s.update();
            }
        }
    }

    public String getRandomMap() throws IOException {
        ArrayList<String> all = this.core.getMaps();
        if (all.isEmpty()) {
            return "No Map Available";
        }
        Collections.shuffle(all);
        for (String s : all) {
            if (this.core.contains(s)) continue;
            this.core.add(s);
            return s;
        }
        return "No Map Available";
    }

    public void restock() throws IOException {
        for (Location loc : this.core.getSigns()) {
            ChatColor c;
            int current;
            int max;
            String map;
            if (loc.getBlock().getType() != Material.WALL_SIGN && loc.getBlock().getType() != Material.SIGN && loc.getBlock().getType() != Material.SIGN_POST) continue;
            Sign s = (Sign)loc.getBlock().getState();
            if (ChatColor.stripColor((String)s.getLine(1)).equalsIgnoreCase("Loading...")) {
                map = this.getRandomMap();
                s.setLine(1, ChatColor.GRAY + ChatColor.BOLD + map);
                max = this.core.getMaxPlayerCount(map);
                current = this.core.getUsers(map);
                c = null;
                if (current >= max) {
                    c = ChatColor.RED;
                }
                if (current == max - 1) {
                    c = ChatColor.YELLOW;
                }
                if (current < max - 1) {
                    c = ChatColor.GREEN;
                }
                s.setLine(3, ChatColor.DARK_GRAY + "[" + c + current + "/" + max + ChatColor.DARK_GRAY + "]");
                s.update();
                continue;
            }
            if (!this.core.getMaps().contains(ChatColor.stripColor((String)s.getLine(1)))) continue;
            map = ChatColor.stripColor((String)s.getLine(1));
            max = this.core.getMaxPlayerCount(map);
            current = this.core.getUsers(map);
            c = null;
            if (current >= max) {
                c = ChatColor.RED;
            }
            if (current == max - 1) {
                c = ChatColor.YELLOW;
            }
            if (current < max - 1) {
                c = ChatColor.GREEN;
            }
            if (c == ChatColor.RED) {
                s.setLine(2, c + "Full");
            }
            if (c == ChatColor.YELLOW) {
                s.setLine(2, c + "Almost Full");
            }
            if (c == ChatColor.GREEN) {
                s.setLine(2, c + "Click to Join");
            }
            if (this.core.isStarting(map)) {
                s.setLine(2, ChatColor.DARK_PURPLE + "Starting...");
            }
            if (this.core.running.contains(map)) {
                s.setLine(2, ChatColor.DARK_PURPLE + "In-game");
            }
            s.setLine(3, ChatColor.DARK_GRAY + "[" + c + current + "/" + max + ChatColor.DARK_GRAY + "]");
            s.update();
        }
    }
}

