/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.Core;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import main.CommandHandler;
import main.Mainx;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class EngineListener
implements Listener {
    Core core;
    Mainx main;
    String name;
    HashMap<String, Integer> getCost = new HashMap();
    ArrayList<String> holds = new ArrayList();
    public HashMap<String, ArrayList<String>> spectators = new HashMap();
    public HashMap<String, String> getmap = new HashMap();
    public HashMap<String, ArrayList<Chicken>> despawn = new HashMap();

    public EngineListener(Core core, Mainx main) {
        this.core = core;
        this.name = core.getName();
        this.main = main;
    }

    @EventHandler
    public void remove(BlockBreakEvent event) throws IOException {
        if (this.core.getSigns().contains(event.getBlock().getLocation())) {
            this.core.removeSign(event.getBlock().getLocation());
            if ((event.getBlock().getType() == Material.WALL_SIGN || event.getBlock().getType() == Material.SIGN || event.getBlock().getType() == Material.SIGN_POST) && (event.getPlayer().isOp() || event.getPlayer().hasPermission(String.valueOf(this.core.getName()) + ".removeSign"))) {
                Sign s = (Sign)event.getBlock().getState();
                String map = ChatColor.stripColor((String)s.getLine(1));
                this.core.remove(map);
            }
        }
    }

    @EventHandler
    public void thr(PlayerDropItemEvent event) throws IOException {
        if (this.core.getMap(event.getPlayer()) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void hit1(EntityDamageByEntityEvent event) {
        if (event.getEntity() instanceof Player && event.getDamager() instanceof Projectile) {
            Player p = (Player)((Projectile)event.getDamager()).getShooter();
            if (p.equals(event.getEntity())) {
                event.setCancelled(true);
            } else if (event.getDamager().getType() == EntityType.ARROW) {
                event.getEntity().setVelocity(new Vector(0.0, event.getEntity().getVelocity().getY() - 7.0, 0.0));
            }
        }
    }

    @EventHandler
    public void th(ProjectileLaunchEvent event) throws IOException {
        if (event.getEntity().getShooter() instanceof Player) {
            Player p = (Player)event.getEntity().getShooter();
            if (event.getEntity().getType() == EntityType.EGG && this.core.getMap(p) != null) {
                String map = this.core.getMap(p);
                if (this.core.inStartup.contains(map)) {
                    event.setCancelled(true);
                } else {
                    event.getEntity().teleport(new Location(p.getWorld(), p.getLocation().getX(), p.getLocation().getY() - 1.0, p.getLocation().getZ()));
                    event.getEntity().setVelocity(new Vector(event.getEntity().getVelocity().getX(), -10.0, event.getEntity().getVelocity().getZ()));
                    this.trail(p, (Entity)event.getEntity());
                }
            }
        }
    }

    public void trail(final Player p, final Entity e) throws IOException {
        if (!e.isDead()) {
            if (this.core.getStat(p, "25") == 1) {
                e.getWorld().spawnParticle(Particle.CLOUD, e.getLocation(), 10);
            }
            if (this.core.getStat(p, "50") == 1) {
                e.getWorld().spawnParticle(Particle.REDSTONE, e.getLocation(), 10);
            }
            if (this.core.getStat(p, "150") == 1) {
                e.getWorld().spawnParticle(Particle.CRIT_MAGIC, e.getLocation(), 10);
            }
            if (this.core.getStat(p, "250") == 1) {
                e.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, e.getLocation(), 10);
            }
            this.main.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.main, new Runnable(){

                @Override
                public void run() {
                    try {
                        EngineListener.this.trail(p, e);
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }, 1L);
        }
    }

    @EventHandler
    public void f(PlayerInteractEvent event) throws IOException {
        if (event.getItem() != null && event.getItem().getType() == Material.EGG) {
            if (this.core.getMap(event.getPlayer()) != null) {
                this.core.addStat(event.getPlayer(), "egg");
                if (this.core.starting.contains(this.core.getMap(event.getPlayer()))) {
                    event.setCancelled(true);
                }
            }
            if (event.getItem().hasItemMeta() && event.getItem().getItemMeta().hasDisplayName()) {
                if (event.getItem().getItemMeta().getDisplayName().equalsIgnoreCase(ChatColor.WHITE + ChatColor.BOLD + ">5 Eggs<")) {
                    event.setCancelled(true);
                }
                if (event.getItem().getItemMeta().getDisplayName().equalsIgnoreCase(ChatColor.WHITE + ChatColor.BOLD + "-5 Eggs<")) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void noHunger(FoodLevelChangeEvent event) throws IOException {
        for (String s : this.core.getMaps()) {
            if (!(event.getEntity() instanceof Player) || !this.spectators.get(s).contains(event.getEntity().getName())) continue;
            event.setCancelled(true);
        }
        if (event.getEntity() instanceof Player && this.core.getMap((Player)event.getEntity()) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void teleport(EntityTeleportEvent event) throws IOException {
        if (!(event.getTo().getBlockX() - event.getFrom().getBlockX() <= 20 && event.getTo().getBlockX() - event.getFrom().getBlockX() >= -20 || event.getTo().getBlockZ() - event.getFrom().getBlockZ() <= 20 && event.getTo().getBlockZ() - event.getFrom().getBlockZ() >= -20)) {
            for (String s : this.core.getMaps()) {
                if (!this.spectators.containsKey(s) || !this.spectators.get(s).contains(event.getEntity().getName())) continue;
                event.setCancelled(true);
            }
            if (event.getEntity() instanceof Player && this.core.getMap((Player)event.getEntity()) != null) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void leave(PlayerQuitEvent event) throws IOException {
        for (String s : this.core.getMaps()) {
            if (!this.spectators.containsKey(s) || !this.spectators.get(s).contains(event.getPlayer().getName()) || !this.getmap.containsKey(event.getPlayer())) continue;
            Player d = event.getPlayer();
            d.getInventory().clear();
            this.core.getInven(d);
            if (this.holds.contains(d.getName())) {
                this.holds.remove(d.getName());
            }
            d.setAllowFlight(false);
            d.setFlying(false);
            d.teleport(this.core.getReturnLoc());
            d.setFallDistance(0.0f);
            for (Object r : Bukkit.getOnlinePlayers()) {
                if (d == r) continue;
                r.showPlayer(d);
            }
            this.remove(this.getmap.get(d.getName()), d);
            this.getmap.remove(d.getName());
        }
        if (this.core.getMap(event.getPlayer()) != null) {
            if (this.core.running.contains(this.core.getMap(event.getPlayer()))) {
                Player p = event.getPlayer();
                p.teleport(this.core.getReturnLoc());
                this.core.setUsers(this.core.getMap(p), this.core.getUsers(this.core.getMap(p)) - 1);
                this.core.addStat(p, "died");
                p.getInventory().clear();
                p.setFallDistance(0.0f);
                this.core.getInven(p);
                this.holds.remove(p.getName());
                String map = this.core.getMap(p);
                this.core.removePlayerFromArray(p, map);
                if (this.core.getUserArray(map).isEmpty()) {
                    this.core.running.remove(map);
                    for (Location loc : this.core.getSigns()) {
                        Sign s;
                        if (loc.getBlock().getType() != Material.WALL_SIGN && loc.getBlock().getType() != Material.SIGN && loc.getBlock().getType() != Material.SIGN_POST || !(s = (Sign)loc.getBlock().getState()).getLine(1).equalsIgnoreCase(ChatColor.GRAY + ChatColor.BOLD + map)) continue;
                        this.core.remove(map);
                        s.setLine(1, ChatColor.YELLOW + "Loading...");
                        s.update();
                    }
                } else if (this.core.getUserArray(map).size() == 1) {
                    String s = this.core.getUserArray(map).get(0);
                    Player q = Bukkit.getPlayer((String)s);
                    this.core.setUsers(this.core.getMap(q), 0);
                    q.getInventory().clear();
                    this.core.getInven(q);
                    if (this.core.getReward(map) != null) {
                        q.sendTitle(ChatColor.GREEN + "You won!", ChatColor.GRAY + "You have been awarded", 30, 30, 30);
                        this.core.addStat(q, "win");
                        ItemStack[] itemStackArray = this.core.getReward(map).getBlockInventory().getContents();
                        int n = itemStackArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ItemStack is = itemStackArray[n2];
                            if (is != null && is.getType() != Material.AIR) {
                                q.getInventory().addItem(new ItemStack[]{is});
                            }
                            ++n2;
                        }
                    } else {
                        q.sendTitle(ChatColor.GREEN + "You won!", "" + ChatColor.GRAY, 30, 30, 30);
                        this.core.addStat(q, "win");
                    }
                    this.core.addTokens(q, 3);
                    this.core.removePlayerFromArray(q, map);
                    this.core.running.remove(map);
                    q.teleport(this.core.getReturnLoc());
                    q.setFallDistance(0.0f);
                    for (Location loc : this.core.getSigns()) {
                        Sign s1;
                        if (loc.getBlock().getType() != Material.WALL_SIGN && loc.getBlock().getType() != Material.SIGN && loc.getBlock().getType() != Material.SIGN_POST || !(s1 = (Sign)loc.getBlock().getState()).getLine(1).equalsIgnoreCase(ChatColor.GRAY + ChatColor.BOLD + map)) continue;
                        this.core.remove(map);
                        s1.setLine(1, ChatColor.YELLOW + "Loading...");
                        s1.update();
                    }
                }
            } else {
                this.core.removeFromLobby(event.getPlayer());
            }
        }
    }

    public ItemStack getItem(Material m, String display, int value) {
        ItemStack is = new ItemStack(m);
        ItemMeta im = is.getItemMeta();
        im.setDisplayName(ChatColor.GRAY + display + ": " + ChatColor.GOLD + value);
        is.setItemMeta(im);
        return is;
    }

    public void stats(Player p) throws IOException {
        Inventory inv = Bukkit.createInventory((InventoryHolder)p, (int)54, (String)(ChatColor.GOLD + ChatColor.BOLD + "EggSmash Stats"));
        inv.setItem(10, this.getItem(Material.EGG, "Eggs Thrown", this.core.getStat(p, "egg")));
        inv.setItem(12, this.getItem(Material.PISTON_BASE, "Powerups Gained", this.core.getStat(p, "powerup")));
        inv.setItem(14, this.getItem(Material.SKULL_ITEM, "Deaths", this.core.getStat(p, "died")));
        inv.setItem(16, this.getItem(Material.EXP_BOTTLE, "Wins", this.core.getStat(p, "win")));
        inv.setItem(31, this.getItem(Material.FEATHER, "Games Played", this.core.getStat(p, "play")));
        p.openInventory(inv);
    }

    @EventHandler
    public void clicker(InventoryClickEvent event) throws IOException {
        Player pa = (Player)event.getWhoClicked();
        if (this.getmap.containsKey(pa.getName()) && this.spectators.get(this.getmap.get(pa.getName())).contains(pa.getName())) {
            event.setCancelled(true);
        }
        if (this.core.getMap((Player)event.getWhoClicked()) != null) {
            event.setCancelled(true);
        }
        if (event.getInventory().getTitle().equalsIgnoreCase(ChatColor.GOLD + ChatColor.BOLD + "EggSmash Stats")) {
            event.setCancelled(true);
        }
        if (event.getInventory().getTitle().equalsIgnoreCase(ChatColor.GOLD + ChatColor.BOLD + "EggShop")) {
            event.setCancelled(true);
            if (event.getCurrentItem() != null && event.getCurrentItem().hasItemMeta() && event.getCurrentItem().getItemMeta().hasLore() && ((String)event.getCurrentItem().getItemMeta().getLore().get(0)).contains(ChatColor.GRAY + "Cost: ")) {
                String[] parts = ((String)event.getCurrentItem().getItemMeta().getLore().get(0)).split(" ");
                int cost = Integer.parseInt(parts[1]);
                Player p = (Player)event.getWhoClicked();
                if (this.core.getTokens(p) >= cost) {
                    this.confirm(p, cost);
                } else {
                    p.playSound(p.getLocation(), Sound.BLOCK_ANVIL_FALL, 1.0f, 1.0f);
                }
            }
        }
        if (event.getInventory().getTitle().equalsIgnoreCase(ChatColor.GOLD + ChatColor.BOLD + "Confirmation")) {
            event.setCancelled(true);
            if (event.getCurrentItem() != null && event.getCurrentItem().getType() == Material.WOOL) {
                if (event.getSlot() == 1) {
                    this.core.addTokens((Player)event.getWhoClicked(), this.getCost.get(event.getWhoClicked().getName()) * -1);
                    this.core.setStat((Player)event.getWhoClicked(), "" + this.getCost.get(event.getWhoClicked().getName()));
                    event.getWhoClicked().closeInventory();
                    CommandHandler.shop((Player)event.getWhoClicked());
                } else if (event.getSlot() == 7) {
                    event.getWhoClicked().closeInventory();
                    CommandHandler.shop((Player)event.getWhoClicked());
                }
            }
        }
    }

    public void confirm(Player p, int cost) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)p, (int)9, (String)(ChatColor.GOLD + ChatColor.BOLD + "Confirmation"));
        inv.setItem(1, new ItemStack(Material.WOOL, 1, 5));
        inv.setItem(7, new ItemStack(Material.WOOL, 1, 14));
        this.getCost.put(p.getName(), cost);
        p.openInventory(inv);
    }

    @EventHandler
    public void close(InventoryCloseEvent event) {
        if (event.getInventory().getTitle().equalsIgnoreCase(ChatColor.GOLD + ChatColor.BOLD + "EggShop")) {
            CommandHandler.link.remove(event.getPlayer().getName());
        }
    }

    @EventHandler
    public void click(PlayerInteractEvent event) throws IOException {
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.RIGHT_CLICK_AIR) {
            if (event.getItem() != null && event.getItem().getType() != Material.AIR) {
                if (event.getItem().getType() == Material.BED && this.core.getMap(event.getPlayer()) != null) {
                    event.setCancelled(true);
                    this.core.removeFromLobby(event.getPlayer());
                    this.core.getInven(event.getPlayer());
                }
                if (event.getItem().getType() == Material.WRITTEN_BOOK && this.core.getMap(event.getPlayer()) != null) {
                    event.setCancelled(true);
                    this.stats(event.getPlayer());
                }
            }
            if (event.getClickedBlock() != null && (event.getClickedBlock().getType() == Material.WALL_SIGN || event.getClickedBlock().getType() == Material.SIGN || event.getClickedBlock().getType() == Material.SIGN_POST)) {
                event.setCancelled(true);
                this.holds.remove(event.getPlayer().getName());
                for (Player q : Bukkit.getOnlinePlayers()) {
                    q.showPlayer(event.getPlayer());
                }
                Sign s = (Sign)event.getClickedBlock().getState();
                String map = ChatColor.stripColor((String)s.getLine(1));
                if (this.core.getGroundLevel(map) != -1) {
                    int max = this.core.getMaxPlayerCount(map);
                    int current = this.core.getUsers(map);
                    if (current < max) {
                        this.core.setInven(event.getPlayer());
                        this.core.sendToLobby(event.getPlayer(), map);
                    } else {
                        event.getPlayer().playSound(event.getPlayer().getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, 1.0f, 1.0f);
                    }
                } else {
                    this.core.error("User attempted to join game while the floor level hasn't been set yet.");
                }
            }
        }
    }

    @EventHandler
    public void nochickens(PlayerEggThrowEvent event) throws IOException {
        Player p = event.getPlayer();
        if (this.core.getMap(p) != null) {
            event.setHatching(false);
        }
    }

    @EventHandler
    public void interact(PlayerInteractEvent event) throws IOException {
        if ((event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) && event.getItem() != null && event.getItem().hasItemMeta() && event.getItem().getItemMeta().hasDisplayName()) {
            Object im;
            ItemStack is;
            final Player p = event.getPlayer();
            boolean b = false;
            if (event.getItem().getItemMeta().getDisplayName().equalsIgnoreCase(ChatColor.WHITE + ChatColor.BOLD + "-Mega bow<")) {
                b = true;
                p.getInventory().setItem(4, null);
                is = new ItemStack(Material.BOW, 1);
                im = is.getItemMeta();
                im.setDisplayName(ChatColor.WHITE + ChatColor.BOLD + "Egg Bow");
                im.setUnbreakable(true);
                im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
                im.addEnchant(Enchantment.ARROW_INFINITE, 1, false);
                im.addEnchant(Enchantment.ARROW_FIRE, 1, false);
                im.addEnchant(Enchantment.ARROW_KNOCKBACK, 2, false);
                is.setItemMeta((ItemMeta)im);
                p.getInventory().setItem(17, new ItemStack(Material.ARROW, 1));
                p.getInventory().setItem(8, is);
                p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_ATTACK_STRONG, 2.0f, 2.0f);
                this.main.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.main, new Runnable(){

                    @Override
                    public void run() {
                        p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_ATTACK_WEAK, 2.0f, 0.5f);
                        ItemStack is = new ItemStack(Material.BOW, 1);
                        ItemMeta im = is.getItemMeta();
                        im.setDisplayName(ChatColor.WHITE + ChatColor.BOLD + "Egg Bow");
                        im.setUnbreakable(true);
                        im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
                        im.addEnchant(Enchantment.ARROW_INFINITE, 1, false);
                        is.setItemMeta(im);
                        p.getInventory().setItem(17, new ItemStack(Material.ARROW, 1));
                        p.getInventory().setItem(8, is);
                        EngineListener.this.holds.remove(p.getName());
                    }
                }, 200L);
            }
            if (event.getItem().getItemMeta().getDisplayName().equalsIgnoreCase(ChatColor.WHITE + ChatColor.BOLD + "-Chicken Uprising<")) {
                b = true;
                p.getInventory().setItem(4, null);
                if (this.despawn.containsKey(this.core.getMap(p))) {
                    for (Chicken c : this.despawn.get(this.core.getMap(p))) {
                        c.setVelocity(new Vector(0, 3, 0));
                        c.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 200, 1));
                    }
                }
                this.holds.remove(p.getName());
            }
            if (event.getItem().getItemMeta().getDisplayName().equalsIgnoreCase(ChatColor.WHITE + ChatColor.BOLD + "-5 Eggs<")) {
                b = true;
                p.getInventory().setItem(4, null);
                is = new ItemStack(Material.EGG, 5);
                im = is.getItemMeta();
                im.setDisplayName(ChatColor.WHITE + ChatColor.BOLD + "Magic Egg");
                is.setItemMeta((ItemMeta)im);
                p.getInventory().addItem(new ItemStack[]{is});
                p.playSound(p.getLocation(), Sound.ENTITY_CHICKEN_EGG, 2.0f, 1.2f);
                this.holds.remove(p.getName());
            }
            if (event.getItem().getItemMeta().getDisplayName().equalsIgnoreCase(ChatColor.WHITE + ChatColor.BOLD + "-Downforce<")) {
                b = true;
                p.getInventory().setItem(4, null);
                String map = this.core.getMap(p);
                for (String s : this.core.getUserArray(map)) {
                    if (s.equalsIgnoreCase(p.getName())) continue;
                    Bukkit.getPlayer((String)s).setVelocity(new Vector(0, -3, 0));
                }
                this.holds.remove(p.getName());
            }
            if (event.getItem().getItemMeta().getDisplayName().equalsIgnoreCase(ChatColor.WHITE + ChatColor.BOLD + "-Boost<")) {
                b = true;
                p.getInventory().setItem(4, null);
                p.setVelocity(new Vector(0, 10, 0));
                this.holds.remove(p.getName());
            }
            if (event.getItem().getItemMeta().getDisplayName().equalsIgnoreCase(ChatColor.WHITE + ChatColor.BOLD + "-Extra Life<")) {
                b = true;
                p.getInventory().setItem(4, null);
                if (this.core.getLife(p) > this.core.getMapLife(this.core.getMap(p)) + 2) {
                    p.playSound(p.getLocation(), Sound.BLOCK_ANVIL_BREAK, 1.0f, 1.0f);
                    this.randomPowerup(p, 200, null);
                } else {
                    this.holds.remove(p.getName());
                    this.core.setLife(p, this.core.getLife(p) + 1);
                    p.playSound(p.getLocation(), Sound.BLOCK_ANVIL_USE, 1.0f, 1.0f);
                }
            }
            if (event.getItem().getItemMeta().getDisplayName().equalsIgnoreCase(ChatColor.WHITE + ChatColor.BOLD + "-Chicken Bomb<")) {
                b = true;
                p.getInventory().setItem(4, null);
                this.holds.remove(p.getName());
                int x = -4;
                while (x < 4) {
                    int z = -4;
                    while (z < 4) {
                        Chicken c = (Chicken)p.getWorld().spawnEntity(p.getLocation(), EntityType.CHICKEN);
                        c.setCustomName(ChatColor.WHITE + ChatColor.BOLD + "Hatched Chicken");
                        c.setCustomNameVisible(true);
                        c.setVelocity(new Vector(x, -4, z));
                        this.addChick(c, this.core.getMap(p));
                        z += 2;
                    }
                    x += 2;
                }
            }
            if (event.getItem().getItemMeta().getDisplayName().equalsIgnoreCase(ChatColor.WHITE + ChatColor.BOLD + "-Sidekick<")) {
                b = true;
                p.getInventory().setItem(4, null);
                this.holds.remove(p.getName());
                String map = this.core.getMap(p);
                Random r = new Random();
                if (this.core.getUserArray(map) != null && !this.core.getUserArray(map).isEmpty()) {
                    for (String user : this.core.getUserArray(map)) {
                        if (user.equalsIgnoreCase(p.getName())) continue;
                        Bukkit.getPlayer((String)user).setVelocity(new Vector((double)(r.nextInt(6) - 3), Bukkit.getPlayer((String)user).getVelocity().getY(), (double)(r.nextInt(6) - 3)));
                    }
                }
            }
            if (event.getItem().getItemMeta().getDisplayName().equalsIgnoreCase(ChatColor.WHITE + ChatColor.BOLD + "-Ink Splash<")) {
                b = true;
                p.getInventory().setItem(4, null);
                String map = this.core.getMap(p);
                this.holds.remove(p.getName());
                if (this.core.getUserArray(map) != null && !this.core.getUserArray(map).isEmpty()) {
                    for (String user : this.core.getUserArray(map)) {
                        if (user.equalsIgnoreCase(p.getName())) continue;
                        this.smoke(p, 100);
                    }
                }
            }
            if (event.getItem().getItemMeta().getDisplayName().equalsIgnoreCase(ChatColor.WHITE + ChatColor.BOLD + "-Nausea<")) {
                b = true;
                p.getInventory().setItem(4, null);
                String map = this.core.getMap(p);
                this.holds.remove(p.getName());
                if (this.core.getUserArray(map) != null && !this.core.getUserArray(map).isEmpty()) {
                    for (String user : this.core.getUserArray(map)) {
                        if (user.equalsIgnoreCase(p.getName())) continue;
                        Bukkit.getPlayer((String)user).addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, 5, 1, true));
                    }
                }
            }
            if (b) {
                p.playSound(p.getLocation(), Sound.ENTITY_WITHER_SHOOT, 1.0f, 1.0f);
                String map = this.core.getMap(p);
                if (this.core.getUserArray(map) != null && !this.core.getUserArray(map).isEmpty()) {
                    for (String user : this.core.getUserArray(map)) {
                        Player q = Bukkit.getPlayer((String)user);
                        String display = this.getNamex(p);
                        q.sendMessage(ChatColor.RED + ChatColor.BOLD + ">>>Powerup>>>" + ChatColor.YELLOW + display + ChatColor.YELLOW + " used " + ChatColor.stripColor((String)event.getItem().getItemMeta().getDisplayName()).replace("-", "").replace(">", "") + "!");
                    }
                }
            }
        }
    }

    public String getNamex(Player p) throws IOException {
        int alternate = 0;
        String display = p.getName();
        String name = "";
        int i = 0;
        while (i < display.length()) {
            char c = display.charAt(i);
            if (alternate == 0) {
                if (this.core.getStat(p, "135") == 1) {
                    name = String.valueOf(name) + ChatColor.BLUE + c;
                } else if (this.core.getStat(p, "35") == 1) {
                    name = String.valueOf(name) + ChatColor.GREEN + c;
                } else if (this.core.getStat(p, "435") == 1) {
                    name = String.valueOf(name) + ChatColor.GOLD + c;
                }
                ++alternate;
            } else if (alternate == 1) {
                if (this.core.getStat(p, "435") == 1) {
                    name = String.valueOf(name) + ChatColor.GOLD + c;
                } else if (this.core.getStat(p, "135") == 1) {
                    name = String.valueOf(name) + ChatColor.BLUE + c;
                } else if (this.core.getStat(p, "35") == 1) {
                    name = String.valueOf(name) + ChatColor.GREEN + c;
                }
                ++alternate;
            } else if (alternate == 2) {
                if (this.core.getStat(p, "35") == 1) {
                    name = String.valueOf(name) + ChatColor.GREEN + c;
                } else if (this.core.getStat(p, "435") == 1) {
                    name = String.valueOf(name) + ChatColor.GOLD + c;
                } else if (this.core.getStat(p, "135") == 1) {
                    name = String.valueOf(name) + ChatColor.BLUE + c;
                }
                alternate = 0;
            }
            ++i;
        }
        if (name.equalsIgnoreCase("")) {
            name = p.getName();
        }
        return name;
    }

    @EventHandler
    public void test(PlayerInteractEvent event) throws IOException {
        this.getNamex(event.getPlayer());
    }

    @EventHandler
    public void noDam(EntityDamageByEntityEvent event) throws IOException {
        if (event.getEntity() instanceof Player && event.getDamager() instanceof Player && this.core.getMap((Player)event.getEntity()) != null && this.core.getMap((Player)event.getDamager()) != null) {
            event.setCancelled(true);
        }
    }

    public ItemStack getRandom() {
        ArrayList<ItemStack> isl = new ArrayList<ItemStack>();
        if (this.core.getValue("bow")) {
            ItemStack is = new ItemStack(Material.BOW, 1);
            ItemMeta im = is.getItemMeta();
            im.setDisplayName(ChatColor.WHITE + ChatColor.BOLD + ">Mega bow<");
            is.setItemMeta(im);
            isl.add(is);
        }
        ItemStack is1 = new ItemStack(Material.FEATHER, 1);
        ItemMeta im1 = is1.getItemMeta();
        im1.setDisplayName(ChatColor.WHITE + ChatColor.BOLD + ">Chicken Uprising<");
        is1.setItemMeta(im1);
        isl.add(is1);
        ItemStack is11 = new ItemStack(Material.EGG, 1);
        ItemMeta im11 = is11.getItemMeta();
        im11.setDisplayName(ChatColor.WHITE + ChatColor.BOLD + ">5 Eggs<");
        is11.setItemMeta(im11);
        isl.add(is11);
        ItemStack is111 = new ItemStack(Material.PISTON_STICKY_BASE, 1);
        ItemMeta im111 = is111.getItemMeta();
        im111.setDisplayName(ChatColor.WHITE + ChatColor.BOLD + ">Downforce<");
        is111.setItemMeta(im111);
        isl.add(is111);
        ItemStack is1111 = new ItemStack(Material.FIREWORK, 1);
        ItemMeta im1111 = is1111.getItemMeta();
        im1111.setDisplayName(ChatColor.WHITE + ChatColor.BOLD + ">Boost<");
        is1111.setItemMeta(im1111);
        isl.add(is1111);
        ItemStack is11111 = new ItemStack(Material.APPLE, 1);
        ItemMeta im11111 = is11111.getItemMeta();
        im11111.setDisplayName(ChatColor.WHITE + ChatColor.BOLD + ">Extra Life<");
        is11111.setItemMeta(im11111);
        isl.add(is11111);
        ItemStack is111111 = new ItemStack(Material.RAW_CHICKEN, 1);
        ItemMeta im111111 = is111111.getItemMeta();
        im111111.setDisplayName(ChatColor.WHITE + ChatColor.BOLD + ">Chicken Bomb<");
        is111111.setItemMeta(im111111);
        isl.add(is111111);
        ItemStack is1111111 = new ItemStack(Material.FLINT, 1);
        ItemMeta im1111111 = is1111111.getItemMeta();
        im1111111.setDisplayName(ChatColor.WHITE + ChatColor.BOLD + ">Sidekick<");
        is1111111.setItemMeta(im1111111);
        isl.add(is1111111);
        ItemStack is11111111 = new ItemStack(Material.INK_SACK, 1);
        ItemMeta im11111111 = is11111111.getItemMeta();
        im11111111.setDisplayName(ChatColor.WHITE + ChatColor.BOLD + ">Ink Splash<");
        is11111111.setItemMeta(im11111111);
        isl.add(is11111111);
        ItemStack is111111111 = new ItemStack(Material.ROTTEN_FLESH, 1);
        ItemMeta im111111111 = is111111111.getItemMeta();
        im111111111.setDisplayName(ChatColor.WHITE + ChatColor.BOLD + ">Nausea<");
        is111111111.setItemMeta(im111111111);
        isl.add(is111111111);
        Collections.shuffle(isl);
        return (ItemStack)isl.get(0);
    }

    public void randomPowerup(final Player p, final int recurse, ItemStack is) {
        try {
            if (recurse > 0 && this.core.getMap(p) != null) {
                p.playSound(p.getLocation(), Sound.BLOCK_NOTE_PLING, 0.4f, 1.0f);
                final ItemStack s = this.getRandom();
                p.getInventory().setItem(4, s);
                this.main.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.main, new Runnable(){

                    @Override
                    public void run() {
                        EngineListener.this.randomPowerup(p, recurse - 10, s);
                    }
                }, 3L);
            } else if (this.core.getMap(p) != null) {
                ItemStack d = is;
                ItemMeta im = is.getItemMeta();
                im.setDisplayName(im.getDisplayName().replace(">", "-"));
                d.setItemMeta(im);
                p.getInventory().setItem(4, d);
                p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 2.0f, 1.0f);
                this.core.addStat(p, "powerup");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void noMobs(CreatureSpawnEvent event) throws IOException {
        if (event.getEntity() instanceof Monster || event.getEntity() instanceof Slime) {
            boolean b = true;
            for (String map : this.core.getMaps()) {
                for (Location loc : this.core.getSpawnPoints(map)) {
                    if (!loc.getWorld().equals(event.getEntity().getWorld()) || !(loc.distance(event.getEntity().getLocation()) < 300.0)) continue;
                    b = false;
                }
            }
            if (!b) {
                event.setCancelled(true);
            }
        }
    }

    public void despawnAllOfMap(String map) {
        if (this.despawn.containsKey(map)) {
            for (Chicken c : this.despawn.get(map)) {
                c.remove();
            }
        }
    }

    @EventHandler
    public void teleport(PlayerTeleportEvent event) {
    }

    @EventHandler
    public void leave(PlayerInteractEvent event) throws IOException {
        if ((event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) && event.getItem() != null && event.getItem().getType() == Material.WATCH && this.getmap.containsKey(event.getPlayer().getName()) && this.spectators.get(this.getmap.get(event.getPlayer().getName())).contains(event.getPlayer().getName())) {
            Player d = event.getPlayer();
            d.sendMessage(ChatColor.GOLD + ChatColor.BOLD + ">>>" + ChatColor.RESET + ChatColor.ITALIC + "Sending you back to lobby");
            d.getInventory().clear();
            this.core.getInven(d);
            if (this.holds.contains(d.getName())) {
                this.holds.remove(d.getName());
            }
            d.setAllowFlight(false);
            d.setFlying(false);
            d.teleport(this.core.getReturnLoc());
            d.setFallDistance(0.0f);
            for (Player r : Bukkit.getOnlinePlayers()) {
                if (d == r) continue;
                r.showPlayer(d);
            }
            this.remove(this.getmap.get(d.getName()), d);
            this.getmap.remove(d.getName());
        }
    }

    public void add(String map, Player p) {
        ArrayList<String> old = new ArrayList<String>();
        if (this.spectators.containsKey(map)) {
            for (String s : this.spectators.get(map)) {
                old.add(s);
            }
        }
        old.add(p.getName());
        this.spectators.put(map, old);
    }

    public void remove(String map, Player p) {
        ArrayList<String> old = new ArrayList<String>();
        if (this.spectators.containsKey(map)) {
            for (String s : this.spectators.get(map)) {
                if (s.equalsIgnoreCase(p.getName())) continue;
                old.add(s);
            }
        }
        this.spectators.put(map, old);
    }

    @EventHandler
    public void damage(EntityDamageEvent event) throws IOException {
        Player p;
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            Player p2;
            if (event.getEntity() instanceof Player && this.core.getMap(p2 = (Player)event.getEntity()) != null) {
                String map;
                event.setCancelled(true);
                if (this.core.getLife(p2) == 1) {
                    p2.sendTitle(ChatColor.RED + "You died", ChatColor.GRAY + "You are out now", 30, 30, 30);
                    this.core.addStat(p2, "died");
                    ItemStack isX = new ItemStack(Material.EGG, 1);
                    ItemMeta imX = isX.getItemMeta();
                    imX.setDisplayName(ChatColor.WHITE + ChatColor.BOLD + "Magic Egg");
                    isX.setItemMeta(imX);
                    int i = 0;
                    while (i < 10) {
                        p2.getInventory().addItem(new ItemStack[]{isX});
                        ++i;
                    }
                    map = this.core.getMap(p2);
                    this.core.removePlayerFromArray(p2, map);
                    this.core.removeUser(map);
                    if (this.core.getUserArray(map).isEmpty()) {
                        p2.getInventory().clear();
                        this.core.getInven(p2);
                        this.holds.remove(p2.getName());
                        this.core.running.remove(map);
                        p2.teleport(this.core.getReturnLoc());
                        p2.setFallDistance(0.0f);
                        for (Location loc : this.core.getSigns()) {
                            Sign s;
                            if (loc.getBlock().getType() != Material.WALL_SIGN && loc.getBlock().getType() != Material.SIGN && loc.getBlock().getType() != Material.SIGN_POST || !(s = (Sign)loc.getBlock().getState()).getLine(1).equalsIgnoreCase(ChatColor.GRAY + ChatColor.BOLD + map)) continue;
                            this.core.remove(map);
                            s.setLine(1, ChatColor.YELLOW + "Loading...");
                            s.update();
                        }
                    } else if (this.core.getUserArray(map).size() == 1) {
                        int b;
                        String s = this.core.getUserArray(map).get(0);
                        Player q = Bukkit.getPlayer((String)s);
                        p2.getInventory().clear();
                        this.core.getInven(p2);
                        this.holds.remove(p2.getName());
                        this.core.running.remove(map);
                        p2.teleport(this.core.getReturnLoc());
                        p2.setFallDistance(0.0f);
                        if (this.spectators.containsKey(map)) {
                            for (String sa : this.spectators.get(map)) {
                                b = 0;
                                for (Player r : Bukkit.getOnlinePlayers()) {
                                    if (!r.getName().equalsIgnoreCase(sa)) continue;
                                    b = 1;
                                }
                                if (b == 0) continue;
                                Player d = Bukkit.getPlayer((String)sa);
                                d.getInventory().clear();
                                this.core.getInven(d);
                                this.holds.remove(d.getName());
                                d.teleport(this.core.getReturnLoc());
                                d.setFallDistance(0.0f);
                                d.setAllowFlight(false);
                                d.setFlying(false);
                                this.remove(this.getmap.get(d.getName()), d);
                                this.getmap.remove(d.getName());
                                for (Player r : Bukkit.getOnlinePlayers()) {
                                    if (d == r) continue;
                                    r.showPlayer(d);
                                }
                            }
                        }
                        this.core.setUsers(this.core.getMap(q), 0);
                        q.getInventory().clear();
                        this.core.getInven(q);
                        if (this.core.getReward(map) != null) {
                            q.sendTitle(ChatColor.GREEN + "You won!", ChatColor.GRAY + "You have been awarded", 30, 30, 30);
                            this.core.addStat(q, "win");
                            ItemStack[] itemStackArray = this.core.getReward(map).getBlockInventory().getContents();
                            b = itemStackArray.length;
                            int n = 0;
                            while (n < b) {
                                ItemStack is = itemStackArray[n];
                                if (is != null && is.getType() != Material.AIR) {
                                    q.getInventory().addItem(new ItemStack[]{is});
                                }
                                ++n;
                            }
                        } else {
                            q.sendTitle(ChatColor.GREEN + "You won!", "" + ChatColor.GRAY, 30, 30, 30);
                            this.core.addStat(q, "win");
                        }
                        this.core.removePlayerFromArray(q, map);
                        this.core.running.remove(map);
                        q.teleport(this.core.getReturnLoc());
                        q.setFallDistance(0.0f);
                        for (Location loc : this.core.getSigns()) {
                            Sign s1;
                            if (loc.getBlock().getType() != Material.WALL_SIGN && loc.getBlock().getType() != Material.SIGN && loc.getBlock().getType() != Material.SIGN_POST || !(s1 = (Sign)loc.getBlock().getState()).getLine(1).equalsIgnoreCase(ChatColor.GRAY + ChatColor.BOLD + map)) continue;
                            this.core.remove(map);
                            s1.setLine(1, ChatColor.YELLOW + "Loading...");
                            s1.update();
                        }
                    } else {
                        p2.getInventory().clear();
                        ItemStack is = new ItemStack(Material.WATCH, 1);
                        ItemMeta im = is.getItemMeta();
                        im.setDisplayName(ChatColor.WHITE + ChatColor.BOLD + "Leave");
                        is.setItemMeta(im);
                        p2.getInventory().setItem(8, is);
                        p2.setAllowFlight(true);
                        p2.setFlying(true);
                        this.add(map, p2);
                        this.getmap.put(p2.getName(), map);
                        for (Player q : Bukkit.getOnlinePlayers()) {
                            q.hidePlayer(p2);
                        }
                    }
                }
                if (this.core.getLife(p2) > 1) {
                    this.core.setLife(p2, this.core.getLife(p2) - 1);
                    ArrayList<Location> points = this.core.getSpawnPoints(this.core.getMap(p2));
                    Collections.shuffle(points);
                    Location loc = points.get(0);
                    if (this.core.getStat(p2, "275") == 1) {
                        p2.getLocation().getWorld().spawnParticle(Particle.FLAME, p2.getLocation(), 300, 3.0, 3.0, 3.0, 1.0);
                    }
                    if (this.core.getStat(p2, "375") == 1) {
                        p2.getLocation().getWorld().spawnParticle(Particle.LAVA, p2.getLocation(), 300, 3.0, 3.0, 3.0, 1.0);
                    }
                    if (this.core.getStat(p2, "775") == 1) {
                        p2.getLocation().getWorld().spawnParticle(Particle.MOB_APPEARANCE, p2.getLocation(), 1, 3.0, 3.0, 3.0, 1.0);
                    }
                    p2.teleport(new Location(loc.getWorld(), (double)loc.getBlockX(), (double)loc.getBlockY(), (double)loc.getBlockZ(), 0.0f, 90.0f));
                    p2.sendTitle(ChatColor.GRAY + "You died", "", 30, 30, 30);
                    this.core.addStat(p2, "died");
                    map = this.core.getMap(p2);
                    if (this.core.getUserArray(map) != null && !this.core.getUserArray(map).isEmpty()) {
                        for (String user : this.core.getUserArray(map)) {
                            Player q;
                            q = Bukkit.getPlayer((String)user);
                            String display = this.getNamex(p2);
                            q.sendMessage(ChatColor.GOLD + ChatColor.BOLD + ">>>Death>>>" + ChatColor.YELLOW + display + ChatColor.YELLOW + " died!");
                        }
                    }
                }
                event.setCancelled(true);
            }
        } else if (event.getEntity() instanceof Player && (this.core.getMap(p = (Player)event.getEntity()) != null || this.spectators.get(this.getmap.get(p.getName())).contains(p.getName()))) {
            event.setDamage(0.0);
        }
    }

    public void despawnAllChicks() throws IOException {
        if (!this.core.getMaps().isEmpty()) {
            for (String map : this.core.getMaps()) {
                if (this.despawn.isEmpty() || !this.despawn.containsKey(map)) continue;
                for (Chicken c : this.despawn.get(map)) {
                    if (c == null) continue;
                    c.remove();
                }
            }
        }
        for (World w : Bukkit.getWorlds()) {
            for (Entity e : w.getEntities()) {
                if (!(e instanceof Chicken) || e.getCustomName() == null || !e.getCustomName().equalsIgnoreCase(ChatColor.WHITE + "Hatched Chicken")) continue;
                e.remove();
            }
        }
    }

    public void addChick(Chicken c, String map) {
        ArrayList<Chicken> old = new ArrayList<Chicken>();
        if (this.despawn.containsKey(map)) {
            for (Chicken e : this.despawn.get(map)) {
                old.add(e);
            }
        }
        old.add(c);
        this.despawn.put(map, old);
    }

    public static void spawnRandomFirework(Location loc) {
        Firework firework = (Firework)loc.getWorld().spawnEntity(loc, EntityType.FIREWORK);
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        Random random = new Random();
        FireworkEffect effect = FireworkEffect.builder().flicker(random.nextBoolean()).withColor(EngineListener.getColor(random.nextInt(17) + 1)).withFade(EngineListener.getColor(random.nextInt(17) + 1)).with(FireworkEffect.Type.values()[random.nextInt(FireworkEffect.Type.values().length)]).trail(random.nextBoolean()).build();
        fireworkMeta.addEffect(effect);
        fireworkMeta.setPower(random.nextInt(2) + 1);
        firework.setFireworkMeta(fireworkMeta);
    }

    private static Color getColor(int i) {
        switch (i) {
            case 1: {
                return Color.AQUA;
            }
            case 2: {
                return Color.BLACK;
            }
            case 3: {
                return Color.BLUE;
            }
            case 4: {
                return Color.FUCHSIA;
            }
            case 5: {
                return Color.GRAY;
            }
            case 6: {
                return Color.GREEN;
            }
            case 7: {
                return Color.LIME;
            }
            case 8: {
                return Color.MAROON;
            }
            case 9: {
                return Color.NAVY;
            }
            case 10: {
                return Color.OLIVE;
            }
            case 11: {
                return Color.ORANGE;
            }
            case 12: {
                return Color.PURPLE;
            }
            case 13: {
                return Color.RED;
            }
            case 14: {
                return Color.SILVER;
            }
            case 15: {
                return Color.TEAL;
            }
            case 16: {
                return Color.WHITE;
            }
            case 17: {
                return Color.YELLOW;
            }
        }
        return null;
    }

    public void smoke(final Player p, final int recurse) {
        if (recurse > 0) {
            p.getWorld().playEffect(p.getLocation(), Effect.SMALL_SMOKE, 100);
            this.main.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.main, new Runnable(){

                @Override
                public void run() {
                    EngineListener.this.smoke(p, recurse - 1);
                }
            }, 1L);
        }
    }

    public void redo(final Location loc) {
        final Material m = loc.getBlock().getType();
        final Byte b = loc.getBlock().getData();
        loc.getBlock().setType(Material.WOOL);
        Random r = new Random();
        loc.getBlock().setData((byte)r.nextInt(10));
        int i = 10;
        while (i < 1000) {
            this.main.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.main, new Runnable(){

                @Override
                public void run() {
                    loc.getBlock().setType(m);
                    loc.getBlock().setData(b.byteValue());
                }
            }, (long)i);
            i += 10;
        }
    }

    @EventHandler
    public void hit(ProjectileHitEvent event) throws IOException {
        Player p;
        if (event.getEntity() != null && event.getEntity().getShooter() instanceof Player && this.core.getMap(p = (Player)event.getEntity().getShooter()) != null) {
            String map;
            if (this.core.getStat(p, "75") == 1) {
                event.getEntity().getWorld().spawnParticle(Particle.EXPLOSION_HUGE, event.getEntity().getLocation(), 1);
                event.getEntity().getWorld().playSound(event.getEntity().getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
            }
            if (this.core.getStat(p, "125") == 1) {
                EngineListener.spawnRandomFirework(event.getEntity().getLocation());
            }
            if (this.core.getStat(p, "200") == 1 && event.getHitBlock() != null) {
                this.redo(event.getHitBlock().getLocation());
            }
            if (this.core.getStat(p, "500") == 1) {
                event.getEntity().getLocation().getWorld().strikeLightningEffect(event.getEntity().getLocation());
            }
            if (this.core.getGroundLevel(map = this.core.getMap(p)) != -1) {
                int y = event.getHitBlock().getLocation().getBlockY();
                if (event.getHitEntity() == null && event.getHitBlock() != null && event.getHitBlock().getY() - y < 2 && event.getEntity() instanceof Egg) {
                    int py = p.getLocation().getBlockY();
                    double distance = py - y;
                    double vel = 100.0 - distance * 2.0;
                    if (vel <= 0.0) {
                        vel = 1.0;
                    }
                    p.setVelocity(new Vector(0.0, vel / 10.0, 0.0));
                    if (distance < 5.0 && this.core.getValue("powerups") && !this.holds.contains(p.getName())) {
                        this.holds.add(p.getName());
                        float i = 2.0f;
                        while (i > 0.0f) {
                            p.playSound(p.getLocation(), Sound.ENTITY_CHICKEN_HURT, 2.0f, i);
                            i -= 0.2f;
                        }
                        this.main.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.main, new Runnable(){

                            @Override
                            public void run() {
                                EngineListener.this.randomPowerup(p, 200, null);
                            }
                        }, 5L);
                    }
                }
            }
        }
    }

    @EventHandler
    public void sign(SignChangeEvent event) throws IOException {
        if (event.getLine(0).equalsIgnoreCase("[" + this.name + "]") && (event.getPlayer().isOp() || event.getPlayer().hasPermission(String.valueOf(this.name) + ".createSign"))) {
            event.setCancelled(true);
            Sign s = (Sign)event.getBlock().getState();
            s.setLine(0, ChatColor.AQUA + ChatColor.BOLD + "[" + this.name + "]");
            s.setLine(1, ChatColor.YELLOW + "Loading...");
            s.update();
            this.core.addSign(event.getBlock().getLocation());
        }
    }
}

