/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.Core;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import main.Mainx;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DataHandler {
    Mainx main;
    Core core;
    HashMap<ItemStack, Integer> spot = new HashMap();

    public DataHandler(Mainx main, Core core) {
        this.main = main;
        this.core = core;
    }

    public ArrayList<Location> getSigns() throws IOException {
        ArrayList<Location> locs = new ArrayList<Location>();
        BufferedReader br = this.getDataReader(this.getDataFile("Signs"));
        String line = br.readLine();
        while (line != null) {
            String[] parts = line.split(" ");
            boolean b = false;
            for (World w : Bukkit.getWorlds()) {
                if (!w.getName().equalsIgnoreCase(parts[0])) continue;
                b = true;
            }
            if (b) {
                World w;
                w = Bukkit.getWorld((String)parts[0]);
                int x = Integer.parseInt(parts[1]);
                int y = Integer.parseInt(parts[2]);
                int z = Integer.parseInt(parts[3]);
                locs.add(new Location(w, (double)x, (double)y, (double)z));
            }
            line = br.readLine();
        }
        return locs;
    }

    public void setReturnLoc(Location loc) throws IOException {
        BufferedWriter bw = this.getDataWriter(this.getDataFile("GeneralData"));
        String s = "ReturnLoc: ";
        this.hardDeleteLine(s, this.getDataFile("MapData"));
        bw.append("ReturnLoc: " + loc.getWorld().getName() + " " + loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ());
        bw.newLine();
        bw.flush();
    }

    public void setReward(String name, Location loc) throws IOException {
        BufferedWriter bw = this.getDataWriter(this.getDataFile("MapData"));
        String s = String.valueOf(name.toLowerCase()) + " Reward: ";
        this.hardDeleteLine(s, this.getDataFile("MapData"));
        bw.append(String.valueOf(name.toLowerCase()) + " Reward: " + loc.getWorld().getName() + " " + loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ());
        bw.newLine();
        bw.flush();
    }

    public boolean getValue(String name) throws IOException {
        BufferedReader br = this.getDataReader(this.getDataFile("GeneralData"));
        String line = br.readLine();
        while (line != null) {
            if (line.contains(String.valueOf(name) + ": ")) {
                String[] parts = line.split(" ");
                boolean b = false;
                if (parts[1].equalsIgnoreCase("true")) {
                    b = true;
                }
                return b;
            }
            line = br.readLine();
        }
        return true;
    }

    public void setValue(String name, boolean b) throws IOException {
        BufferedWriter bw = this.getDataWriter(this.getDataFile("GeneralData"));
        String s = String.valueOf(name) + ": " + true;
        this.hardDeleteLine(s, this.getDataFile("GeneralData"));
        String sa = String.valueOf(name) + ": " + false;
        this.hardDeleteLine(sa, this.getDataFile("GeneralData"));
        bw.append(String.valueOf(name) + ": " + b);
        bw.newLine();
        bw.flush();
    }

    public int getTokens(Player p) throws IOException {
        BufferedReader br = this.getDataReader(this.getDataFile("stats"));
        String line = br.readLine();
        while (line != null) {
            if (line.contains(String.valueOf(p.getName()) + " Tokens: ")) {
                String[] parts = line.split(" ");
                return Integer.parseInt(parts[2]);
            }
            line = br.readLine();
        }
        return 0;
    }

    public void addTokens(Player p, int amount) throws IOException {
        BufferedWriter bw = this.getDataWriter(this.getDataFile("stats"));
        int tokens = this.getTokens(p);
        String s = String.valueOf(p.getName()) + " Tokens: ";
        this.hardDeleteLine(s, this.getDataFile("stats"));
        bw.append(String.valueOf(p.getName()) + " Tokens: " + (amount + tokens));
        bw.newLine();
        bw.flush();
    }

    public void setInven(Player p) throws IOException {
        String s;
        BufferedWriter bw = this.getDataWriter(this.getDataFile("tempData"));
        BufferedReader br = this.getDataReader(this.getDataFile("tempData"));
        String line = br.readLine();
        while (line != null) {
            int i = 0;
            while (i < 54) {
                s = String.valueOf(p.getName()) + " " + i + "Inven: ";
                this.hardDeleteLine(s, this.getDataFile("tempData"));
                ++i;
            }
            line = br.readLine();
        }
        int i = 0;
        while (i < p.getInventory().getContents().length) {
            if (p.getInventory().getItem(i) != null && p.getInventory().getItem(i).getType() != Material.AIR) {
                ItemStack is = p.getInventory().getItem(i);
                s = String.valueOf(p.getName()) + " " + i + "Inven: ";
                this.hardDeleteLine(s, this.getDataFile("tempData"));
                String d = "no";
                if (is.hasItemMeta() && is.getItemMeta().hasDisplayName()) {
                    d = is.getItemMeta().getDisplayName();
                }
                bw.append(String.valueOf(p.getName()) + " " + i + "Inven: " + is.getType() + " " + is.getAmount() + " " + d + " " + i);
                bw.newLine();
                bw.flush();
            }
            ++i;
        }
    }

    public int getStat(Player p, String stat) throws IOException {
        BufferedReader br = this.getDataReader(this.getDataFile("stats"));
        String line = br.readLine();
        while (line != null) {
            if (line.contains(String.valueOf(p.getName()) + " " + stat + ": ")) {
                String[] parts = line.split(" ");
                return Integer.parseInt(parts[2]);
            }
            line = br.readLine();
        }
        return 0;
    }

    public void setStat(Player p, String stat) throws IOException {
        BufferedWriter bw = this.getDataWriter(this.getDataFile("stats"));
        String s = String.valueOf(p.getName()) + " " + stat + ": ";
        this.hardDeleteLine(s, this.getDataFile("stats"));
        bw.append(String.valueOf(p.getName()) + " " + stat + ": " + 1);
        bw.newLine();
        bw.flush();
    }

    public void addStat(Player p, String stat) throws IOException {
        BufferedWriter bw = this.getDataWriter(this.getDataFile("stats"));
        int egg = this.getStat(p, stat);
        String s = String.valueOf(p.getName()) + " " + stat + ": ";
        this.hardDeleteLine(s, this.getDataFile("stats"));
        bw.append(String.valueOf(p.getName()) + " " + stat + ": " + (egg + 1));
        bw.newLine();
        bw.flush();
    }

    public void getInven(Player p) throws IOException {
        this.spot.clear();
        ArrayList<ItemStack> array = new ArrayList<ItemStack>();
        BufferedReader br = this.getDataReader(this.getDataFile("tempData"));
        String line = br.readLine();
        while (line != null) {
            int i = 0;
            while (i < 54) {
                if (line.contains(String.valueOf(p.getName()) + " " + i + "Inven: ")) {
                    String[] parts = line.split(" ");
                    Material m = Material.getMaterial((String)parts[2]);
                    int amount = Integer.parseInt(parts[3]);
                    String name = parts[4];
                    ItemStack is = new ItemStack(m, amount);
                    if (!name.equalsIgnoreCase("no")) {
                        ItemMeta im = is.getItemMeta();
                        if (name != null) {
                            im.setDisplayName(name);
                        }
                        is.setItemMeta(im);
                    }
                    int spotx = Integer.parseInt(parts[5]);
                    if (this.spot.containsKey(is)) {
                        ItemMeta im = is.getItemMeta();
                        ArrayList<String> lore = new ArrayList<String>();
                        lore.add("" + ChatColor.RESET + ChatColor.DARK_GRAY + i);
                        im.setLore(lore);
                        is.setItemMeta(im);
                        this.spot.put(is, spotx);
                    } else {
                        this.spot.put(is, spotx);
                    }
                    array.add(is);
                }
                ++i;
            }
            line = br.readLine();
        }
        for (ItemStack is : array) {
            int spotx = this.spot.get(is);
            ItemMeta im = is.getItemMeta();
            im.setLore(null);
            is.setItemMeta(im);
            p.getInventory().setItem(spotx, is);
        }
    }

    public Chest getReward(String name) throws IOException {
        BufferedReader br = this.getDataReader(this.getDataFile("MapData"));
        String line = br.readLine();
        while (line != null) {
            if (line.contains(String.valueOf(name.toLowerCase()) + " Reward: ")) {
                String[] parts = line.split(" ");
                boolean b = false;
                for (World w : Bukkit.getWorlds()) {
                    if (!w.getName().equalsIgnoreCase(parts[2])) continue;
                    b = true;
                }
                if (b) {
                    int z;
                    int y;
                    int x;
                    World w;
                    w = Bukkit.getWorld((String)parts[2]);
                    Location loc = new Location(w, (double)(x = Integer.parseInt(parts[3])), (double)(y = Integer.parseInt(parts[4])), (double)(z = Integer.parseInt(parts[5])));
                    if (loc.getBlock().getType() == Material.CHEST) {
                        return (Chest)loc.getBlock().getState();
                    }
                } else {
                    this.error2("World containing the reward chest for the map " + name + " doesn't exist.");
                }
            }
            line = br.readLine();
        }
        return null;
    }

    public Location getReturnLoc() throws IOException {
        BufferedReader br = this.getDataReader(this.getDataFile("GeneralData"));
        String line = br.readLine();
        while (line != null) {
            if (line.contains("ReturnLoc: ")) {
                String[] parts = line.split(" ");
                boolean b = false;
                for (World w : Bukkit.getWorlds()) {
                    if (!w.getName().equalsIgnoreCase(parts[1])) continue;
                    b = true;
                }
                if (b) {
                    World w;
                    w = Bukkit.getWorld((String)parts[1]);
                    int x = Integer.parseInt(parts[2]);
                    int y = Integer.parseInt(parts[3]);
                    int z = Integer.parseInt(parts[4]);
                    return new Location(w, (double)x, (double)y, (double)z);
                }
                this.error2("Map doesn't exist containing the return location.");
            }
            line = br.readLine();
        }
        return null;
    }

    public ArrayList<String> getMaps() throws IOException {
        ArrayList<String> locs = new ArrayList<String>();
        BufferedReader br = this.getDataReader(this.getDataFile("Maps"));
        String line = br.readLine();
        while (line != null) {
            locs.add(line);
            line = br.readLine();
        }
        return locs;
    }

    public void removeSign(Location loc) throws IOException {
        String s = String.valueOf(loc.getWorld().getName()) + " " + loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ();
        this.deleteLine(s, this.getDataFile("Signs"));
    }

    public void addSign(Location loc) throws IOException {
        BufferedWriter bw = this.getDataWriter(this.getDataFile("Signs"));
        bw.append(String.valueOf(loc.getWorld().getName()) + " " + loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ());
        bw.newLine();
        bw.flush();
    }

    public ArrayList<Location> getSpawnPoints(String name) throws IOException {
        ArrayList<Location> locs = new ArrayList<Location>();
        BufferedReader br = this.getDataReader(this.getDataFile("MapData"));
        String line = br.readLine();
        while (line != null) {
            if (line.contains(String.valueOf(name.toLowerCase()) + " Spawnpoint: ")) {
                String[] parts = line.split(" ");
                boolean b = false;
                for (World w : Bukkit.getWorlds()) {
                    if (!w.getName().equalsIgnoreCase(parts[2])) continue;
                    b = true;
                }
                if (b) {
                    World w;
                    w = Bukkit.getWorld((String)parts[2]);
                    int x = Integer.parseInt(parts[3]);
                    int y = Integer.parseInt(parts[4]);
                    int z = Integer.parseInt(parts[5]);
                    locs.add(new Location(w, (double)x, (double)y, (double)z));
                } else {
                    this.error2("World doesn't exist containing an arena");
                }
            }
            line = br.readLine();
        }
        return locs;
    }

    public void clearSpawnPoints(String name) {
        String s = String.valueOf(name.toLowerCase()) + " Spawnpoint: ";
        this.hardDeleteLine(s, this.getDataFile("MapData"));
    }

    public void removeSpawnPoint(String name, Location loc) throws IOException {
        String s = String.valueOf(name.toLowerCase()) + " Spawnpoint: " + loc.getWorld().getName() + " " + loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ();
        this.deleteLine(s, this.getDataFile("MapData"));
    }

    public void addSpawnPoint(String name, Location loc) throws IOException {
        BufferedWriter bw = this.getDataWriter(this.getDataFile("MapData"));
        bw.append(String.valueOf(name.toLowerCase()) + " Spawnpoint: " + loc.getWorld().getName() + " " + loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ());
        bw.newLine();
        bw.flush();
    }

    public void setLife(String name, int life) throws IOException {
        BufferedWriter bw = this.getDataWriter(this.getDataFile("MapData"));
        String s = String.valueOf(name.toLowerCase()) + " Life: ";
        this.hardDeleteLine(s, this.getDataFile("MapData"));
        bw.append(String.valueOf(name.toLowerCase()) + " Life: " + life);
        bw.newLine();
        bw.flush();
    }

    public int getLife(String name) throws IOException {
        BufferedReader br = this.getDataReader(this.getDataFile("MapData"));
        String line = br.readLine();
        while (line != null) {
            if (line.contains(String.valueOf(name.toLowerCase()) + " Life: ")) {
                String[] parts = line.split(" ");
                return Integer.parseInt(parts[2]);
            }
            line = br.readLine();
        }
        return 3;
    }

    public void setLobby(String name, Location loc) throws IOException {
        BufferedWriter bw = this.getDataWriter(this.getDataFile("MapData"));
        String s = String.valueOf(name.toLowerCase()) + " Lobby: ";
        this.hardDeleteLine(s, this.getDataFile("MapData"));
        bw.append(String.valueOf(name.toLowerCase()) + " Lobby: " + loc.getWorld().getName() + " " + loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ());
        bw.newLine();
        bw.flush();
    }

    public Location getlobby(String name) throws IOException {
        BufferedReader br = this.getDataReader(this.getDataFile("MapData"));
        String line = br.readLine();
        while (line != null) {
            if (line.contains(String.valueOf(name.toLowerCase()) + " Lobby: ")) {
                String[] parts = line.split(" ");
                boolean b = false;
                for (World w : Bukkit.getWorlds()) {
                    if (!w.getName().equalsIgnoreCase(parts[2])) continue;
                    b = true;
                }
                if (b) {
                    World w;
                    w = Bukkit.getWorld((String)parts[2]);
                    int x = Integer.parseInt(parts[3]);
                    int y = Integer.parseInt(parts[4]);
                    int z = Integer.parseInt(parts[5]);
                    return new Location(w, (double)x, (double)y, (double)z);
                }
                this.error2("User attempted to join game without a lobby.");
            }
            line = br.readLine();
        }
        return null;
    }

    public void setMaxPlayerCount(String name, int max) throws IOException {
        String s = String.valueOf(name.toLowerCase()) + " Max: ";
        this.hardDeleteLine(s, this.getDataFile("MapData"));
        BufferedWriter bw = this.getDataWriter(this.getDataFile("MapData"));
        bw.append(String.valueOf(name.toLowerCase()) + " Max: " + max);
        bw.newLine();
        bw.flush();
    }

    public void setGroundLevel(String name, int level) throws IOException {
        String s = String.valueOf(name.toLowerCase()) + " Ground: ";
        this.hardDeleteLine(s, this.getDataFile("MapData"));
        BufferedWriter bw = this.getDataWriter(this.getDataFile("MapData"));
        bw.append(String.valueOf(name.toLowerCase()) + " Ground: " + level);
        bw.newLine();
        bw.flush();
    }

    public int getLife(Player p) throws IOException {
        BufferedReader br = this.getDataReader(this.getDataFile("tempData"));
        String line = br.readLine();
        while (line != null) {
            if (line.contains(String.valueOf(p.getName()) + " Life: ")) {
                String[] parts = line.split(" ");
                return Integer.parseInt(parts[2]);
            }
            line = br.readLine();
        }
        return -1;
    }

    public void setLife(Player p, int level) throws IOException {
        if (this.core.getMap(p) != null) {
            String name = p.getName();
            String s = String.valueOf(name) + " Life: ";
            this.hardDeleteLine(s, this.getDataFile("tempData"));
            BufferedWriter bw = this.getDataWriter(this.getDataFile("tempData"));
            bw.append(String.valueOf(name) + " Life: " + level);
            bw.newLine();
            bw.flush();
        }
    }

    public void removeMap(String map) throws IOException {
        String s = map.toLowerCase();
        this.hardDeleteLine(s, this.getDataFile("Maps"));
    }

    public int getGroundLevel(String name) throws IOException {
        BufferedReader br = this.getDataReader(this.getDataFile("MapData"));
        String line = br.readLine();
        while (line != null) {
            if (line.contains(String.valueOf(name.toLowerCase()) + " Ground: ")) {
                String[] parts = line.split(" ");
                return Integer.parseInt(parts[2]);
            }
            line = br.readLine();
        }
        return 0;
    }

    public int getMaxPlayerCount(String name) throws IOException {
        BufferedReader br = this.getDataReader(this.getDataFile("MapData"));
        String line = br.readLine();
        while (line != null) {
            if (line.contains(String.valueOf(name.toLowerCase()) + " Max: ")) {
                String[] parts = line.split(" ");
                return Integer.parseInt(parts[2]);
            }
            line = br.readLine();
        }
        return 0;
    }

    public void addMap(String name) throws IOException {
        BufferedWriter bw = this.getDataWriter(this.getDataFile("Maps"));
        bw.append(name.toLowerCase());
        bw.newLine();
        bw.flush();
    }

    public File getDataFile(String name) {
        File f = new File(String.valueOf(this.main.getDataFolder().getAbsolutePath()) + "\\" + name + ".yml");
        if (!f.exists()) {
            try {
                f.createNewFile();
                return f;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            return f;
        }
        return null;
    }

    public BufferedWriter getDataWriter(File f) {
        try {
            FileWriter fr = new FileWriter(f, true);
            return new BufferedWriter(fr);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.error("Encountered a serious error when attemping to create writer, this is a bug, please report as soon as possible to developer.");
        return null;
    }

    public BufferedReader getDataReader(File f) {
        try {
            FileReader fr = new FileReader(f);
            return new BufferedReader(fr);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.error("Encountered a serious error when attemping to create reader, this is a bug, please report as soon as possible to developer.");
            return null;
        }
    }

    public void error(String error) {
        Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[" + this.core.getName() + "]: " + error);
    }

    public void error2(String error) {
        Bukkit.getConsoleSender().sendMessage(ChatColor.YELLOW + "[" + this.core.getName() + "]: " + error);
    }

    /*
     * Exception decompiling
     */
    public boolean exists(String line, File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteLine(String line, File file) {
        File file2 = new File(String.valueOf(file.getParent()) + "\\temp" + file.getName());
        PrintWriter pw = null;
        Scanner read = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel src = null;
        AbstractInterruptibleChannel dest = null;
        try {
            try {
                pw = new PrintWriter(file2);
                read = new Scanner(file);
                while (read.hasNextLine()) {
                    String currline = read.nextLine();
                    if (line.equalsIgnoreCase(currline)) continue;
                    pw.println(currline);
                }
                pw.flush();
                fis = new FileInputStream(file2);
                src = fis.getChannel();
                fos = new FileOutputStream(file);
                dest = fos.getChannel();
                ((FileChannel)dest).transferFrom((ReadableByteChannel)((Object)src), 0L, ((FileChannel)src).size());
            }
            catch (IOException e) {
                e.printStackTrace();
                pw.close();
                read.close();
                try {
                    fis.close();
                    fos.close();
                    src.close();
                    dest.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                if (!file2.delete()) {
                    this.error("Error code, report to developer with code: 3344");
                }
            }
        }
        finally {
            pw.close();
            read.close();
            try {
                fis.close();
                fos.close();
                src.close();
                dest.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!file2.delete()) {
                this.error("Error code, report to developer with code: 3344");
            }
        }
    }

    public void hardDeleteLine(String line, File file) {
        File file2 = new File(String.valueOf(file.getParent()) + "\\temp" + file.getName());
        PrintWriter pw = null;
        Scanner read = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel src = null;
        AbstractInterruptibleChannel dest = null;
        try {
            try {
                pw = new PrintWriter(file2);
                read = new Scanner(file);
                while (read.hasNextLine()) {
                    String currline = read.nextLine();
                    if (currline.contains(line)) continue;
                    pw.println(currline);
                }
                pw.flush();
                fis = new FileInputStream(file2);
                src = fis.getChannel();
                fos = new FileOutputStream(file);
                dest = fos.getChannel();
                ((FileChannel)dest).transferFrom((ReadableByteChannel)((Object)src), 0L, ((FileChannel)src).size());
            }
            catch (IOException e) {
                e.printStackTrace();
                pw.close();
                read.close();
                try {
                    fis.close();
                    fos.close();
                    src.close();
                    dest.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                if (!file2.delete()) {
                    this.error("Error code, report to developer with code: 3344");
                }
            }
        }
        finally {
            pw.close();
            read.close();
            try {
                fis.close();
                fos.close();
                src.close();
                dest.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!file2.delete()) {
                this.error("Error code, report to developer with code: 3344");
            }
        }
    }
}

