/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.DataHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import main.Mainx;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class Core {
    String name;
    DataHandler handler;
    Mainx main;
    ArrayList<String> assigned = new ArrayList();
    HashMap<String, Integer> users = new HashMap();
    HashMap<String, ArrayList<String>> userArray = new HashMap();
    ArrayList<String> starting = new ArrayList();
    ArrayList<String> inStartup = new ArrayList();
    ArrayList<String> running = new ArrayList();
    HashMap<String, Location> assign = new HashMap();
    public HashMap<String, ArrayList<Location>> toReplace = new HashMap();

    public Core(Mainx main) {
        this.main = main;
        this.handler = new DataHandler(main, this);
    }

    public ArrayList<String> getUserArray(String map) {
        return this.userArray.get(map);
    }

    public void setUsers(String name, int amount) {
        this.users.put(name, amount);
    }

    public void addUser(String name) {
        this.users.put(name, this.getUsers(name) + 1);
    }

    public void removeUser(String name) {
        this.users.put(name, this.getUsers(name) - 1);
    }

    public int getUsers(String name) {
        if (this.users.containsKey(name)) {
            return this.users.get(name);
        }
        return 0;
    }

    public void add(String map) {
        this.assigned.add(map);
    }

    public void remove(String map) {
        if (this.assigned.contains(map)) {
            this.assigned.remove(map);
        }
    }

    public Location getReturnLoc() throws IOException {
        return this.handler.getReturnLoc();
    }

    public boolean contains(String map) {
        return this.assigned.contains(map);
    }

    public void register(String name) throws IOException {
        this.name = name;
        for (Location loc : this.getSigns()) {
            if (loc.getBlock().getType() != Material.WALL_SIGN && loc.getBlock().getType() != Material.SIGN && loc.getBlock().getType() != Material.SIGN_POST) continue;
            Sign s = (Sign)loc.getBlock().getState();
            s.setLine(1, ChatColor.YELLOW + "Loading...");
            s.update();
        }
    }

    public String getName() {
        return this.name;
    }

    public void removeSign(Location loc) throws IOException {
        this.handler.removeSign(loc);
    }

    public ArrayList<Location> getSigns() throws IOException {
        return this.handler.getSigns();
    }

    public ArrayList<String> getMaps() throws IOException {
        return this.handler.getMaps();
    }

    public void addSign(Location loc) throws IOException {
        this.handler.addSign(loc);
    }

    public void addMap(String name) throws IOException {
        this.handler.addMap(name);
    }

    public void addSpawnPoint(String name, Location loc) throws IOException {
        this.handler.addSpawnPoint(name, loc);
    }

    public void removeSpawnPoint(String name, Location loc) throws IOException {
        this.handler.removeSpawnPoint(name, loc);
    }

    public void setMaxPlayerCount(String name, int max) throws IOException {
        this.handler.setMaxPlayerCount(name, max);
    }

    public int getMaxPlayerCount(String name) throws IOException {
        return this.handler.getMaxPlayerCount(name);
    }

    public void setLobby(String name, Location loc) throws IOException {
        this.handler.setLobby(name, loc);
    }

    public void addPlayerToArray(Player p, String map) {
        String name = p.getName();
        ArrayList<String> newArray = new ArrayList<String>();
        if (this.getUserArray(map) != null && !this.getUserArray(map).isEmpty()) {
            for (String s : this.getUserArray(map)) {
                newArray.add(s);
            }
        }
        newArray.add(name);
        this.userArray.put(map, newArray);
    }

    public void removePlayerFromArray(Player p, String map) {
        ArrayList<String> newArray = new ArrayList<String>();
        if (this.getUserArray(map) != null && !this.getUserArray(map).isEmpty()) {
            for (String s : this.getUserArray(map)) {
                if (s.equalsIgnoreCase(p.getName())) continue;
                newArray.add(s);
            }
        }
        this.userArray.put(map, newArray);
    }

    public String getMap(Player p) throws IOException {
        for (String map : this.getMaps()) {
            if (this.getUserArray(map) == null || this.getUserArray(map).isEmpty() || !this.getUserArray(map).contains(p.getName())) continue;
            return map;
        }
        return null;
    }

    public void setReturnLoc(Location loc) throws IOException {
        this.handler.setReturnLoc(loc);
    }

    public Location returnLoc() throws IOException {
        return this.handler.getReturnLoc();
    }

    public void addStat(Player p, String stat) throws IOException {
        this.handler.addStat(p, stat);
    }

    public int getStat(Player p, String stat) throws IOException {
        return this.handler.getStat(p, stat);
    }

    public void giveItems(Player p) {
        ItemStack is = new ItemStack(Material.BED, 1);
        ItemMeta im = is.getItemMeta();
        im.setDisplayName(ChatColor.GRAY + ChatColor.BOLD + "Leave");
        is.setItemMeta(im);
        p.getInventory().setItem(8, is);
        ItemStack is1 = new ItemStack(Material.WRITTEN_BOOK, 1);
        BookMeta bm = (BookMeta)is1.getItemMeta();
        bm.setAuthor("Queen Of Eggs");
        bm.setTitle(ChatColor.GOLD + "Stats");
        bm.setGeneration(BookMeta.Generation.COPY_OF_ORIGINAL);
        is1.setItemMeta((ItemMeta)bm);
        p.getInventory().setItem(4, is1);
    }

    public void removeMap(String map) throws IOException {
        this.handler.removeMap(map);
    }

    public void removeFromLobby(Player p) throws IOException {
        if (this.getMap(p) != null) {
            String map = this.getMap(p);
            this.removeUser(map);
            this.removePlayerFromArray(p, map);
            p.getInventory().clear();
            this.getInven(p);
            p.sendMessage(ChatColor.GOLD + ChatColor.BOLD + "<<<" + ChatColor.RESET + ChatColor.GRAY + "Sending you back to spawn...");
            int max = this.getMaxPlayerCount(map);
            int current = this.getUsers(map);
            if (this.getUserArray(map) != null && !this.getUserArray(map).isEmpty()) {
                for (String user : this.getUserArray(map)) {
                    Player q = Bukkit.getPlayer((String)user);
                    q.sendMessage(ChatColor.GOLD + ChatColor.BOLD + "<<<" + ChatColor.RESET + ChatColor.GRAY + p.getName() + " left the game. " + ChatColor.DARK_GRAY + "[" + current + "/" + max + "]");
                }
            }
            if (this.returnLoc() != null) {
                p.teleport(this.returnLoc());
            } else if (!this.getSigns().isEmpty()) {
                p.teleport(this.getSigns().get(0));
            }
        }
    }

    public void addTokens(Player p, int amount) throws IOException {
        this.handler.addTokens(p, amount);
    }

    public int getTokens(Player p) throws IOException {
        return this.handler.getTokens(p);
    }

    public void sendToLobby(Player p, String map) throws IOException {
        if (this.getLobby(map) != null) {
            p.sendMessage(ChatColor.GOLD + ChatColor.BOLD + ">>>" + ChatColor.RESET + ChatColor.GRAY + "Sending you to lobby...");
            p.teleport(this.getLobby(map));
            this.addUser(map);
            p.getInventory().clear();
            this.giveItems(p);
            this.addPlayerToArray(p, map);
            int max = this.getMaxPlayerCount(map);
            int current = this.getUsers(map);
            if (this.getUserArray(map) != null && !this.getUserArray(map).isEmpty()) {
                for (String user : this.getUserArray(map)) {
                    Player q = Bukkit.getPlayer((String)user);
                    q.sendMessage(ChatColor.GOLD + ChatColor.BOLD + ">>>" + ChatColor.RESET + ChatColor.GRAY + p.getName() + " joined the game. " + ChatColor.DARK_GRAY + "[" + current + "/" + max + "]");
                }
            }
            if (max == current && !this.isStarting(map)) {
                this.count(map, 10);
                this.starting.add(map);
            }
        } else {
            this.handler.error2("User attempted to enter game when there is no lobby linked to it.");
        }
    }

    public boolean isStarting(String map) {
        return this.starting.contains(map);
    }

    public void setStat(Player p, String stat) throws IOException {
        this.handler.setStat(p, stat);
    }

    public void setValue(String name, boolean b) {
        try {
            this.handler.setValue(name, b);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean getValue(String name) {
        try {
            return this.handler.getValue(name);
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
    }

    public void count(final String map, final int recurse) {
        if (recurse > 0) {
            if (this.getUserArray(map) != null && !this.getUserArray(map).isEmpty()) {
                for (String user : this.getUserArray(map)) {
                    Player q = Bukkit.getPlayer((String)user);
                    q.sendTitle("", "" + ChatColor.WHITE + recurse, 0, 20, 0);
                    q.playSound(q.getLocation(), Sound.BLOCK_NOTE_PLING, 1.0f, 1.0f);
                }
            }
            this.main.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.main, new Runnable(){

                @Override
                public void run() {
                    int max = 0;
                    try {
                        max = Core.this.getMaxPlayerCount(map);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    int current = Core.this.getUsers(map);
                    if (max == current) {
                        Core.this.count(map, recurse - 1);
                    } else {
                        if (Core.this.getUserArray(map) != null && !Core.this.getUserArray(map).isEmpty()) {
                            for (String user : Core.this.getUserArray(map)) {
                                Player q = Bukkit.getPlayer((String)user);
                                q.sendTitle("", ChatColor.WHITE + "Countdown halted", 0, 40, 0);
                            }
                        }
                        Core.this.starting.remove(map);
                    }
                }
            }, 20L);
        } else {
            this.starting.remove(map);
            try {
                this.startup(map);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void keep(final String map, int recurse) {
        this.main.despawnAllOfMap(map);
        int i = 1;
        while (i < recurse * 20) {
            this.main.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.main, new Runnable(){

                @Override
                public void run() {
                    if (Core.this.getUserArray(map) != null && !Core.this.getUserArray(map).isEmpty()) {
                        for (String user : Core.this.getUserArray(map)) {
                            boolean b = false;
                            for (Player p : Bukkit.getOnlinePlayers()) {
                                if (!p.getName().equalsIgnoreCase(user)) continue;
                                b = true;
                            }
                            if (!b || !Core.this.assign.containsKey(Bukkit.getPlayer((String)user).getName())) continue;
                            Location loc = Core.this.assign.get(Bukkit.getPlayer((String)user).getName());
                            Location tp = new Location(loc.getWorld(), loc.getX(), loc.getY(), loc.getZ(), 0.0f, 90.0f);
                            Bukkit.getPlayer((String)user).teleport(tp);
                        }
                    }
                }
            }, (long)i);
            i += 2;
        }
    }

    public void setMapLife(String map, int life) throws IOException {
        this.handler.setLife(map, life);
    }

    public int getMapLife(String map) throws IOException {
        return this.handler.getLife(map);
    }

    public void error(String message) {
        this.handler.error(message);
    }

    public void error2(String message) {
        this.handler.error2(message);
    }

    public void setGroundLevel(String map, int y) throws IOException {
        this.handler.setGroundLevel(map, y);
    }

    public int getGroundLevel(String map) throws IOException {
        return this.handler.getGroundLevel(map);
    }

    public void setReward(String map, Location amount) throws IOException {
        this.handler.setReward(map, amount);
    }

    public Chest getReward(String map) throws IOException {
        return this.handler.getReward(map);
    }

    public void getInven(Player p) throws IOException {
        this.handler.getInven(p);
    }

    public int getSpot(ItemStack is) {
        return this.handler.spot.get(is);
    }

    public void setInven(Player p) throws IOException {
        this.handler.setInven(p);
    }

    public void count2(final String map, final int recurse) {
        if (recurse > 0) {
            if (this.getUserArray(map) != null && !this.getUserArray(map).isEmpty()) {
                for (String user : this.getUserArray(map)) {
                    Player q = Bukkit.getPlayer((String)user);
                    q.sendTitle("Starting in...", "" + ChatColor.WHITE + recurse, 0, 22, 0);
                    Random r = new Random();
                    q.playSound(q.getLocation(), Sound.ENTITY_CHICKEN_AMBIENT, 1.0f, 1.0f + (float)(r.nextInt(8) / 10));
                }
            }
            this.main.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.main, new Runnable(){

                @Override
                public void run() {
                    Core.this.count2(map, recurse - 1);
                }
            }, 20L);
        } else {
            this.inStartup.remove(map);
            try {
                if (this.getUserArray(map) != null && !this.getUserArray(map).isEmpty()) {
                    for (String user : this.getUserArray(map)) {
                        Player q = Bukkit.getPlayer((String)user);
                        if (!this.getValue("bow")) continue;
                        ItemStack is = new ItemStack(Material.BOW, 1);
                        ItemMeta im = is.getItemMeta();
                        im.setDisplayName(ChatColor.WHITE + ChatColor.BOLD + "Egg Bow");
                        im.setUnbreakable(true);
                        im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
                        im.addEnchant(Enchantment.ARROW_INFINITE, 1, false);
                        is.setItemMeta(im);
                        q.getInventory().setItem(17, new ItemStack(Material.ARROW, 1));
                        q.getInventory().setItem(8, is);
                    }
                }
                this.start(map);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public ArrayList<Location> getSpawnPoints(String name) throws IOException {
        return this.handler.getSpawnPoints(name);
    }

    public void start(String map) throws IOException {
        for (String s : this.getUserArray(map)) {
            Player p = Bukkit.getPlayer((String)s);
            ItemStack is = new ItemStack(Material.EGG, 10);
            ItemMeta im = is.getItemMeta();
            im.setDisplayName(ChatColor.WHITE + ChatColor.BOLD + "Magic Egg");
            is.setItemMeta(im);
            p.getInventory().addItem(new ItemStack[]{is});
            this.addStat(p, "play");
        }
        for (Location loc : this.getSpawnPoints(map)) {
            Location toBreak = new Location(loc.getWorld(), (double)loc.getBlockX(), (double)(loc.getBlockY() - 1), (double)loc.getBlockZ());
            ArrayList<Location> old = new ArrayList<Location>();
            if (this.toReplace.containsKey(map)) {
                for (Location l : this.toReplace.get(map)) {
                    old.add(l);
                }
            }
            old.add(toBreak);
            this.toReplace.put(map, old);
            toBreak.getBlock().setType(Material.AIR);
        }
    }

    public void setLife(Player p, int life) throws IOException {
        this.handler.setLife(p, life);
    }

    public int getLife(Player p) throws IOException {
        return this.handler.getLife(p);
    }

    public void scoreboard(String map) throws IllegalStateException, IOException {
        Player p;
        ArrayList<String> usera = this.getUserArray(map);
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        Scoreboard board = manager.getNewScoreboard();
        Objective objective = board.registerNewObjective("Skills", "dummy");
        objective.setDisplayName(ChatColor.WHITE + "\u2583\u2583\u2583\u2583" + ChatColor.GOLD + ChatColor.BOLD + "EggSmash" + ChatColor.RESET + ChatColor.WHITE + "\u2583\u2583\u2583\u2583");
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        for (String s : usera) {
            p = Bukkit.getPlayer((String)s);
            Score score = objective.getScore(String.valueOf(s) + ":");
            score.setScore(this.getLife(p));
        }
        for (String s : usera) {
            p = Bukkit.getPlayer((String)s);
            p.setScoreboard(board);
        }
    }

    public void startup(String map) throws IOException {
        ArrayList<String> userax = this.getUserArray(map);
        for (String s : userax) {
            Player p = Bukkit.getPlayer((String)s);
            p.setGameMode(GameMode.SURVIVAL);
            this.setLife(p, this.getMapLife(map));
        }
        this.scoreboard(map);
        for (Location loc : this.getSpawnPoints(map)) {
            Location toBreak = new Location(loc.getWorld(), (double)loc.getBlockX(), (double)(loc.getBlockY() - 1), (double)loc.getBlockZ());
            toBreak.getBlock().setType(Material.BARRIER);
        }
        this.running.add(map);
        this.inStartup.add(map);
        this.count2(map, 10);
        ArrayList<Location> points = this.handler.getSpawnPoints(map);
        ArrayList<String> usera = this.getUserArray(map);
        if (usera.size() >= points.size()) {
            Collections.shuffle(points);
            int i = 0;
            while (i < usera.size()) {
                Bukkit.getPlayer((String)usera.get(i)).teleport(points.get(0));
                Bukkit.getPlayer((String)usera.get(i)).getInventory().clear();
                this.assign.put(Bukkit.getPlayer((String)usera.get(i)).getName(), points.get(0));
                points.remove(0);
                ++i;
            }
        } else if (usera.size() < points.size()) {
            Collections.shuffle(points);
            int i = 0;
            while (i < usera.size()) {
                Bukkit.getPlayer((String)usera.get(i)).teleport(points.get(0));
                Bukkit.getPlayer((String)usera.get(i)).getInventory().clear();
                this.assign.put(Bukkit.getPlayer((String)usera.get(i)).getName(), points.get(0));
                ++i;
            }
        }
        for (String s : userax) {
            Player p = Bukkit.getPlayer((String)s);
            p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        }
        this.keep(map, 10);
    }

    public Location getLobby(String name) throws IOException {
        return this.handler.getlobby(name);
    }

    public void clearSpawnPoints(String name) {
        this.handler.clearSpawnPoints(name);
    }
}

