/*
 * Decompiled with CFR 0.152.
 */
package de.redgames.f3nperm.reflection;

import de.redgames.f3nperm.reflection.ReflectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;

public final class Reflections {
    private static String versionPackageName;
    private static final Map<String, Class<?>> primitives;

    private Reflections() {
    }

    private static String getVersionPackageName() {
        if (versionPackageName == null) {
            versionPackageName = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        }
        return versionPackageName;
    }

    public static Class<?> resolve(String className) throws ReflectionException {
        Class<?> primitiveClass = primitives.get(className);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        String version = Reflections.getVersionPackageName();
        String lookup = className.replace("{nms}", "net.minecraft.server." + version + ".").replace("{obc}", "org.bukkit.craftbukkit." + version + ".");
        try {
            return Class.forName(lookup);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException("Class '" + className + "' could not be resolved!", e);
        }
    }

    public static Object make(String constructorDescription, Object ... params) throws ReflectionException {
        Constructor<?> constructor = Reflections.findConstructor(constructorDescription, false);
        try {
            return constructor.newInstance(params);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ReflectionException("Could not invoke constructor " + constructorDescription, e);
        }
    }

    private static Constructor<?> findConstructor(String constructorDescription, boolean isPrivate) throws ReflectionException {
        try {
            String paramName;
            if (constructorDescription.endsWith("()")) {
                String className = constructorDescription.substring(0, constructorDescription.length() - 2);
                Class<?> clazz = Reflections.resolve(className);
                if (isPrivate) {
                    return clazz.getDeclaredConstructor(new Class[0]);
                }
                return clazz.getConstructor(new Class[0]);
            }
            int startingBracket = constructorDescription.indexOf(40);
            int endingBracket = constructorDescription.indexOf(41);
            if (startingBracket == -1 || endingBracket == -1) {
                throw new IllegalArgumentException("Constructor declaration must contain start and end brackets!");
            }
            String className = constructorDescription.substring(0, startingBracket);
            Class<?> clazz = Reflections.resolve(className);
            ArrayList params = new ArrayList();
            int from = startingBracket + 1;
            int to = constructorDescription.indexOf(44);
            while (to != -1) {
                paramName = constructorDescription.substring(from, to);
                params.add(Reflections.resolve(paramName));
                from = to + 1;
                to = constructorDescription.indexOf(44, to + 1);
            }
            paramName = constructorDescription.substring(from, endingBracket);
            params.add(Reflections.resolve(paramName));
            if (isPrivate) {
                return clazz.getDeclaredConstructor(params.toArray(new Class[0]));
            }
            return clazz.getConstructor(params.toArray(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Could not find constructor!", e);
        }
    }

    public static Object call(Object target, String methodDescription, Object ... parameters) throws ReflectionException {
        Class<?> clazz = target.getClass();
        Method method = Reflections.findMethod(clazz, methodDescription, false);
        try {
            return method.invoke(target, parameters);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflectionException("Could not call method '" + methodDescription + "' on '" + clazz.getCanonicalName() + "'!");
        }
    }

    private static Method findMethod(Class<?> clazz, String methodDescription, boolean isPrivate) throws ReflectionException {
        try {
            String paramName;
            if (methodDescription.endsWith("()")) {
                String methodName = methodDescription.substring(0, methodDescription.length() - 2);
                if (isPrivate) {
                    return clazz.getDeclaredMethod(methodName, new Class[0]);
                }
                return clazz.getMethod(methodName, new Class[0]);
            }
            int startingBracket = methodDescription.indexOf(40);
            int endingBracket = methodDescription.indexOf(41);
            if (startingBracket == -1 || endingBracket == -1) {
                throw new IllegalArgumentException("Method declaration must contain start and end brackets!");
            }
            String methodName = methodDescription.substring(0, startingBracket);
            ArrayList params = new ArrayList();
            int from = startingBracket + 1;
            int to = methodName.indexOf(44);
            while (to != -1) {
                paramName = methodDescription.substring(from, to);
                params.add(Reflections.resolve(paramName));
                from = to + 1;
                to = methodName.indexOf(44, to + 1);
            }
            paramName = methodDescription.substring(from, endingBracket);
            params.add(Reflections.resolve(paramName));
            if (isPrivate) {
                return clazz.getDeclaredMethod(methodName, params.toArray(new Class[0]));
            }
            return clazz.getMethod(methodName, params.toArray(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Could not find method!", e);
        }
    }

    public static Object get(Object target, String name) throws ReflectionException {
        Class<?> clazz = target.getClass();
        try {
            Field field = clazz.getField(name);
            return field.get(target);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ReflectionException("Could not access field " + name + " on " + clazz.getCanonicalName(), e);
        }
    }

    public static Object getPrivate(Object target, String name) throws ReflectionException {
        Class<?> clazz = target.getClass();
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field.get(target);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ReflectionException("Could not access field " + name + " on " + clazz.getCanonicalName(), e);
        }
    }

    public static void setPrivate(Object target, String name, Object value) throws ReflectionException {
        Class<?> clazz = target.getClass();
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ReflectionException("Could not write field " + name + " on " + clazz.getCanonicalName(), e);
        }
    }

    static {
        primitives = new HashMap<String, Class<?>>(){
            {
                this.put("int", Integer.TYPE);
                this.put("byte", Byte.TYPE);
                this.put("short", Short.TYPE);
                this.put("long", Long.TYPE);
                this.put("float", Float.TYPE);
                this.put("double", Double.TYPE);
                this.put("boolean", Boolean.TYPE);
                this.put("char", Character.TYPE);
            }
        };
    }
}

