/*
 * Decompiled with CFR 0.152.
 */
package de.redgames.f3nperm.provider;

import de.redgames.f3nperm.OpPermissionLevel;
import de.redgames.f3nperm.provider.NettyProvider;
import de.redgames.f3nperm.provider.ProviderException;
import de.redgames.f3nperm.reflection.ReflectionException;
import de.redgames.f3nperm.reflection.Reflections;
import io.netty.channel.Channel;
import org.bukkit.entity.Player;

public class ReflectionProvider_v1_9_R1
extends NettyProvider {
    @Override
    public void sendPacket(Player player) {
        OpPermissionLevel level = this.getPlugin().getF3NPermPermissionLevel(player);
        try {
            Object entityPlayer = this.getEntityPlayer(player);
            Object playerConnection = this.getPlayerConnection(entityPlayer);
            Object packet = this.makeStatusPacket(entityPlayer, level.toStatusByte());
            this.sendPacket(playerConnection, packet);
        }
        catch (ReflectionException e) {
            throw new ProviderException("Could not send packet!", e);
        }
    }

    @Override
    public void adjustPacket(Player player, Object packet) {
        try {
            if (!this.isStatusPacket(packet)) {
                return;
            }
            int entity = this.getStatusPacketEntity(packet);
            if (entity != player.getEntityId()) {
                return;
            }
            OpPermissionLevel currentLevel = this.getStatusPacketStatus(packet);
            if (currentLevel == null) {
                return;
            }
            OpPermissionLevel level = this.getPlugin().getF3NPermPermissionLevel(player);
            this.setStatusPacketStatus(packet, level);
        }
        catch (ReflectionException e) {
            throw new ProviderException("Could not adjust packet!", e);
        }
    }

    @Override
    public Channel getChannel(Player player) {
        try {
            Object entityPlayer = this.getEntityPlayer(player);
            Object playerConnection = this.getPlayerConnection(entityPlayer);
            Object networkManager = this.getNetworkManager(playerConnection);
            return (Channel)this.getChannel(networkManager);
        }
        catch (ReflectionException e) {
            throw new ProviderException("Could not retrieve channel for " + player.getName() + "!", e);
        }
    }

    public Object getEntityPlayer(Player player) throws ReflectionException {
        return Reflections.call(player, "getHandle()", new Object[0]);
    }

    public Object getPlayerConnection(Object entityPlayer) throws ReflectionException {
        return Reflections.get(entityPlayer, "playerConnection");
    }

    public Object getNetworkManager(Object playerConnection) throws ReflectionException {
        return Reflections.getPrivate(playerConnection, "networkManager");
    }

    public Object getChannel(Object networkManager) throws ReflectionException {
        return Reflections.getPrivate(networkManager, "channel");
    }

    public int getStatusPacketEntity(Object packet) throws ReflectionException {
        return (Integer)Reflections.getPrivate(packet, "a");
    }

    public OpPermissionLevel getStatusPacketStatus(Object packet) throws ReflectionException {
        return OpPermissionLevel.fromStatusByte((Byte)Reflections.getPrivate(packet, "b"));
    }

    public void setStatusPacketStatus(Object packet, OpPermissionLevel level) throws ReflectionException {
        Reflections.setPrivate(packet, "b", level.toStatusByte());
    }

    public Object makeStatusPacket(Object entityPlayer, byte status) throws ReflectionException {
        return Reflections.make("{nms}PacketPlayOutEntityStatus({nms}Entity,byte)", entityPlayer, status);
    }

    public boolean isStatusPacket(Object packet) throws ReflectionException {
        return packet.getClass().getSimpleName().equals("PacketPlayOutEntityStatus");
    }

    public void sendPacket(Object playerConnection, Object packet) throws ReflectionException {
        Reflections.call(playerConnection, "sendPacket({nms}Packet)", packet);
    }
}

