/*
 * Decompiled with CFR 0.152.
 */
package de.redgames.f3nperm.provider;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import de.redgames.f3nperm.F3NPermPlugin;
import de.redgames.f3nperm.OpPermissionLevel;
import de.redgames.f3nperm.provider.Provider;
import de.redgames.f3nperm.provider.ProviderException;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ProtocolLibProvider
implements Provider {
    private F3NPermPlugin plugin;
    private ProtocolManager manager;

    @Override
    public void register(F3NPermPlugin plugin) {
        this.plugin = plugin;
        this.manager = ProtocolLibrary.getProtocolManager();
        this.manager.addPacketListener((PacketListener)new PacketAdapter((Plugin)plugin, new PacketType[]{PacketType.Play.Server.ENTITY_STATUS}){

            public void onPacketSending(PacketEvent event) {
                if (event.getPacketType() != PacketType.Play.Server.ENTITY_STATUS) {
                    return;
                }
                if (event.isPlayerTemporary()) {
                    return;
                }
                PacketContainer packet = event.getPacket();
                int playerId = (Integer)packet.getIntegers().read(0);
                if (playerId != event.getPlayer().getEntityId()) {
                    return;
                }
                byte currentStatus = (Byte)packet.getBytes().read(0);
                F3NPermPlugin plugin = ProtocolLibProvider.this.plugin;
                if (OpPermissionLevel.fromStatusByte(currentStatus) == null) {
                    return;
                }
                OpPermissionLevel targetLevel = plugin.getF3NPermPermissionLevel(event.getPlayer());
                packet.getBytes().write(0, (Object)targetLevel.toStatusByte());
            }
        });
    }

    @Override
    public void unregister(F3NPermPlugin plugin) {
        this.manager.removePacketListeners((Plugin)plugin);
    }

    @Override
    public void update(Player player) {
        OpPermissionLevel level = this.plugin.getF3NPermPermissionLevel(player);
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_STATUS);
        packet.getIntegers().write(0, (Object)player.getEntityId());
        packet.getBytes().write(0, (Object)level.toStatusByte());
        try {
            this.manager.sendServerPacket(player, packet, false);
        }
        catch (InvocationTargetException e) {
            throw new ProviderException("Could not send status packet!", e);
        }
    }
}

