/*
 * Decompiled with CFR 0.152.
 */
package de.redgames.f3nperm.provider;

import de.redgames.f3nperm.F3NPermPlugin;
import de.redgames.f3nperm.provider.Provider;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public abstract class NettyProvider
implements Provider,
Listener {
    private final Map<Player, F3NPermChannelHandler> playerHandlers = new HashMap<Player, F3NPermChannelHandler>();
    private F3NPermPlugin plugin;

    public abstract void sendPacket(Player var1);

    public abstract void adjustPacket(Player var1, Object var2);

    public abstract Channel getChannel(Player var1);

    @Override
    public void update(Player player) {
        this.sendPacket(player);
    }

    @Override
    public void register(F3NPermPlugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public void unregister(F3NPermPlugin plugin) {
        HandlerList.unregisterAll((Listener)this);
        for (F3NPermChannelHandler handler : this.playerHandlers.values()) {
            handler.unregister();
        }
        this.playerHandlers.clear();
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        F3NPermChannelHandler handler = this.playerHandlers.get(player);
        if (handler == null) {
            Channel channel = this.getChannel(player);
            F3NPermChannelHandler newHandler = new F3NPermChannelHandler(player, channel);
            newHandler.register();
            this.playerHandlers.put(player, newHandler);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        F3NPermChannelHandler handler = this.playerHandlers.remove(event.getPlayer());
        if (handler != null) {
            handler.unregister();
        }
    }

    public F3NPermPlugin getPlugin() {
        return this.plugin;
    }

    public final class F3NPermChannelHandler
    extends ChannelDuplexHandler {
        private static final String NAME = "f3nperm_handler";
        private final Player player;
        private final Channel channel;

        public F3NPermChannelHandler(Player player, Channel channel) {
            this.player = player;
            this.channel = channel;
        }

        public void register() {
            this.channel.pipeline().addBefore("packet_handler", NAME, (ChannelHandler)this);
        }

        public void unregister() {
            if (this.channel.pipeline().get(NAME) != null) {
                this.channel.pipeline().remove(NAME);
            }
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            NettyProvider.this.adjustPacket(this.player, msg);
            super.write(ctx, msg, promise);
        }
    }
}

